















/*
 * This is a generated file. Do not edit this file!
 */
package weblogic.management.security.authentication;

import java.util.Map;
import java.beans.BeanInfo;

import java.beans.BeanDescriptor;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.beans.ParameterDescriptor;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;

import weblogic.management.internal.mbean.BeanInfoBinder;
import weblogic.management.internal.mbean.BeanInfoImpl;
import weblogic.management.internal.mbean.BeanInfoHelper;

import weblogic.descriptor.DescriptorBean;
import weblogic.management.commo.StandardInterface;
import weblogic.management.utils.InvalidParameterException;
import weblogic.management.utils.NotFoundException;

import weblogic.management.security.authentication.UserPasswordEditorMBean;

/**
 * @copyright Copyright (c) 2003,2014, Oracle and/or its affiliates. All rights reserved.
 * @author Copyright (c) 2003,2014, Oracle and/or its affiliates. All rights reserved.
 * @version 0.1
 */
public class UserPasswordEditorMBeanImplBeanInfo
  extends weblogic.management.commo.AbstractCommoConfigurationBeanImplBeanInfo
{

  public UserPasswordEditorMBeanImplBeanInfo(boolean readOnly, String targetVersion)
      throws IntrospectionException {
    super(readOnly, targetVersion);
  }
  // constructor
  public UserPasswordEditorMBeanImplBeanInfo()
    throws IntrospectionException {

  }


  public static final Class INTERFACE_CLASS = weblogic.management.security.authentication.UserPasswordEditorMBean.class;


  protected BeanDescriptor buildBeanDescriptor() {

    Class beanClass = null;
    try {
      beanClass = Class.forName("weblogic.management.security.authentication.UserPasswordEditorMBeanImpl");
    } catch (Throwable ignore) {
      beanClass = INTERFACE_CLASS;
    }
    
    BeanDescriptor beanDescriptor =
      new BeanDescriptor(  beanClass, null /*customizer*/ );

    beanDescriptor.setValue("abstract",Boolean.TRUE);
    beanDescriptor.setValue("VisibleToPartitions", "ALWAYS");
    beanDescriptor.setValue("owner", "RealmAdministrator");
     beanDescriptor.setValue("package","weblogic.management.security.authentication");
    String description = new String(
          
           "<p>Provides two methods for changing a user's password. An Authentication provider " + 
           "MBean can optionally implement this MBean. The WebLogic Server Administration Console " + 
           "detects when an Authentication provider implements this MBean and automatically provides " + 
           "a tab for using these methods.</p> " + 
           " " + 
           "<p>CSS v4 introduced a new Password Validaton Service to check password against a set of rules when doing " + 
           "changing password operations with authentication provider MBeans such as <code>createUser</code>, <code>changeUserPassword</code> " + 
           "and <code>resetUserPassword</code>. The rules can be specified through configuring Password Validation Provider into the " + 
           "security realm, for further information, see <code>weblogic.management.security.RealmMBean</code>.</p> " + 
           " " + 
           "<p>All OOTB authentication providers in CSS will automatically call the Password Validation Service if their MBeans inherit " + 
           "<code>UserPasswordEditorMBean</code> interface. The service is also available for all those customized authentication " + 
           "providers whose MBeans inherit <code>UserPasswordEditorMBean</code>, to introduce the Password Validation Service into a " + 
           "customized authentication proivder, the following approach must be met:</p> " + 
           "<ol> " + 
           "<li> " + 
           "<p>In the <code>initialize</code> method of a customized provider implementation, must retrieve the Password Validation " + 
           "Service and register the service into a helper class such as <code>weblogic.security.provider.authentication.AuthenticationSecurityHelper</code>, " + 
           "the code might like as below:</p> " + 
           " " + 
           "<p><code> " + 
           "import com.bea.common.security.service.PasswordValidationService;<br> " + 
           "import com.bea.common.security.legacy.ExtendedSecurityServices;<br> " + 
           "import com.bea.common.security.internal.legacy.helper.PasswordValidationServiceConfigHelper;<br> " + 
           "import weblogic.security.provider.authentication.AuthenticationSecurityHelper;<br> " + 
           "......<br> " + 
           "ExtendedSecurityServices extendedSecurityServices = (ExtendedSecurityServices)securityServices;<br> " + 
           "PasswordValidationService serivce = (PasswordValidationService)extendedSecurityServices.getServices().getService(PasswordValidationServiceConfigHelper.getServiceName(providerMBean.getRealm()));<br> " + 
           "AuthenticationSecurityHelper.getInstance(providerMBean).registerPasswordValidationService(service);<br> " + 
           "......</code></p> " + 
           "</li> " + 
           "<li> " + 
           "<p>In the <code>createUser</code>, <code>changeUserPassword</code> and(or) <code>resetUserPassword</code> methods of a customized authentication " + 
           "provider MBean, call the helper class to validate the new password to determine if the new password is valid. The code might be:</p> " + 
           " " + 
           "<p><code> " + 
           "import weblogic.security.provider.authentication.AuthenticationSecurityHelper;<br> " + 
           ".....<br> " + 
           "AuthenticationSecurityHelper.getInstance(providerMBean).validatePassword(userName,password);<br> " + 
           ".....</code></p> " + 
           "</li> " + 
           "</ol> " +  ""    ).intern();
    beanDescriptor.setShortDescription(description);
    beanDescriptor.setValue("description", description);
    beanDescriptor.setValue("interfaceclassname",  "weblogic.management.security.authentication.UserPasswordEditorMBean");
    beanDescriptor.setValue("generatedByWLSInfoBinder", Boolean.TRUE);

    return beanDescriptor;
  }

  /**
   * Get the attribute infos for this class and all of it parent
   * classes combined.
   *
   * @param descriptors the set to add you descriptors to.
   */
  protected void buildPropertyDescriptors( Map descriptors )
         throws IntrospectionException {
    PropertyDescriptor currentResult = null;
    super.buildPropertyDescriptors( descriptors );
  }


  /**
   * Get the method infos for a subset of the overall methods types.
   *
   */
  private void fillinFactoryMethodInfos( Map descriptors )
         throws IntrospectionException,
                java.lang.NoSuchMethodException {

    MethodDescriptor currentResult;

  }

  /**
   * Get the method infos for a subset of the overall methods types.
   *
   */
  private void fillinCollectionMethodInfos( Map descriptors )
         throws IntrospectionException,
                java.lang.NoSuchMethodException {

    MethodDescriptor currentResult;

  }

  /**
   * Get the method infos for a subset of the overall methods types.
   *
   */
  private void fillinFinderMethodInfos( Map descriptors )
         throws IntrospectionException,
                java.lang.NoSuchMethodException {

    MethodDescriptor currentResult;

  }

  /**
   * Get the method infos for a subset of the overall methods types.
   *
   */
  private void fillinOperationMethodInfos( Map descriptors )
         throws IntrospectionException,
                java.lang.NoSuchMethodException {

    MethodDescriptor currentResult;

    // METHOD changeUserPassword
    {
      java.lang.reflect.Method mth = weblogic.management.security.authentication.UserPasswordEditorMBean.class.getMethod("changeUserPassword",
         new Class[]{
           String.class,
           String.class,
           String.class,
         }
      );

      ParameterDescriptor[] parameterDescriptors = new ParameterDescriptor[3];
      parameterDescriptors[0] =
        createParameterDescriptor( "userName",
    
                                 "- The name of an existing user. " +  "" );
      parameterDescriptors[1] =
        createParameterDescriptor( "oldPassword",
    
                                 "- The current password for the user. " +  "" );
      parameterDescriptors[2] =
        createParameterDescriptor( "newPassword",
    
                                 "- The new password for the user. " + 
                                 "The Authentication provider determines the syntax requirements for passwords. " +  "" );

      String methodKey = BeanInfoHelper.buildMethodKey(mth);
      if (!descriptors.containsKey(methodKey))
      {
      currentResult =
        new MethodDescriptor( mth, parameterDescriptors);
       descriptors.put(methodKey,currentResult);

      currentResult.setValue("description",     
           "Used by a user to change his or her password. " +  "");

       currentResult.setValue("role", "operation");
      currentResult.setValue("wls:auditProtectedArgs","2,3");
      }
    }
    // METHOD resetUserPassword
    {
      java.lang.reflect.Method mth = weblogic.management.security.authentication.UserPasswordEditorMBean.class.getMethod("resetUserPassword",
         new Class[]{
           String.class,
           String.class,
         }
      );

      ParameterDescriptor[] parameterDescriptors = new ParameterDescriptor[2];
      parameterDescriptors[0] =
        createParameterDescriptor( "userName",
    
                                 "- The name of an existing user. " +  "" );
      parameterDescriptors[1] =
        createParameterDescriptor( "newPassword",
    
                                 "- The new password for the user. " + 
                                 "The Authentication provider determines the syntax requirements for passwords. " +  "" );

      String methodKey = BeanInfoHelper.buildMethodKey(mth);
      if (!descriptors.containsKey(methodKey))
      {
      currentResult =
        new MethodDescriptor( mth, parameterDescriptors);
       descriptors.put(methodKey,currentResult);

      currentResult.setValue("description",     
           "Used by an administrator to change a user's password. " +  "");

       currentResult.setValue("role", "operation");
      currentResult.setValue("wls:auditProtectedArgs","2");
      }
    }
  }

  /**
   * Get the method infos for this class and all of it parent
   * classes combined.
   *
   * @param descriptors the set to add to.
   */
  protected void buildMethodDescriptors( Map descriptors )
         throws IntrospectionException,
                java.lang.NoSuchMethodException {

    fillinFinderMethodInfos(descriptors);
    if ( !readOnly ) {
      fillinCollectionMethodInfos(descriptors);
      fillinFactoryMethodInfos(descriptors);
    }
    fillinOperationMethodInfos(descriptors);
     super.buildMethodDescriptors(descriptors);
  }

  /**
    * Get the event infos for this class and all of it parent
    * classes combined.
    *
    * @param descriptors the set to add to.
    */
  protected void buildEventSetDescriptors(  Map descriptors )
       throws IntrospectionException {
    // TODO: this is not yet implemented
  }
}
