/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.client;

import java.lang.reflect.Constructor;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.security.AccessControlException;
import java.security.Permission;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Object;
import org.omg.DynamicAny.DynAnyFactoryHelper;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactory;
import org.omg.IOP.CodecFactoryHelper;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.IOP.Encoding;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.CurrentHelper;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitInfoPackage.InvalidName;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import weblogic.corba.client.GetORBUtil;
import weblogic.corba.client.cluster.ClusterInterceptor;
import weblogic.corba.client.invocation.RequestUrlContextInterceptor;
import weblogic.corba.client.naming.ClientORBHelper;
import weblogic.corba.client.naming.ReferenceHelperImpl;
import weblogic.corba.client.security.SecurityInterceptor;
import weblogic.corba.client.security.SubjectManagerImpl;
import weblogic.corba.client.spi.ServiceManager;
import weblogic.corba.client.transaction.TransactionHelperImpl;
import weblogic.corba.client.transaction.TransactionInterceptor;
import weblogic.corba.client.utils.ContextInterceptor;
import weblogic.corba.client.utils.DisconnectMonitorImpl;
import weblogic.corba.client.utils.VersionInterceptor;
import weblogic.corba.j2ee.naming.ORBHelper;
import weblogic.jndi.security.internal.client.ClientSubjectPusher;
import weblogic.rmi.extensions.DisconnectListener;
import weblogic.rmi.extensions.DisconnectMonitor;
import weblogic.rmi.extensions.DisconnectMonitorUnavailableException;
import weblogic.rmi.extensions.server.DisconnectMonitorProvider;
import weblogic.rmi.extensions.server.ReferenceHelper;
import weblogic.security.subject.SubjectManager;
import weblogic.transaction.TransactionHelper;

public class ClientORBInitializer
extends LocalObject
implements ORBInitializer {
    private static final boolean DEBUG = ClientORBInitializer.getDebug();
    private static boolean initialized = false;
    private static DisconnectMonitor dm;

    private static final boolean getDebug() {
        try {
            return Boolean.getBoolean("weblogic.debug.client.startup");
        }
        catch (Exception e) {
            return false;
        }
    }

    public static final synchronized void initialize() {
        if (!initialized) {
            ReferenceHelper.setReferenceHelper(new ReferenceHelperImpl());
            ORBHelper.setORBHelper(new ClientORBHelper());
            try {
                TransactionHelper.getTransactionHelper();
            }
            catch (IllegalArgumentException iae) {
                TransactionHelper.setTransactionHelper(new TransactionHelperImpl());
            }
            ServiceManager.setSecurityManager(new ClientSubjectPusher());
            try {
                if (!SubjectManagerImpl.isSubjectManagerInstalled()) {
                    SubjectManager.setSubjectManager(new SubjectManagerImpl());
                }
            }
            catch (AccessControlException ace) {
                throw new Error("Setting of SubjectManager failed. " + ace);
            }
            dm = new DisconnectMonitorThing();
            try {
                if (System.getSecurityManager() == null) {
                    System.setSecurityManager(new RMISecurityManager(){

                        @Override
                        public void checkPermission(Permission perm) {
                        }
                    });
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            initialized = true;
        }
    }

    public static final DisconnectMonitor getDisconnectMonitor() {
        return dm;
    }

    public void pre_init(ORBInitInfo info) {
        if (DEBUG) {
            ClientORBInitializer.p("pre_init()");
        }
        if (!initialized) {
            ClientORBInitializer.initialize();
        }
    }

    public void post_init(ORBInitInfo info) {
        if (DEBUG) {
            ClientORBInitializer.p("post_init()");
        }
        try {
            Current piCurrent = this.getPICurrent(info);
            Codec codec = this.createCodec(info);
            this.addClusterInterceptor(info, piCurrent, codec);
            this.addTransactionInterceptor(info, piCurrent, codec);
            this.addSecurityInitializer(info, piCurrent, codec);
            this.addVersionInterceptor(info, piCurrent, codec);
            this.addContextInterceptor(info, codec);
            this.addRequestUrlInterceptor(info, codec);
        }
        catch (Throwable t) {
            throw this.createInternalException(t);
        }
    }

    private void addRequestUrlInterceptor(ORBInitInfo info, Codec codec) throws DuplicateName {
        RequestUrlContextInterceptor interceptor = new RequestUrlContextInterceptor(codec);
        info.add_client_request_interceptor((ClientRequestInterceptor)interceptor);
    }

    private INTERNAL createInternalException(Throwable t) {
        if (DEBUG) {
            t.printStackTrace();
        }
        INTERNAL obj = new INTERNAL(t.getMessage());
        obj.initCause(t);
        return obj;
    }

    private Current getPICurrent(ORBInitInfo info) throws InvalidName {
        return CurrentHelper.narrow((Object)info.resolve_initial_references("PICurrent"));
    }

    private Codec createCodec(ORBInitInfo info) throws InvalidName, UnknownEncoding {
        CodecFactory codecFactory = CodecFactoryHelper.narrow((Object)info.resolve_initial_references("CodecFactory"));
        Encoding encoding = new Encoding(0, 1, 2);
        return codecFactory.create_codec(encoding);
    }

    private void addContextInterceptor(ORBInitInfo info, Codec codec) throws Exception {
        ContextInterceptor ctx = new ContextInterceptor(codec, DynAnyFactoryHelper.narrow((Object)info.resolve_initial_references("DynAnyFactory")));
        info.add_client_request_interceptor((ClientRequestInterceptor)ctx);
        info.register_initial_reference(ctx.name(), (Object)ctx);
        if (DEBUG) {
            ClientORBInitializer.p("ContextInterceptor created");
        }
    }

    private void addVersionInterceptor(ORBInitInfo info, Current piCurrent, Codec codec) throws DuplicateName, InvalidName {
        VersionInterceptor vi = new VersionInterceptor(codec, GetORBUtil.getOrb(piCurrent));
        info.add_client_request_interceptor((ClientRequestInterceptor)vi);
        info.add_server_request_interceptor((ServerRequestInterceptor)vi);
        info.register_initial_reference(vi.name(), (Object)vi);
    }

    private void addSecurityInitializer(ORBInitInfo info, Current piCurrent, Codec codec) throws DuplicateName, InvalidName {
        int secSlot = info.allocate_slot_id();
        SecurityInterceptor sec = new SecurityInterceptor(piCurrent, codec, secSlot);
        info.add_client_request_interceptor((ClientRequestInterceptor)sec);
        info.register_initial_reference(sec.name(), (Object)sec);
        if (DEBUG) {
            ClientORBInitializer.p("SecurityInterceptor created on slot " + secSlot);
        }
    }

    private void addTransactionInterceptor(ORBInitInfo info, Current piCurrent, Codec codec) throws DuplicateName, InvalidName {
        int txSlot = info.allocate_slot_id();
        TransactionInterceptor tx = new TransactionInterceptor(piCurrent, codec, txSlot);
        info.add_client_request_interceptor((ClientRequestInterceptor)tx);
        info.register_initial_reference(tx.name(), (Object)tx);
        if (DEBUG) {
            ClientORBInitializer.p("TransactionInterceptor created on slot " + txSlot);
        }
    }

    private void addClusterInterceptor(ORBInitInfo info, Current piCurrent, Codec codec) throws DuplicateName, InvalidName {
        int clusterSlot = info.allocate_slot_id();
        ClusterInterceptor clust = new ClusterInterceptor(piCurrent, codec, clusterSlot);
        info.add_client_request_interceptor((ClientRequestInterceptor)clust);
        info.register_initial_reference(clust.name(), (Object)clust);
        if (DEBUG) {
            ClientORBInitializer.p("ClusterInterceptor created on slot " + clusterSlot);
        }
    }

    private static void installServiceInterceptor(String name, ORBInitInfo info, Current piCurrent, Codec codec) {
        try {
            int slot = info.allocate_slot_id();
            Class<?> interclass = Class.forName(name);
            Class[] args = new Class[]{Current.class, Codec.class, Integer.class};
            Constructor<?> con = interclass.getDeclaredConstructor(args);
            ClientRequestInterceptor cri = (ClientRequestInterceptor)con.newInstance(piCurrent, codec, new Integer(slot));
            info.add_client_request_interceptor(cri);
        }
        catch (Exception e) {
            ClientORBInitializer.p("Error: " + name + " not installed: " + e.getMessage());
        }
    }

    protected static void p(String s) {
        System.err.println("<ClientORBInitializer> " + s);
    }

    private static class DisconnectMonitorThing
    implements DisconnectMonitor {
        private DisconnectMonitorProvider dm = new DisconnectMonitorImpl();

        private DisconnectMonitorThing() {
        }

        @Override
        public void addDisconnectListener(Remote remoteObject, DisconnectListener listener) throws DisconnectMonitorUnavailableException {
            if (!this.dm.addDisconnectListener(remoteObject, listener)) {
                throw new DisconnectMonitorUnavailableException("Could not add [" + remoteObject + "]");
            }
        }

        @Override
        public void removeDisconnectListener(Remote remoteObject, DisconnectListener listener) throws DisconnectMonitorUnavailableException {
            if (!this.dm.removeDisconnectListener(remoteObject, listener)) {
                throw new DisconnectMonitorUnavailableException("Could not remove [" + remoteObject + "]");
            }
        }
    }
}

