/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.client.cluster;

import java.io.IOException;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.ForwardRequest;
import weblogic.corba.client.cluster.ClusterComponent;
import weblogic.corba.client.cluster.ClusterComponentHelper;
import weblogic.corba.client.cluster.TargetInfo;
import weblogic.corba.client.cluster.VendorInfoCluster;
import weblogic.corba.client.cluster.VendorInfoClusterHelper;

public final class ClusterInterceptor
extends LocalObject
implements ClientRequestInterceptor {
    static final int TAG_WLS_CLUSTER_KEY = 1111834883;
    static final int VENDOR_INFO_CLUSTER = 1111834883;
    static final String COMM_FAILURE_ID = "IDL:omg.org/CORBA/COMM_FAILURE:1.0";
    static final String MARSHAL_ID = "IDL:omg.org/CORBA/MARSHAL:1.0";
    static final String OBJECT_NOT_EXIST_ID = "IDL:omg.org/CORBA/OBJECT_NOT_EXIST:1.0";
    static final String BAD_PARAM_ID = "IDL:omg.org/CORBA/BAD_PARAM:1.0";
    private static final boolean DEBUG = ClusterInterceptor.getDebug();
    private Current piCurrent;
    private Codec codec;
    private int slot;

    private static boolean getDebug() {
        try {
            return Boolean.getBoolean("weblogic.debug.client.cluster");
        }
        catch (Exception e) {
            return false;
        }
    }

    public ClusterInterceptor(Current piCurrent, Codec codec, int slot) {
        this.piCurrent = piCurrent;
        this.codec = codec;
        this.slot = slot;
    }

    public String name() {
        return "ClusterInterceptor";
    }

    public void destroy() {
    }

    public void send_request(ClientRequestInfo ri) throws ForwardRequest {
        block8: {
            if (DEBUG) {
                ClusterInterceptor.p("send_request(effective: " + ClusterInterceptor.printObject(ri.effective_target()) + ", target: " + ClusterInterceptor.printObject(ri.target()) + "." + ri.operation() + ")");
            }
            try {
                Object o;
                TargetInfo ti = TargetInfo.findTargetInfo(ri.effective_target());
                if (ti == null) {
                    ti = TargetInfo.findOrCreateTargetInfo(ri.effective_target(), this.getClusterComponent(ri), this.codec);
                }
                if ((o = this.loadBalance(ri)) != null && o != ri.effective_target()) {
                    if (DEBUG) {
                        ClusterInterceptor.p("forwarding to: " + ClusterInterceptor.printObject(o));
                    }
                    throw new ForwardRequest(o);
                }
                if (ti != null && ti != TargetInfo.NULL_TARGET_INFO) {
                    if (DEBUG) {
                        ClusterInterceptor.p("sending version: " + ti.getVersion() + " for " + ri.operation() + "()");
                    }
                    ri.add_request_service_context(ti.getVersionContext(), true);
                }
            }
            catch (FormatMismatch | TypeMismatch tm) {
                if (!DEBUG) break block8;
                ClusterInterceptor.p("bad cluster key in request target for: " + ri.operation() + "()");
            }
        }
    }

    public void send_poll(ClientRequestInfo ri) {
        if (DEBUG) {
            ClusterInterceptor.p("send_poll(" + ri.operation() + ")");
        }
    }

    public void receive_reply(ClientRequestInfo ri) {
        block4: {
            if (DEBUG) {
                ClusterInterceptor.p("receive_reply(" + ri.operation() + ")");
            }
            try {
                VendorInfoCluster vic = this.getClusterContext(ri);
                TargetInfo.updateTargetInfo(ri.effective_target(), vic, this.codec);
                if (DEBUG && vic != null) {
                    ClusterInterceptor.p("updated version: " + vic.version + " for " + vic.replicas.length + " entries");
                }
            }
            catch (FormatMismatch | TypeMismatch tm) {
                if (!DEBUG) break block4;
                ClusterInterceptor.p("bad cluster context in request target for: " + ri.operation() + "()");
            }
        }
    }

    public void receive_exception(ClientRequestInfo ri) throws ForwardRequest {
        Object o;
        if (DEBUG) {
            ClusterInterceptor.p("receive_exception(" + ri.operation() + ")");
        }
        if ((o = this.failOver(ri)) != null && o != ri.effective_target()) {
            if (DEBUG) {
                ClusterInterceptor.p("failing over to: " + ClusterInterceptor.printObject(o));
            }
            throw new ForwardRequest(o);
        }
        if (DEBUG) {
            ClusterInterceptor.p("couldn't fail over");
        }
    }

    public void receive_other(ClientRequestInfo ri) {
        if (DEBUG) {
            ClusterInterceptor.p("receive_other(" + ri.operation() + ")");
        }
    }

    public Object loadBalance(ClientRequestInfo ri) {
        TargetInfo ti = TargetInfo.findTargetInfo(ri.effective_target());
        if (ti == null || ti == TargetInfo.NULL_TARGET_INFO || ti.onlyOneTarget()) {
            if (DEBUG) {
                ClusterInterceptor.p("target info was null or useless");
            }
            return null;
        }
        if (ti.invoking()) {
            ti.setInvoking(false);
            if (DEBUG) {
                ClusterInterceptor.p("already invoking");
            }
            return null;
        }
        Object next = ti.selectNextTarget();
        if (next == null) {
            if (DEBUG) {
                ClusterInterceptor.p("target for: " + ri.operation() + "() unchanged");
            }
            return null;
        }
        ti.setInvoking(true);
        if (DEBUG) {
            ClusterInterceptor.p("got target info for: " + ri.operation() + "()");
        }
        return next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object failOver(ClientRequestInfo ri) {
        if (ri.reply_status() == 1) {
            Any ex = ri.received_exception();
            InputStream in = ex.create_input_stream();
            String name = in.read_string();
            int minor = in.read_long();
            int completed = in.read_long();
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (name.equals(COMM_FAILURE_ID) || name.equals(MARSHAL_ID) || name.equals(OBJECT_NOT_EXIST_ID) || name.equals(BAD_PARAM_ID) && minor == 1330446344) {
                TargetInfo ti;
                if (DEBUG) {
                    ClusterInterceptor.p("failOver(): received " + name + " exception for " + ri.operation() + "()");
                }
                if ((ti = TargetInfo.findTargetInfo(ri.effective_target())) == null || ti == TargetInfo.NULL_TARGET_INFO) {
                    return null;
                }
                TargetInfo targetInfo = ti;
                synchronized (targetInfo) {
                    ti = TargetInfo.findTargetInfo(ri.effective_target());
                    if (ti == null || ti == TargetInfo.NULL_TARGET_INFO) {
                        return null;
                    }
                    ti.removeMember(ri.effective_target());
                    if (DEBUG) {
                        ClusterInterceptor.p("failOver(): " + ti.getReplicas().length + " replicas to choose from, " + completed + " " + ti.clusterComponent.idempotent);
                    }
                    if (ti.getReplicas() != null && ti.getReplicas().length > 0 && (completed == 1 || completed == 2 && ti.clusterComponent.idempotent)) {
                        ti.setInvoking(true);
                        return ti.selectFailoverTarget();
                    }
                    return null;
                }
            }
        }
        return null;
    }

    private ClusterComponent getClusterComponent(ClientRequestInfo ri) throws TypeMismatch, FormatMismatch {
        try {
            if (DEBUG) {
                ClusterInterceptor.p("looking for cluster component for " + ClusterInterceptor.printObject(ri.effective_target()));
            }
            TaggedComponent clustcomp = ri.get_effective_component(1111834883);
            Any a = this.codec.decode_value(clustcomp.component_data, ClusterComponentHelper.type());
            ClusterComponent cc = ClusterComponentHelper.extract(a);
            if (DEBUG) {
                ClusterInterceptor.p("found cluster component " + (cc.replicas == null ? 0 : cc.replicas.length) + " replicas, algorithm `" + cc.algorithm + "', version " + cc.version);
            }
            return cc;
        }
        catch (BAD_PARAM bpe) {
            if (bpe.minor != 1330446364) {
                if (DEBUG) {
                    bpe.printStackTrace();
                }
                throw bpe;
            }
            return null;
        }
    }

    private VendorInfoCluster getClusterContext(ClientRequestInfo ri) throws TypeMismatch, FormatMismatch {
        try {
            ServiceContext clustsc = ri.get_reply_service_context(1111834883);
            if (DEBUG) {
                ClusterInterceptor.p("found cluster context for " + ri.operation() + "()");
            }
            Any a = this.codec.decode_value(clustsc.context_data, VendorInfoClusterHelper.type());
            return VendorInfoClusterHelper.extract(a);
        }
        catch (BAD_PARAM bpe) {
            if (bpe.minor != 1330446362) {
                if (DEBUG) {
                    bpe.printStackTrace();
                }
                throw bpe;
            }
            return null;
        }
    }

    protected static void p(String s) {
        System.err.println("<ClusterInterceptor> " + s);
    }

    private static final Delegate delegate(Object obj) {
        return ((ObjectImpl)obj)._get_delegate();
    }

    static final String printObject(Object o) {
        if (o == null) {
            return "<null>";
        }
        StringBuilder sb = new StringBuilder("<Typeids: [");
        String[] ids = ((ObjectImpl)o)._ids();
        if (ids.length > 0) {
            for (int i = 0; i < ids.length - 1; ++i) {
                sb.append(ids[i]);
                sb.append("; ");
            }
            sb.append(ids[ids.length - 1]);
        }
        sb.append("], Stub: ");
        return sb.append(o.getClass().getName()).append(">: ").append(ClusterInterceptor.printObject(ClusterInterceptor.delegate(o))).toString();
    }

    static String printObject(Delegate o) {
        return "<" + Integer.toHexString(o.hashCode()) + ">";
    }
}

