/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.client.http;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import weblogic.corba.client.http.TunneledServerSocket;
import weblogic.corba.client.http.TunneledSocket;
import weblogic.corba.client.iiop.BiDirSocketFactory;

public class TunneledSocketFactory
extends BiDirSocketFactory {
    private String scheme;
    protected int tunnelPort;
    protected String tunnelHost;
    private Hashtable clusterMembers = new Hashtable();
    private String tunnelCookiePrefix;
    private static Hashtable tunnelTable = new Hashtable();
    private HashMap<String, ArrayList<String>> closedConnections = new HashMap();
    static final String HTTP_SCHEME = "http";

    public TunneledSocketFactory() {
        if (DEBUG) {
            TunneledSocketFactory.p("initialized");
        }
        this.scheme = HTTP_SCHEME;
    }

    public void setProtocolName(String s) {
        this.scheme = s;
    }

    public String getProtocolName() {
        return this.scheme;
    }

    public Hashtable getClusterMembers() {
        return this.clusterMembers;
    }

    public void setClusterMembers(Hashtable ht) {
        this.clusterMembers = ht;
    }

    public String getTunnelHost() {
        return this.tunnelHost;
    }

    public int getTunnelPort() {
        return this.tunnelPort;
    }

    public String getTunnelCookiePrefix() {
        return this.tunnelCookiePrefix;
    }

    public void setTunnelCookiePrefix(String s) {
        this.tunnelCookiePrefix = s;
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        if (DEBUG) {
            TunneledSocketFactory.p("createServerSocket(" + port + ")");
        }
        TunneledServerSocket ssock = new TunneledServerSocket(port, this);
        return ssock;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        this.setTunnel(host, port);
        if (DEBUG) {
            TunneledSocketFactory.p("createSocket(" + this.tunnelHost + ":" + this.tunnelPort + " -> " + host + ":" + port + ")");
        }
        return new TunneledSocket(this.tunnelHost, this.tunnelPort, host, port, this);
    }

    protected static void p(String s) {
        System.err.println("<TunneledSocketFactory> " + s);
    }

    protected void setTunnel(String host, int port) {
        String tunnel = (String)tunnelTable.get(host + ":" + port);
        if (this.tunnelHost == null) {
            if (tunnel != null) {
                int idx = tunnel.indexOf(58);
                this.tunnelHost = tunnel.substring(0, idx);
                this.tunnelPort = Integer.parseInt(tunnel.substring(idx + 1));
            } else {
                this.tunnelHost = host;
                this.tunnelPort = port;
            }
        }
        if (tunnel == null) {
            tunnelTable.put(host + ":" + port, this.tunnelHost + ":" + this.tunnelPort);
        }
    }

    public void addClosedConnection(String serverid, String connectionID) {
        ArrayList<String> al = this.closedConnections.get(serverid);
        if (al == null) {
            al = new ArrayList();
            this.closedConnections.put(serverid, al);
        }
        al.add(connectionID);
    }

    public void clearClosedConnections(String serverID) {
        this.closedConnections.remove(serverID);
    }

    public ArrayList<String> getClosedConnections(String serverID) {
        return this.closedConnections.get(serverID);
    }

    public String getClosedConnectionsServerID() {
        if (this.closedConnections.isEmpty()) {
            return null;
        }
        return this.closedConnections.keySet().iterator().next();
    }
}

