/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.client.http;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ProtocolException;
import java.net.SocketAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import weblogic.corba.client.http.TunneledSocketFactory;
import weblogic.corba.client.http.UrlConnectionFactory;
import weblogic.corba.client.iiop.BiDirSocketFactory;
import weblogic.corba.client.iiop.BiDirSocketImpl;
import weblogic.corba.iiop.http.TunnelUtils;
import weblogic.kernel.KernelStatus;

public class TunneledSocketImpl
extends BiDirSocketImpl {
    private String connectionID;
    private String backendServerID;
    private String host;
    private int port;
    private Hashtable cookies = new Hashtable();
    private static final String TUNNELING_URL_EXTENSION = "/a.tun";
    private static final int READ_PIPE_SIZE = 1024;
    private static UrlConnectionFactory urlConnectionFactory = new UrlConnectionFactory(){

        @Override
        public URLConnection createUrlConnection(URL url) throws IOException {
            return url.openConnection();
        }
    };
    private static final boolean DEBUG = TunneledSocketImpl.getDebug();
    private static final Properties customHeaders = TunneledSocketImpl.getCustomHeaders();

    private static boolean getDebug() {
        try {
            return Boolean.getBoolean("weblogic.debug.client.http");
        }
        catch (Exception e) {
            return false;
        }
    }

    private static Properties getCustomHeaders() {
        try {
            String allProps = System.getProperty("weblogic.corba.client.customHeaders");
            return TunnelUtils.getProperties(allProps);
        }
        catch (Exception e) {
            return null;
        }
    }

    private TunneledSocketFactory getTunnelFactory() {
        if (this.factory instanceof TunneledSocketFactory) {
            return (TunneledSocketFactory)this.factory;
        }
        return null;
    }

    public TunneledSocketImpl(BiDirSocketFactory factory, String h, int p) {
        super(factory);
        this.host = h;
        this.port = p;
    }

    protected TunneledSocketImpl(TunneledSocketImpl impl, boolean server) throws IOException {
        super(impl, server);
    }

    public void updateClusterMembers(URLConnection conn) {
        block8: {
            String clusterList = conn.getHeaderField("WL-List");
            if (clusterList == null || clusterList.length() == 0) {
                return;
            }
            String scheme = conn.getHeaderField("WL-Scheme");
            if (DEBUG) {
                this.p("updateClusterMembers() cluster list - " + clusterList);
            }
            try {
                StringTokenizer st = new StringTokenizer(clusterList, "|");
                Hashtable<String, String> ht = new Hashtable<String, String>();
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    StringTokenizer t = new StringTokenizer(token, "!");
                    String serverHash = t.nextToken();
                    String serverHost = t.nextToken();
                    try {
                        serverHost = InetAddress.getByName(serverHost).getHostAddress();
                    }
                    catch (UnknownHostException unknownHostException) {
                        // empty catch block
                    }
                    String serverPort = t.nextToken();
                    if (scheme.equals("https")) {
                        serverPort = t.nextToken();
                    }
                    ht.put(serverHost + ":" + serverPort, serverHash);
                    if (!DEBUG) continue;
                    this.p("updateClusterMembers(" + serverHost + ":" + serverPort + ")" + serverHash);
                }
                this.getTunnelFactory().setClusterMembers(ht);
            }
            catch (Exception e) {
                this.getTunnelFactory().getClusterMembers().clear();
                if (!DEBUG) break block8;
                this.p("updateClusterMembers() cannot parse cluster list - " + clusterList + " " + e.getMessage());
            }
        }
    }

    private void readCookies(URLConnection conn) {
        int i = 1;
        String name = null;
        String val = null;
        while ((val = conn.getHeaderFieldKey(i++)) != null) {
            if (!val.equalsIgnoreCase("Set-Cookie")) continue;
            val = conn.getHeaderField(i - 1);
            int idx = val.indexOf(";");
            if (idx != -1) {
                val = val.substring(0, idx);
            }
            if ((idx = val.indexOf("=")) == -1 || idx >= val.length() - 1) continue;
            name = val.substring(0, idx);
            val = val.substring(idx + 1, val.length());
            this.cookies.put(name, val);
        }
    }

    private void writeCookies(URLConnection conn) {
        Hashtable clusterMembers = this.getTunnelFactory().getClusterMembers();
        String tunnelPrefix = this.getTunnelFactory().getTunnelCookiePrefix();
        String hash = (String)clusterMembers.get(this.host + ":" + this.port);
        if (hash != null) {
            String s = (String)this.cookies.get("JSESSIONID");
            if (tunnelPrefix != null) {
                s = tunnelPrefix + hash;
                this.cookies.put("JSESSIONID", s);
            }
        }
        String cookieString = null;
        for (String key : this.cookies.keySet()) {
            cookieString = cookieString != null ? cookieString + "; " : "";
            String c = (String)this.cookies.get(key);
            if (tunnelPrefix == null && key.equals("JSESSIONID")) {
                this.getTunnelFactory().setTunnelCookiePrefix(c.substring(0, c.indexOf("!") + 1));
            }
            cookieString = cookieString + key + "=" + c;
        }
        if (DEBUG) {
            this.p("writeCookies " + cookieString);
        }
        if (cookieString != null) {
            conn.setRequestProperty("Cookie", cookieString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void connectInternal() throws IOException {
        ArrayList<String> closedIds;
        URLConnection conn = null;
        try {
            conn = this.createURLConnection("/bea_wls_internal/iiop/ClientLogin", "wl-login=" + URLEncoder.encode(this.getRawLoginParamValue(), "UTF-8"), "rand=" + TunnelUtils.getNextRandom(), "HL=12");
        }
        catch (IOException e) {
            if (DEBUG) {
                this.p(e.getMessage());
            }
            return;
        }
        TunneledSocketFactory factory = this.getTunnelFactory();
        String serverID = "";
        Hashtable ht = null;
        if (factory != null && (closedIds = factory.getClosedConnections(serverID = (ht = factory.getClusterMembers()) == null || ht.size() <= 1 ? factory.getClosedConnectionsServerID() : (String)ht.get(this.host + ":" + this.port))) != null && !closedIds.isEmpty()) {
            conn.setRequestProperty("WL-Client-closed-ids", serverID + "!" + TunnelUtils.convertListToString(closedIds, "|"));
        }
        InputStream is = null;
        try {
            is = conn.getInputStream();
            this.readCookies(conn);
            this.updateClusterMembers(conn);
            String res = conn.getHeaderField("WL-Result");
            if (res == null) {
                TunneledSocketImpl.throwProtocolException("Tunneling result unspecified - is the HTTP server at host: '" + this.host + "' and port: '" + this.port + "' a WebLogic Server?");
            }
            if (!res.equals("OK")) {
                TunneledSocketImpl.throwProtocolException("Tunneling result not OK, result: '" + res + "'");
            }
            String version = conn.getHeaderField("WL-Version");
            this.connectionID = conn.getHeaderField("Conn-Id");
            if (this.connectionID == null) {
                TunneledSocketImpl.throwProtocolException("Tunneling could not ascertain a connection ID from the server");
            }
            this.backendServerID = conn.getHeaderField("WL-Dest");
            ht = factory.getClusterMembers();
            if (serverID != null && (this.backendServerID.equals(serverID) || ht == null || !ht.containsValue(serverID))) {
                factory.clearClosedConnections(serverID);
            }
            TunnelUtils.readConnectionParams(new DataInputStream(is));
        }
        finally {
            TunnelUtils.drainStream(is);
        }
        if (DEBUG) {
            this.p("tunneled connect() succesful to host: '" + this.host + "' port: '" + this.port + "' connectionID: '" + this.connectionID + "'");
        }
    }

    private String getRawLoginParamValue() {
        return this.getTunnelFactory().getProtocolName() + " dummy WLREQS " + "12.2.1.2.0" + " dummy \n";
    }

    private URLConnection createURLConnection(String path, String ... args) throws IOException {
        String tunnelHost = this.getTunnelFactory().getTunnelHost();
        int tunnelPort = this.getTunnelFactory().getTunnelPort();
        if (tunnelHost == null) {
            tunnelHost = this.host;
            tunnelPort = this.port;
        }
        URL url = new URL(this.getTunnelFactory().getProtocolName(), tunnelHost, tunnelPort, this.createUrlString(path, args));
        URLConnection conn = urlConnectionFactory.createUrlConnection(url);
        conn.setConnectTimeout(this.factory.getTimeout());
        conn.setReadTimeout(this.factory.getTimeout());
        conn.setUseCaches(false);
        TunnelUtils.setCustomRequestProperties(customHeaders, conn);
        this.writeCookies(conn);
        if (this.backendServerID != null) {
            conn.setRequestProperty("WL-Dest", this.backendServerID);
        }
        return conn;
    }

    private String createUrlString(String servletPath, String[] params) {
        StringBuilder sb = new StringBuilder();
        sb.append(KernelStatus.getTunellingURL(servletPath));
        sb.append(TUNNELING_URL_EXTENSION);
        this.appendUrlParameters(sb, params);
        return sb.toString();
    }

    private void appendUrlParameters(StringBuilder sb, String ... params) {
        int separator = 63;
        for (String param : params) {
            sb.append((char)separator).append(param);
            separator = 38;
        }
    }

    @Override
    protected void connect(SocketAddress address, int timeout) throws IOException {
        super.connect(address, timeout);
    }

    @Override
    protected BiDirSocketImpl createServerImpl() throws IOException {
        return new TunneledSocketImpl(this, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        byte[] buf = new byte[1024];
        InputStream is = null;
        try {
            while (!this.isClosed()) {
                is = null;
                String res = null;
                int type = -1;
                while (!this.isClosed()) {
                    if (DEBUG) {
                        this.p("recv()");
                    }
                    long now = System.currentTimeMillis();
                    URLConnection conn = this.createURLConnection("/bea_wls_internal/iiop/ClientRecv", TunnelUtils.getRequestArgs(this.connectionID));
                    is = conn.getInputStream();
                    if (DEBUG) {
                        this.p("run(): got connection in " + (System.currentTimeMillis() - now) + "ms");
                    }
                    this.readCookies(conn);
                    res = conn.getHeaderField("WL-Result");
                    if (DEBUG) {
                        Iterator<Map.Entry<String, List<String>>> i = conn.getHeaderFields().entrySet().iterator();
                        String headers = "";
                        while (i.hasNext()) {
                            Map.Entry<String, List<String>> e = i.next();
                            headers = headers + "<" + e.getKey() + "=" + e.getValue() + ">, ";
                        }
                        this.p("run(): headers: " + headers);
                    }
                    if (res == null) {
                        TunneledSocketImpl.throwProtocolException("Tunneling result unspecified - is the HTTP server at host: '" + this.host + "' and port: '" + this.port + "' a WebLogic Server?");
                    } else if (res.equals("RETRY")) {
                        if (DEBUG) {
                            this.p("run(): retry request");
                        }
                        is.close();
                        continue;
                    }
                    boolean requestType = false;
                    try {
                        String typeHeader = conn.getHeaderField("WL-Type");
                        if (typeHeader != null) {
                            type = Integer.parseInt(typeHeader);
                            switch (type) {
                                case 0: 
                                case 2: 
                                case 3: {
                                    requestType = true;
                                }
                            }
                        }
                    }
                    catch (NumberFormatException typeHeader) {
                        // empty catch block
                    }
                    if (!res.equals("OK") || type < 0) {
                        TunnelUtils.drainStream(is);
                        TunneledSocketImpl.throwProtocolException("Tunneling result not OK, result: '" + res + "', id: '" + this.connectionID + "'");
                    }
                    int r = 0;
                    now = System.currentTimeMillis();
                    while ((r = is.read(buf)) >= 0) {
                        if (requestType) {
                            if (DEBUG) {
                                this.p("run(): received ServerSocket request: " + type + " " + r + " bytes in " + (System.currentTimeMillis() - now) + "ms");
                            }
                            ((TunneledSocketImpl)this.serverImpl).outpipe.write(buf, 0, r);
                        } else {
                            if (DEBUG) {
                                this.p("run(): received Socket response: " + type + " " + r + " bytes in " + (System.currentTimeMillis() - now) + "ms");
                            }
                            this.outpipe.write(buf, 0, r);
                        }
                        now = System.currentTimeMillis();
                    }
                    if (requestType) {
                        ((TunneledSocketImpl)this.serverImpl).outpipe.flush();
                    } else {
                        this.outpipe.flush();
                    }
                    is.close();
                }
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            if (DEBUG) {
                t.printStackTrace();
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            this.cleanUp();
        }
    }

    @Override
    protected void cleanUp() {
        this.getTunnelFactory().addClosedConnection(this.backendServerID, this.connectionID);
        this.factory.removeServerImpl(this.serverImpl);
        try {
            this.outpipe.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            ((TunneledSocketImpl)this.serverImpl).outpipe.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            ((TunneledSocketImpl)this.serverImpl).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void write(byte[] buf, int off, int len) throws IOException {
        if (this.isClosed()) {
            throw new IOException("The tunnel is closed");
        }
        if (DEBUG) {
            this.p("send()");
        }
        URLConnection conn = this.createURLConnection("/bea_wls_internal/iiop/ClientSend", TunnelUtils.getRequestArgs(this.connectionID));
        InputStream is = null;
        try {
            conn.setDoOutput(true);
            OutputStream os = conn.getOutputStream();
            os.write(buf, off, len);
            os.flush();
            is = conn.getInputStream();
            this.readCookies(conn);
            String res = conn.getHeaderField("WL-Result");
            if (res == null) {
                TunneledSocketImpl.throwProtocolException("Tunneling result unspecified - is the HTTP server at host: '" + this.host + "' and port: '" + this.port + "' a WebLogic Server?");
            }
            if (!res.equals("OK")) {
                TunneledSocketImpl.throwProtocolException("Tunneling result not OK, result: '" + res + "', id: '" + this.connectionID + "'");
            }
        }
        catch (Throwable throwable) {
            TunnelUtils.drainStream(is);
            throw throwable;
        }
        TunnelUtils.drainStream(is);
    }

    private final void p(String msg) {
        System.out.println("<TunneledSocketImpl (" + System.identityHashCode(this) + ")>: " + msg);
    }

    private static void throwProtocolException(String s) throws ProtocolException {
        ProtocolException p = new ProtocolException(s);
        if (DEBUG) {
            p.printStackTrace();
        }
        throw p;
    }
}

