/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.client.iiop;

import java.net.UnknownHostException;
import org.omg.CORBA.Any;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.IIOP.BiDirIIOPServiceContext;
import org.omg.IIOP.BiDirIIOPServiceContextHelper;
import org.omg.IIOP.ListenPoint;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;

public final class BiDirInterceptor
extends LocalObject
implements ClientRequestInterceptor {
    private static final boolean DEBUG = BiDirInterceptor.getDebug();
    public static final String NAME = "BiDirInterceptor";
    private final Codec codec;
    private ServiceContext info;
    private ListenPoint listenPoint = null;
    private Runnable deferredRegistration;
    private static final int BI_DIR_IIOP = 5;

    private static final boolean getDebug() {
        try {
            return Boolean.getBoolean("weblogic.debug.client.iiop");
        }
        catch (Exception e) {
            return false;
        }
    }

    public BiDirInterceptor(Codec codec) throws UnknownHostException {
        this.codec = codec;
    }

    final synchronized void setListenPoint(ORB orb, ListenPoint point) {
        byte[] cdr;
        block3: {
            cdr = null;
            try {
                Any a = orb.create_any();
                if (DEBUG) {
                    BiDirInterceptor.p("listen point is: " + point.host + ":" + point.port);
                }
                BiDirIIOPServiceContextHelper.insert(a, new BiDirIIOPServiceContext(new ListenPoint[]{point}));
                cdr = this.codec.encode_value(a);
            }
            catch (InvalidTypeForEncoding itfee) {
                if (!DEBUG) break block3;
                BiDirInterceptor.p("couldn't marshal BiDir context");
            }
        }
        this.info = new ServiceContext(5, cdr);
        this.listenPoint = point;
    }

    final synchronized void setDeferredRegistration(Runnable r) {
        this.deferredRegistration = r;
    }

    public String name() {
        return NAME;
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send_request(ClientRequestInfo ri) throws ForwardRequest {
        if (DEBUG) {
            BiDirInterceptor.p("send_request(<" + Integer.toHexString(ri.effective_target()._hash(Integer.MAX_VALUE)) + ">." + ri.operation() + "): " + this.listenPoint);
        }
        if (this.listenPoint != null) {
            ri.add_request_service_context(this.info, true);
        }
        if (this.deferredRegistration != null) {
            BiDirInterceptor biDirInterceptor = this;
            synchronized (biDirInterceptor) {
                if (this.deferredRegistration != null) {
                    Runnable toregister = this.deferredRegistration;
                    this.deferredRegistration = null;
                    toregister.run();
                }
            }
        }
    }

    public void send_poll(ClientRequestInfo ri) {
        if (DEBUG) {
            BiDirInterceptor.p("send_poll(" + ri.operation() + ")");
        }
    }

    public void receive_reply(ClientRequestInfo ri) {
        if (DEBUG) {
            BiDirInterceptor.p("receive_reply(" + ri.operation() + ")");
        }
    }

    public void receive_exception(ClientRequestInfo ri) throws ForwardRequest {
        if (DEBUG) {
            BiDirInterceptor.p("receive_exception(" + ri.operation() + ")");
        }
    }

    public void receive_other(ClientRequestInfo ri) {
        if (DEBUG) {
            BiDirInterceptor.p("receive_other(" + ri.operation() + ")");
        }
    }

    protected static void p(String s) {
        System.err.println("<BiDirInterceptor> " + s);
    }
}

