/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.client.iiop;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketImpl;
import weblogic.corba.client.iiop.BiDirSocket;
import weblogic.corba.client.iiop.BiDirSocketFactory;
import weblogic.corba.client.iiop.BiDirSocketImpl;

public class BiDirServerSocket
extends ServerSocket {
    private static final boolean DEBUG = BiDirServerSocket.getDebug();
    private BiDirSocketImpl myImpl = null;
    private BiDirSocketFactory factory;

    private static final boolean getDebug() {
        try {
            return Boolean.getBoolean("weblogic.debug.client.iiop");
        }
        catch (Exception e) {
            return false;
        }
    }

    public BiDirServerSocket(int port, BiDirSocketFactory factory) throws IOException {
        super(port);
        this.factory = factory;
    }

    @Override
    public int getLocalPort() {
        return this.factory.getLocalAddress().getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Socket accept() throws IOException {
        if (DEBUG) {
            BiDirServerSocket.p("accept()");
        }
        this.myImpl = this.factory.getOrQueueServerSocket(this);
        BiDirServerSocket biDirServerSocket = this;
        synchronized (biDirServerSocket) {
            while (this.myImpl == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            BiDirSocketImpl impl = this.myImpl;
            this.myImpl = null;
            if (DEBUG) {
                BiDirServerSocket.p("accept() succeeded");
            }
            return this.createSocket(impl);
        }
    }

    protected Socket createSocket(SocketImpl impl) throws IOException {
        return new BiDirSocket(impl, new InetSocketAddress(((BiDirSocketImpl)impl).getServerHost(), ((BiDirSocketImpl)impl).getServerPort()));
    }

    public synchronized void accept(BiDirSocketImpl impl) {
        if (DEBUG) {
            BiDirServerSocket.p("accept(" + impl + ")");
        }
        this.myImpl = impl;
        this.notify();
    }

    private static final void p(String msg) {
        System.out.println("<BiDirServerSocket>: " + msg);
    }
}

