/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.client.invocation;

import org.omg.CORBA.Any;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.RequestInfo;
import weblogic.corba.client.GetORBUtil;
import weblogic.corba.client.invocation.RequestUrlContext;
import weblogic.corba.client.invocation.RequestUrlContextHelper;
import weblogic.iiop.RequestUrl;

public class RequestUrlContextInterceptor
extends LocalObject
implements ClientRequestInterceptor {
    private Codec codec;

    public RequestUrlContextInterceptor(Codec codec) {
        this.codec = codec;
    }

    public void send_request(ClientRequestInfo ri) throws ForwardRequest {
        String requestUrl = RequestUrl.get();
        if (requestUrl == null) {
            return;
        }
        try {
            ri.add_request_service_context(this.createRequestUrlContext(requestUrl, ri), false);
        }
        catch (InvalidTypeForEncoding invalidTypeForEncoding) {
            // empty catch block
        }
    }

    private ServiceContext createRequestUrlContext(String requestUrl, ClientRequestInfo requestInfo) throws InvalidTypeForEncoding {
        Any a = RequestUrlContextInterceptor.getOrb(requestInfo).create_any();
        RequestUrlContextHelper.insert(a, new RequestUrlContext(requestUrl));
        byte[] cdr = this.codec.encode_value(a);
        return new ServiceContext(1111834894, cdr);
    }

    private static ORB getOrb(ClientRequestInfo requestInfo) {
        return GetORBUtil.getOrb((RequestInfo)requestInfo);
    }

    public void send_poll(ClientRequestInfo ri) {
    }

    public void receive_reply(ClientRequestInfo ri) {
    }

    public void receive_exception(ClientRequestInfo ri) throws ForwardRequest {
    }

    public void receive_other(ClientRequestInfo ri) throws ForwardRequest {
    }

    public String name() {
        return "RequestUrlContextInterceptor";
    }

    public void destroy() {
    }
}

