/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.client.security;

import java.util.Map;
import java.util.WeakHashMap;
import javax.security.auth.Subject;
import org.omg.IOP.ServiceContext;

public class ClientSecurityContext {
    private static long nextClientContextId = 0L;
    private static Map<Subject, ClientSecurityContext> statefulClientContextTable = new WeakHashMap<Subject, ClientSecurityContext>();
    private static Map<Long, Subject> contextIdToSubjectTable = new WeakHashMap<Long, Subject>();
    private long contextId;
    private ServiceContext serviceContext;

    void setServiceContext(ServiceContext contextMessage) {
        this.serviceContext = contextMessage;
    }

    ServiceContext getServiceContext() {
        return this.serviceContext;
    }

    long getContextId() {
        return this.contextId;
    }

    static synchronized ClientSecurityContext allocateClientContext(Subject subject) {
        ClientSecurityContext csc = statefulClientContextTable.get(subject);
        if (csc == null) {
            csc = new ClientSecurityContext(++nextClientContextId);
            statefulClientContextTable.put(subject, csc);
            contextIdToSubjectTable.put(csc.contextId, subject);
        }
        return csc;
    }

    private ClientSecurityContext(long contextId) {
        this.contextId = contextId;
    }

    static synchronized ClientSecurityContext getClientContext(Subject subject) {
        return statefulClientContextTable.get(subject);
    }

    static synchronized ClientSecurityContext getClientContext(long clientContextId) {
        return statefulClientContextTable.get(ClientSecurityContext.getSubjectForContextId(clientContextId));
    }

    private static Subject getSubjectForContextId(long clientContextId) {
        Subject subject = contextIdToSubjectTable.get(clientContextId);
        if (subject == null) {
            subject = ClientSecurityContext.findSubjectForContextId(clientContextId);
        }
        return subject;
    }

    private static Subject findSubjectForContextId(long clientContextId) {
        for (Map.Entry<Subject, ClientSecurityContext> entry : statefulClientContextTable.entrySet()) {
            if (entry.getValue().getContextId() != clientContextId) continue;
            contextIdToSubjectTable.put(clientContextId, entry.getKey());
            return entry.getKey();
        }
        return null;
    }

    static synchronized ClientSecurityContext removeClientContext(long contextId) {
        ClientSecurityContext csc = statefulClientContextTable.remove(ClientSecurityContext.getSubjectForContextId(contextId));
        contextIdToSubjectTable.remove(contextId);
        return csc;
    }

    static void garbageCollectEntries(long ... contextIds) {
        for (long contextID : contextIds) {
            contextIdToSubjectTable.remove(contextID);
        }
    }
}

