/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.client.security;

import org.omg.CORBA.Any;
import org.omg.CSIIOP.AS_ContextSec;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.CSIIOP.SAS_ContextSec;
import org.omg.CSIIOP.TLS_SEC_TRANS;
import org.omg.CSIIOP.TLS_SEC_TRANSHelper;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.IOP.TaggedComponent;
import weblogic.corba.cos.security.GSSUtil;

public class CompoundSecMechListImpl {
    private static final boolean DEBUG = false;
    private CompoundSecMechList mechList;
    private TLS_SEC_TRANS tlsSecTrans;
    private Codec codec;
    private static final int SUPPORTED_TYPES = 15;

    public CompoundSecMechListImpl(CompoundSecMechList csml, Codec codec) {
        this.mechList = csml;
        this.codec = codec;
    }

    public final boolean hasGSSUP() {
        if (this.mechList.mechanism_list != null) {
            for (int i = 0; i < this.mechList.mechanism_list.length; ++i) {
                AS_ContextSec ascs = this.mechList.mechanism_list[i].as_context_mech;
                if (ascs == null || ascs.target_supports == 0 || !GSSUtil.isGSSUPMech(ascs.client_authentication_mech)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean hasGSSUPIdentity() {
        if (this.mechList.mechanism_list != null) {
            for (int i = 0; i < this.mechList.mechanism_list.length; ++i) {
                SAS_ContextSec sassc = this.mechList.mechanism_list[i].sas_context_mech;
                if (sassc == null || (sassc.target_supports & 0x400) == 0) continue;
                for (int j = 0; j < sassc.supported_naming_mechanisms.length; ++j) {
                    if (!GSSUtil.isGSSUPMech(sassc.supported_naming_mechanisms[j])) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public final byte[] getGSSUPTargetName() {
        if (this.mechList.mechanism_list != null) {
            for (int i = 0; i < this.mechList.mechanism_list.length; ++i) {
                if (this.mechList.mechanism_list[i].as_context_mech.target_name == null) continue;
                return this.mechList.mechanism_list[i].as_context_mech.target_name;
            }
        }
        return null;
    }

    public final String getSecureHost() {
        TLS_SEC_TRANS tls = this.getTLSSecTrans();
        if (tls != null && tls.addresses.length > 0) {
            return tls.addresses[0].host_name;
        }
        return null;
    }

    public final int getSecurePort() {
        TLS_SEC_TRANS tls = this.getTLSSecTrans();
        if (tls != null && tls.addresses.length > 0) {
            return tls.addresses[0].port;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TLS_SEC_TRANS getTLSSecTrans() {
        if (this.tlsSecTrans != null || this.mechList.mechanism_list == null) return this.tlsSecTrans;
        for (int i = 0; i < this.mechList.mechanism_list.length; ++i) {
            TaggedComponent tlscomp = this.mechList.mechanism_list[i].transport_mech;
            if (tlscomp.tag != 36) continue;
            try {
                Any a = this.codec.decode_value(tlscomp.component_data, TLS_SEC_TRANSHelper.type());
                this.tlsSecTrans = TLS_SEC_TRANSHelper.extract(a);
                if (this.tlsSecTrans.addresses.length <= 0) continue;
            }
            catch (FormatMismatch formatMismatch) {
                continue;
            }
            catch (TypeMismatch typeMismatch) {
                // empty catch block
            }
        }
        return this.tlsSecTrans;
    }

    protected static void p(String msg) {
        System.out.println("<CompoundSecMechListImpl>: " + msg);
    }
}

