/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.client.utils;

import java.io.IOException;
import java.io.NotSerializableException;
import javax.rmi.CORBA.Util;
import org.omg.CORBA.portable.InputStream;
import weblogic.workarea.WorkContext;
import weblogic.workarea.WorkContextInput;

class ContextInputImpl
implements WorkContextInput {
    private InputStream delegate;
    private static final long BIG_ENDIAN_MARKER = 65279L;

    ContextInputImpl(InputStream in) {
        this.delegate = in;
    }

    @Override
    public String readASCII() throws IOException {
        return this.delegate.read_string();
    }

    @Override
    public WorkContext readContext() throws IOException, ClassNotFoundException {
        Class rcClass = Util.loadClass((String)this.readASCII(), null, null);
        try {
            WorkContext runtimeContext = (WorkContext)rcClass.newInstance();
            runtimeContext.readContext(this);
            return runtimeContext;
        }
        catch (InstantiationException ie) {
            throw (IOException)new NotSerializableException("WorkContext must have a public no-arg constructor").initCause(ie);
        }
        catch (IllegalAccessException iae) {
            throw (IOException)new NotSerializableException("WorkContext must have a public no-arg constructor").initCause(iae);
        }
    }

    @Override
    public String readLine() throws IOException {
        throw new UnsupportedOperationException("readLine");
    }

    @Override
    public int readInt() throws IOException {
        return this.delegate.read_long();
    }

    @Override
    public String readUTF() throws IOException {
        return this.readBigEndianUTF16String();
    }

    private String readBigEndianUTF16String() {
        int length = this.delegate.read_long() / 2;
        if (length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        long firstChar = this.delegate.read_short() & 0xFFFF;
        --length;
        if (firstChar != 65279L) {
            sb.append((char)firstChar);
        }
        while (length-- > 0) {
            sb.append((char)(this.delegate.read_short() & 0xFFFF));
        }
        return sb.toString();
    }

    @Override
    public long readLong() throws IOException {
        return this.delegate.read_longlong();
    }

    @Override
    public byte readByte() throws IOException {
        return this.delegate.read_octet();
    }

    @Override
    public short readShort() throws IOException {
        return this.delegate.read_short();
    }

    @Override
    public float readFloat() throws IOException {
        return this.delegate.read_float();
    }

    @Override
    public char readChar() throws IOException {
        return this.delegate.read_wchar();
    }

    @Override
    public void readFully(byte[] byteArray) throws IOException {
        this.delegate.read_octet_array(byteArray, 0, byteArray.length);
    }

    @Override
    public void readFully(byte[] byteArray, int n, int n1) throws IOException {
        this.delegate.read_octet_array(byteArray, n, n1);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        throw new UnsupportedOperationException("skip()");
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.delegate.read_boolean();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.delegate.read_octet();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.delegate.read_short();
    }

    @Override
    public double readDouble() throws IOException {
        return this.delegate.read_double();
    }
}

