/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.j2ee.naming;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NamingContext;
import weblogic.corba.client.spi.ServiceManager;
import weblogic.corba.j2ee.naming.ContextImpl;
import weblogic.corba.j2ee.naming.ORBHelper;
import weblogic.corba.j2ee.naming.ORBInfo;
import weblogic.corba.j2ee.naming.Utils;

public final class InitialContextFactoryImpl
implements InitialContextFactory {
    @Override
    public Context getInitialContext(Hashtable<?, ?> env) throws NamingException {
        String url = null;
        if (env != null) {
            env = (Hashtable)env.clone();
            url = (String)env.remove("java.naming.provider.url");
        }
        if (url == null) {
            url = "iiop://localhost:7001";
        }
        return InitialContextFactoryImpl.getInitialContext(env, url);
    }

    public static Context getInitialContext(Hashtable<String, java.lang.Object> env, String url) throws NamingException {
        Object nameService = InitialContextFactoryImpl.isIorUrl(url) ? InitialContextFactoryImpl.getNameServiceFromIor(url) : InitialContextFactoryImpl.getRemoteNameService(env, url);
        ContextImpl context = InitialContextFactoryImpl.createContext(env, url, nameService);
        InitialContextFactoryImpl.establishThreadEnvironment(env, context);
        return context;
    }

    private static boolean isIorUrl(String url) {
        return url.startsWith("IOR:");
    }

    private static ContextImpl createContext(Hashtable<String, java.lang.Object> env, String requestUrl, Object remoteObject) throws NamingException {
        NamingContext ctx = Utils.narrowContext(remoteObject);
        if (ctx == null) {
            throw new NamingException("Could not resolve context from: " + requestUrl);
        }
        return new ContextImpl(env, InitialContextFactoryImpl.getCachedOrbInfo(), ctx);
    }

    private static void establishThreadEnvironment(Hashtable env, ContextImpl context) throws NamingException {
        ServiceManager.getSecurityManager().pushSubject(env, context);
        InitialContextFactoryImpl.establishTransactionManagerForIiop();
    }

    private static void establishTransactionManagerForIiop() {
        InitialContextFactoryImpl.getOrbHelper().pushTransactionHelper();
    }

    private static Object getNameServiceFromIor(String url) throws NamingException {
        return InitialContextFactoryImpl.getOrb(InitialContextFactoryImpl.getCachedOrbInfo()).string_to_object(url);
    }

    private static ORB getOrb(ORBInfo orbinfo) throws NamingException {
        return orbinfo != null ? orbinfo.getORB() : InitialContextFactoryImpl.getOrbHelper().getLocalORB();
    }

    private static Object getRemoteNameService(Hashtable env, String url) throws NamingException {
        return InitialContextFactoryImpl.getOrbHelper().getORBInitialReference(url, env, "NameService");
    }

    private static boolean usesTgiopProtocol(String url) {
        return url.contains("tgiop:");
    }

    private static ORBHelper getOrbHelper() {
        return ORBHelper.getORBHelper();
    }

    private static ORBInfo getCachedOrbInfo() {
        return InitialContextFactoryImpl.getOrbHelper().getCurrent();
    }
}

