/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.j2ee.naming;

import java.util.Hashtable;

abstract class JmxAuthenticationSupport {
    private static final int JMX_CREDENTIALS_LENGTH = 2;

    JmxAuthenticationSupport() {
    }

    static boolean useJmxCredentials(Hashtable<String, Object> env) {
        return env != null && JmxAuthenticationSupport.hasNoUsernameOrPassword(env) && JmxAuthenticationSupport.hasValidJmxCredentials(env);
    }

    private static boolean hasNoUsernameOrPassword(Hashtable<String, Object> env) {
        return !env.containsKey("java.naming.security.principal") && !env.containsKey("java.naming.security.credentials");
    }

    private static boolean hasValidJmxCredentials(Hashtable<String, Object> env) {
        return env.containsKey("jmx.remote.credentials") && JmxAuthenticationSupport.isValidJmxCredentials(env.get("jmx.remote.credentials"));
    }

    private static boolean isValidJmxCredentials(Object credentials) {
        return credentials instanceof String[] && ((String[])credentials).length == 2;
    }

    static void establishJmxCredentials(Hashtable<String, Object> env) {
        String[] jmxCredentials = (String[])env.get("jmx.remote.credentials");
        env.put("java.naming.security.principal", jmxCredentials[0]);
        env.put("java.naming.security.credentials", jmxCredentials[1]);
    }
}

