/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.j2ee.naming;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.net.ssl.SSLContext;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import weblogic.corba.client.transaction.TransactionHelperImpl;
import weblogic.corba.j2ee.naming.EndPointList;
import weblogic.corba.j2ee.naming.EndPointSelector;
import weblogic.corba.j2ee.naming.ORBInfo;
import weblogic.corba.j2ee.naming.Utils;
import weblogic.corba.orb.ORBHelperImpl;
import weblogic.jndi.WLInitialContextFactory;
import weblogic.kernel.KernelStatus;
import weblogic.transaction.TransactionHelper;

public class ORBHelper {
    public static final String ORB_INITIAL_HOST = "org.omg.CORBA.ORBInitialHost";
    public static final String ORB_INITIAL_PORT = "org.omg.CORBA.ORBInitialPort";
    public static final String ORB_INITIAL_REF = "org.omg.CORBA.ORBInitRef";
    public static final String ORB_DEFAULT_INITIAL_REF = "org.omg.CORBA.ORBDefaultInitRef";
    public static final String ORB_CLASS_PROP = "org.omg.CORBA.ORBClass";
    public static final String ORB_NAMING_PROP = "java.naming.corba.orb";
    public static final String SUN_SOCKET_FACTORY = "com.sun.CORBA.legacy.connection.ORBSocketFactoryClass";
    public static final String SUN_WCHARSET = "com.sun.CORBA.codeset.wcharsets";
    public static final String SUN_FRAGMENT = "com.sun.CORBA.giop.ORBGIOP12BuffMgr";
    public static final String ORB_INITIALIZER = "org.omg.PortableInterceptor.ORBInitializerClass.";
    public static final String BI_DIR_ORBINIT = "weblogic.corba.client.iiop.BiDirORBInitializer";
    public static final String CLIENT_ORBINIT = "weblogic.corba.client.ClientORBInitializer";
    public static final String CLIENT_PACKAGE = "weblogic.corba.client.";
    public static final String BI_DIR_SOCKET_FACTORY = "iiop.BiDirORBSocketFactory";
    public static final String BI_DIR_SSL_SOCKET_FACTORY = "iiop.BiDirSSLORBSocketFactory";
    public static final String TUNNEL_SOCKET_FACTORY = "http.TunneledORBSocketFactory";
    public static final String TUNNEL_SSL_SOCKET_FACTORY = "http.TunneledSSLORBSocketFactory";
    public static final String CLUSTER_SOCKET_FACTORY = "cluster.ORBSocketFactory";
    public static final String NATIVE_TX_HELPER = "weblogic.corba.server.transaction.TransactionHelperImpl";
    public static final String ENABLE_SERVER_AFFINITY = "weblogic.jndi.enableServerAffinity";
    public static final String ORB_PROTOCOL = "weblogic.corba.orb.ORBProtocol";
    public static final String ORB_NAME = "weblogic.corba.orb.ORBName";
    public static final String INITIAL_CONTEXT_FACTORY = "weblogic.jndi.WLInitialContextFactory";
    public static final String REQUEST_TIMEOUT = "weblogic.jndi.requestTimeout";
    public static final String RMI_TIMEOUT = "weblogic.rmi.clientTimeout";
    public static final String CONNECT_TIMEOUT = "weblogic.jndi.connectTimeout";
    public static final String RESPONSE_READ_TIMEOUT = "weblogic.jndi.responseReadTimeout";
    public static final String SUN_TCP_READ_TIMEOUTS_PROPERTY = "com.sun.CORBA.transport.ORBTCPReadTimeouts";
    private static final boolean DEBUG = Boolean.getBoolean("weblogic.debug.ORBHelper");
    private static final String FALSE_PROP = "false";
    private static final int NOT_FOUND = -1;
    private static final String THIN_CLIENT_JAR_NAME = "wlclient.jar";
    private static ORBHelper singleton;
    private static boolean useWlsIiopClient;
    private static boolean thinClient;
    static OrbCreator orbCreator;
    private static boolean enableBiDir;
    private static final String THIN_CLIENT_INITIALIZER_CLASS = "weblogic.corba.client.ClientORBInitializer";
    private HashMap<String, ORBInfo> orbInfoMap = new HashMap();
    private HashMap<ORB, SSLContext> sslCtxCache = new HashMap();
    private ConcurrentHashMap<ORB, Long> timeoutCache = new ConcurrentHashMap();
    private HashMap<String, EndPointList> endPointListMap = new HashMap();
    private ORBInfo currentinfo = null;

    private static boolean getBiDir() {
        try {
            return Boolean.getBoolean("weblogic.corba.client.bidir");
        }
        catch (Exception e) {
            return true;
        }
    }

    public static boolean isThinClient() {
        return thinClient;
    }

    public static ORBHelper getORBHelper() {
        if (singleton == null) {
            if (thinClient) {
                new WLInitialContextFactory();
            } else {
                ORBHelper.createORBHelper();
            }
            if (singleton == null) {
                throw ORBHelper.createClasspathException();
            }
        }
        return singleton;
    }

    private static RuntimeException createClasspathException() {
        StringBuilder errorMessage = new StringBuilder("Initialization failure: ");
        String initialContextFactoryJarName = ORBHelper.getInitialContextFactoryJarName();
        int wlclientIndex = ORBHelper.getClassPathIndex(THIN_CLIENT_JAR_NAME);
        if (wlclientIndex == -1) {
            errorMessage.append(THIN_CLIENT_JAR_NAME).append(" not found in the classpath.");
        } else if (wlclientIndex > ORBHelper.getClassPathIndex(initialContextFactoryJarName)) {
            errorMessage.append(THIN_CLIENT_JAR_NAME).append(" must be listed before ").append(initialContextFactoryJarName).append(" in the classpath");
        } else {
            errorMessage.append("reason unknown. Please contact support");
        }
        return new RuntimeException(errorMessage.toString());
    }

    private static String getInitialContextFactoryJarName() {
        URL factoryResource = Thread.currentThread().getContextClassLoader().getResource(WLInitialContextFactory.class.getName());
        return factoryResource == null ? "NO.SUCH.JAR" : factoryResource.getFile();
    }

    private static int getClassPathIndex(String fileName) {
        String classpath = System.getProperty("java.class.path");
        String pathSeparator = System.getProperty("path.separator");
        StringTokenizer st = new StringTokenizer(classpath, pathSeparator);
        int index = 0;
        while (st.hasMoreTokens()) {
            if (st.nextToken().contains(fileName)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static synchronized void createORBHelper() {
        if (singleton == null) {
            if (ORBHelper.preferJdkIiop() && ORBHelper.hasThinClientClasses()) {
                singleton = new ORBHelper();
            } else {
                useWlsIiopClient = true;
                singleton = new ORBHelperImpl();
            }
        }
    }

    protected static boolean preferJdkIiop() {
        String enableClientProp = KernelStatus.isApplet() ? FALSE_PROP : System.getProperty("weblogic.system.iiop.enableClient");
        return FALSE_PROP.equals(enableClientProp);
    }

    private static boolean hasThinClientClasses() {
        return ORBHelper.hasClass("weblogic.corba.client.ClientORBInitializer");
    }

    private static boolean hasClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static synchronized void setORBHelper(ORBHelper helper) {
        singleton = helper;
    }

    static boolean getServerAffinity(Hashtable env) {
        return env == null ? false : Boolean.valueOf((String)env.get(ENABLE_SERVER_AFFINITY));
    }

    public synchronized ORB getORB(String url, Hashtable env) throws NamingException {
        EndPointList info = this.getEndPointList(url);
        ORBInfo orbinfo = this.getCachedORB(info.getStartingEndPoint().getKey(), env);
        if (orbinfo != null) {
            return orbinfo.getORB();
        }
        return this.createOrb(info.getStartingEndPoint(), env);
    }

    private synchronized ORBInfo getCachedORB(String key, Hashtable env) {
        ORBInfo orbinfo = this.orbInfoMap.get(key);
        if (orbinfo != null) {
            this.setCurrent(orbinfo);
            return orbinfo;
        }
        if (env != null && env.get(ORB_NAMING_PROP) != null) {
            orbinfo = this.cacheORB(key, (ORB)env.get(ORB_NAMING_PROP));
        }
        return orbinfo;
    }

    private ORBInfo cacheORB(String key, ORB orb) {
        ORBInfo orbinfo = this.createORBInfo(orb, key);
        this.orbInfoMap.put(key, orbinfo);
        this.setCurrent(orbinfo);
        return orbinfo;
    }

    ORB createORB(Hashtable env, EndPointSelector epi, String protocol, String initialRef) {
        Properties props = this.createProperties(env, epi, protocol, initialRef);
        ORB orb = this.createOrbInSystemClassLoader(props);
        if (env != null) {
            this.sslCtxCache.put(orb, this.getConfiguredSslContext(env));
            this.timeoutCache.put(orb, this.getConfiguredTimeout(env));
        }
        return orb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ORB createOrbInSystemClassLoader(Properties props) {
        ClassLoader savedCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ORBHelper.class.getClassLoader());
            ORB oRB = orbCreator.createOrb(props);
            return oRB;
        }
        finally {
            Thread.currentThread().setContextClassLoader(savedCL);
        }
    }

    private SSLContext getConfiguredSslContext(Hashtable env) {
        java.lang.Object credentials = env.get("java.naming.security.credentials");
        return credentials instanceof SSLContext ? (SSLContext)credentials : null;
    }

    private Long getConfiguredTimeout(Hashtable env) {
        java.lang.Object timeOut = env.get(RESPONSE_READ_TIMEOUT);
        if (timeOut == null) {
            timeOut = env.get(REQUEST_TIMEOUT);
        }
        return timeOut instanceof Long ? (Long)timeOut : 0L;
    }

    private Properties createProperties(Hashtable env, EndPointSelector epi, String protocol, String initialRef) {
        Properties props = new Properties();
        if (env != null) {
            props.putAll((Map<?, ?>)env);
        }
        if (props.getProperty(ORB_CLASS_PROP) == null && this.getORBClass() != null) {
            props.setProperty(ORB_CLASS_PROP, this.getORBClass());
        }
        if (epi != null) {
            if (epi.getPort() > 0) {
                props.put(ORB_INITIAL_PORT, Integer.toString(epi.getPort()));
            }
            props.put(ORB_PROTOCOL, protocol);
            props.put(SUN_FRAGMENT, "GROW");
            this.setSunReadTimeoutsProperty(props, env);
            props.put(SUN_WCHARSET, "0x05010001,0x00010109");
            if (protocol.equals("iiops")) {
                props.put("org.omg.PortableInterceptor.ORBInitializerClass.weblogic.corba.client.ClientORBInitializer", "true");
                props.put("org.omg.PortableInterceptor.ORBInitializerClass.weblogic.corba.client.iiop.BiDirORBInitializer", "true");
                props.put(SUN_SOCKET_FACTORY, "weblogic.corba.client.iiop.BiDirSSLORBSocketFactory");
            } else if (protocol.equals("http")) {
                props.put("org.omg.PortableInterceptor.ORBInitializerClass.weblogic.corba.client.ClientORBInitializer", "true");
                props.put("org.omg.PortableInterceptor.ORBInitializerClass.weblogic.corba.client.iiop.BiDirORBInitializer", "true");
                props.put(SUN_SOCKET_FACTORY, "weblogic.corba.client.http.TunneledORBSocketFactory");
            } else if (protocol.equals("https")) {
                props.put("org.omg.PortableInterceptor.ORBInitializerClass.weblogic.corba.client.ClientORBInitializer", "true");
                props.put("org.omg.PortableInterceptor.ORBInitializerClass.weblogic.corba.client.iiop.BiDirORBInitializer", "true");
                props.put(SUN_SOCKET_FACTORY, "weblogic.corba.client.http.TunneledSSLORBSocketFactory");
            } else if (thinClient) {
                props.put("org.omg.PortableInterceptor.ORBInitializerClass.weblogic.corba.client.ClientORBInitializer", "true");
                if (enableBiDir && protocol.length() > 0) {
                    props.put("org.omg.PortableInterceptor.ORBInitializerClass.weblogic.corba.client.iiop.BiDirORBInitializer", "true");
                    props.put(SUN_SOCKET_FACTORY, "weblogic.corba.client.iiop.BiDirORBSocketFactory");
                } else {
                    props.put(SUN_SOCKET_FACTORY, "weblogic.corba.client.cluster.ORBSocketFactory");
                }
            }
            props.put(ORB_INITIAL_HOST, epi.getHost());
            if (!thinClient) {
                props.put(ORB_INITIAL_REF, initialRef);
            }
        }
        return props;
    }

    private void setSunReadTimeoutsProperty(Properties props, Hashtable env) {
        if (env != null) {
            java.lang.Object o = env.get(CONNECT_TIMEOUT);
            if (o == null) {
                o = env.get(RMI_TIMEOUT);
            }
            if (o != null) {
                props.put(SUN_TCP_READ_TIMEOUTS_PROPERTY, "100:" + o + ":300:20");
            }
        }
    }

    public final SSLContext getSSLContext(ORB orb) {
        return this.sslCtxCache.get(orb);
    }

    public int getORBTimeout(ORB orb) {
        if (this.timeoutCache.containsKey(orb)) {
            return this.timeoutCache.get(orb).intValue();
        }
        return 0;
    }

    public String getORBClass() {
        return null;
    }

    public ORB getLocalORB() throws NamingException {
        Properties props = new Properties();
        if (this.getORBClass() != null) {
            props.setProperty(ORB_CLASS_PROP, this.getORBClass());
        }
        return orbCreator.createOrb(props);
    }

    public ORBInfo getCurrent() {
        return this.currentinfo;
    }

    public void setCurrent(ORBInfo info) {
        this.currentinfo = info;
    }

    public ORBInfo createORBInfo(ORB orb, String key) {
        return new ORBInfo(orb, key);
    }

    public Object getORBInitialReference(String url, Hashtable env, String rir) throws NamingException {
        EndPointList info = this.getEndPointList(url);
        if (info == null) {
            throw new InvalidNameException("url `" + url + "' is invalid");
        }
        return new InitialReferenceResolution(env, rir, info).invoke();
    }

    private void selectNextStartingEndPoint(Hashtable env, EndPointList.EndPointIterator iterator) {
        if (ORBHelper.getServerAffinity(env)) {
            iterator.selectCurrentAsStart();
        } else {
            iterator.selectNextAsStart();
        }
    }

    private ORB createOrb(EndPointSelector epi, Hashtable env) {
        ORB orb = this.createORB(env, epi, epi.getProtocol(), epi.getServiceName() + "=" + epi.getCorbalocURL());
        this.cacheORB(epi.getKey(), orb);
        return orb;
    }

    void discardOrb(ORB orb, EndPointSelector selector) {
        this.clearORBFromCache(selector.getKey());
        this.timeoutCache.remove(orb);
        if (thinClient) {
            this.destroyORB(orb);
        }
    }

    public synchronized void clearORBFromCache(String key) {
        this.orbInfoMap.remove(key);
        this.setCurrent(null);
    }

    private synchronized EndPointList getEndPointList(String url) throws InvalidNameException {
        EndPointList endPointList = this.endPointListMap.get(url);
        if (endPointList == null) {
            endPointList = EndPointList.createEndPointList(url);
            this.endPointListMap.put(url, endPointList);
        }
        return endPointList;
    }

    public void pushTransactionHelper() {
        if (useWlsIiopClient && ORBHelper.hasClass(NATIVE_TX_HELPER)) {
            TransactionHelper.pushTransactionHelper(ORBHelper.createTxHelper(NATIVE_TX_HELPER));
        } else {
            TransactionHelper.pushTransactionHelper(new TransactionHelperImpl());
        }
    }

    public void popTransactionHelper() {
        TransactionHelper.popTransactionHelper();
    }

    static boolean isRecoverableORBFailure(SystemException se) {
        return ORBHelper.isRecoverableORBFailure(se, true);
    }

    public static boolean isRecoverableORBFailure(SystemException se, boolean idempotent) {
        return (se instanceof COMM_FAILURE || se instanceof MARSHAL || se instanceof OBJECT_NOT_EXIST || se instanceof BAD_PARAM && se.minor == 1330446344) && (se.completed.value() == 1 || se.completed.value() == 2 && idempotent);
    }

    private static TransactionHelper createTxHelper(String name) {
        try {
            return (TransactionHelper)Class.forName(name).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException cnfe) {
            throw new Error(cnfe.toString());
        }
    }

    protected static void p(String s) {
        System.err.println("<ORBHelper> " + s);
    }

    public void destroyORB(ORB orb) {
        block8: {
            try {
                java.lang.Object tm;
                block7: {
                    tm = orb.getClass().getMethod("getTransportManager", new Class[0]).invoke((java.lang.Object)orb, new java.lang.Object[0]);
                    try {
                        java.lang.Object selector = tm.getClass().getMethod("getSelector", Integer.TYPE).invoke(tm, 0);
                        selector.getClass().getMethod("close", new Class[0]).invoke(selector, new java.lang.Object[0]);
                    }
                    catch (Exception ex) {
                        if (!DEBUG) break block7;
                        ex.printStackTrace();
                    }
                }
                Collection acceptors = (Collection)tm.getClass().getMethod("getAcceptors", new Class[0]).invoke(tm, new java.lang.Object[0]);
                for (java.lang.Object acceptor : acceptors) {
                    try {
                        acceptor.getClass().getMethod("close", new Class[0]).invoke(acceptor, new java.lang.Object[0]);
                    }
                    catch (Exception ex) {
                        if (!DEBUG) continue;
                        ex.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                if (!DEBUG) break block8;
                e.printStackTrace();
            }
        }
        orb.destroy();
    }

    static {
        useWlsIiopClient = false;
        thinClient = false;
        orbCreator = new OrbCreator(){

            @Override
            public ORB createOrb(Properties props) {
                return ORB.init((String[])new String[0], (Properties)props);
            }
        };
        enableBiDir = ORBHelper.getBiDir();
        try {
            Class.forName("weblogic.corba.client.cluster.ORBSocketFactory");
            Class.forName(INITIAL_CONTEXT_FACTORY);
            if (!KernelStatus.isServer() && KernelStatus.isThinIIOPClient()) {
                thinClient = true;
            } else {
                Class.forName("org.osgi.framework.Bundle");
                thinClient = true;
            }
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            // empty catch block
        }
    }

    private class InitialReferenceResolution {
        private Hashtable env;
        private String rir;
        private EndPointList info;
        private List<SystemException> causes = new ArrayList<SystemException>();

        public InitialReferenceResolution(Hashtable env, String rir, EndPointList info) {
            this.env = env;
            this.rir = rir;
            this.info = info;
        }

        public Object invoke() throws NamingException {
            Object initialReference = null;
            EndPointList.EndPointIterator iterator = this.info.iterator();
            while (initialReference == null && iterator.hasNext()) {
                initialReference = this.getInitialReferenceForEndPoint(this.env, this.rir, iterator.next());
            }
            if (initialReference == null) {
                throw this.createNamingException();
            }
            ORBHelper.this.selectNextStartingEndPoint(this.env, iterator);
            return initialReference;
        }

        private NamingException createNamingException() {
            if (this.causes.isEmpty()) {
                return new NamingException("Couldn't resolve initial reference: " + this.rir + "; no valid urls found in " + this.info);
            }
            NamingException namingException = new NamingException("Couldn't resolve initial reference: " + this.rir + " after " + this.causes.size() + " failures");
            namingException.initCause(this.causes.get(this.causes.size() - 1));
            return namingException;
        }

        private Object getInitialReferenceForEndPoint(Hashtable env, String rir, EndPointSelector selector) throws NamingException {
            Object initialReference = this.getInitialReferenceForCachedOrb(env, rir, selector);
            if (initialReference == null) {
                initialReference = this.getInitialReferenceForNewOrb(env, rir, selector);
            }
            return selector.redirectToSelectedPartition(initialReference);
        }

        private Object getInitialReferenceForCachedOrb(Hashtable env, String rir, EndPointSelector selector) throws NamingException {
            ORBInfo orbInfo = ORBHelper.this.getCachedORB(selector.getKey(), env);
            if (orbInfo == null) {
                return null;
            }
            return this.getInitialReference(orbInfo.getORB(), rir, selector);
        }

        private Object getInitialReferenceForNewOrb(Hashtable env, String rir, EndPointSelector selector) throws NamingException {
            return this.getInitialReference(ORBHelper.this.createOrb(selector, env), rir, selector);
        }

        private Object getInitialReference(ORB orb, String rir, EndPointSelector selector) throws NamingException {
            try {
                return this.clone(orb, orb.resolve_initial_references(rir));
            }
            catch (InvalidName e) {
                throw Utils.wrapNamingException((Exception)((java.lang.Object)e), "Couldn't resolve initial reference: " + rir);
            }
            catch (SystemException e) {
                ORBHelper.this.discardOrb(orb, selector);
                if (!ORBHelper.isRecoverableORBFailure(e)) {
                    throw Utils.wrapNamingException((Exception)((java.lang.Object)e), "Couldn't resolve initial reference: " + rir);
                }
                if (DEBUG) {
                    this.logInitialReferenceFailure(e);
                }
                this.causes.add(e);
                return null;
            }
        }

        private Object clone(ORB orb, Object initialReference) {
            return orb.string_to_object(orb.object_to_string(initialReference));
        }

        private void logInitialReferenceFailure(SystemException e) {
            e.printStackTrace();
        }
    }

    static interface OrbCreator {
        public ORB createOrb(Properties var1);
    }
}

