/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.j2ee.naming;

import javax.naming.CannotProceedException;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFoundReason;
import weblogic.corba.cos.naming.NamingContextAnyHelper;
import weblogic.corba.cos.naming.NamingContextAnyPackage.CannotProceed;
import weblogic.corba.cos.naming.NamingContextAnyPackage.NotFound;
import weblogic.corba.cos.naming.NamingContextAnyPackage.WNameComponent;
import weblogic.corba.j2ee.naming.NameParser;

public final class Utils {
    private static final boolean DEBUG = false;

    public static NamingException wrapNamingException(Exception e, String msg) throws NamingException {
        NamingException ne = null;
        if (e instanceof InvalidName) {
            ne = new InvalidNameException(msg);
        } else if (e instanceof org.omg.CORBA.ORBPackage.InvalidName) {
            ne = new InvalidNameException(msg);
        } else if (e instanceof org.omg.CosNaming.NamingContextPackage.NotFound) {
            org.omg.CosNaming.NamingContextPackage.NotFound notFound = (org.omg.CosNaming.NamingContextPackage.NotFound)((java.lang.Object)e);
            msg = msg + ": `" + Utils.nameComponentToString(notFound.rest_of_name) + "'" + Utils.notFoundReasonToString(notFound.why);
            ne = new NameNotFoundException(msg);
        } else if (e instanceof NotFound) {
            NotFound notFound = (NotFound)((java.lang.Object)e);
            msg = msg + ": `" + Utils.nameComponentToString(notFound.rest_of_name) + "'" + Utils.notFoundReasonToString(notFound.why);
            ne = new NameNotFoundException(msg);
        } else if (e instanceof org.omg.CosNaming.NamingContextPackage.CannotProceed) {
            org.omg.CosNaming.NamingContextPackage.CannotProceed cpe = (org.omg.CosNaming.NamingContextPackage.CannotProceed)((java.lang.Object)e);
            msg = msg + ": unresolved name `" + Utils.nameComponentToString(cpe.rest_of_name) + "'";
            ne = new CannotProceedException(msg);
        } else if (e instanceof CannotProceed) {
            CannotProceed cpe = (CannotProceed)((java.lang.Object)e);
            msg = msg + ": unresolved name `" + Utils.nameComponentToString(cpe.rest_of_name) + "'";
            ne = new CannotProceedException(msg);
        } else {
            ne = e instanceof AlreadyBound ? new NameAlreadyBoundException(msg) : new NamingException(msg);
        }
        ne.setRootCause(e);
        return ne;
    }

    public static SystemException unwrapNamingException(SystemException fallback, NamingException ne) {
        if (ne.getRootCause() instanceof SystemException) {
            return (SystemException)ne.getRootCause();
        }
        fallback.initCause((Throwable)ne);
        return fallback;
    }

    public static SystemException initCORBAExceptionWithCause(SystemException se, Throwable cause) {
        se.initCause(cause);
        return se;
    }

    public static final NamingContext narrowContext(Object obj) {
        if (obj._is_a(NamingContextAnyHelper.id())) {
            return NamingContextAnyHelper.narrow(obj);
        }
        return NamingContextHelper.narrow((Object)obj);
    }

    public static final NameComponent[] stringToNameComponent(String resolvePath) throws NamingException {
        return Utils.nameToName(Utils.stringToName(resolvePath));
    }

    public static final Name stringToName(String resolvePath) throws NamingException {
        resolvePath = NameParser.getNameString(resolvePath);
        CompositeName name = new CompositeName();
        while (resolvePath.length() > 0) {
            name.add(Utils.getPrefix(resolvePath));
            resolvePath = Utils.getSuffix(resolvePath);
        }
        return name;
    }

    public static final WNameComponent[] stringToWNameComponent(String resolvePath) throws NamingException {
        return Utils.nameToWName(Utils.stringToNameComponent(resolvePath));
    }

    public static final WNameComponent[] nameToWName(NameComponent[] nc) throws NamingException {
        WNameComponent[] wnc = new WNameComponent[nc.length];
        for (int i = 0; i < nc.length; ++i) {
            wnc[i] = new WNameComponent(nc[i].id, nc[i].kind);
        }
        return wnc;
    }

    public static final WNameComponent[] nameToWName(Name nc) throws NamingException {
        WNameComponent[] wnc = new WNameComponent[nc.size()];
        for (int i = 0; i < nc.size(); ++i) {
            wnc[i] = new WNameComponent(nc.get(i), "");
        }
        return wnc;
    }

    public static final NameComponent[] nameToName(Name nc) throws NamingException {
        NameComponent[] wnc = new NameComponent[nc.size()];
        for (int i = 0; i < nc.size(); ++i) {
            wnc[i] = new NameComponent(nc.get(i), "");
        }
        return wnc;
    }

    public static final String nameComponentToString(NameComponent[] nc) {
        StringBuffer s = new StringBuffer("");
        if (nc != null) {
            for (int i = 0; i < nc.length; ++i) {
                if (i > 0) {
                    s.append('/');
                }
                String n = nc[i].id;
                for (int j = 0; j < n.length(); ++j) {
                    if (j != 0 && j != n.length() - 1 && Utils.isQuote(n.charAt(j)) || Utils.isSeparator(n.charAt(j))) {
                        s.append('\\');
                    }
                    s.append(n.charAt(j));
                }
                if (nc[i].kind.length() <= 0) continue;
                s.append('/').append(nc[i].kind);
            }
        }
        return s.toString();
    }

    private static boolean isSeparator(char c) {
        return c == '.' || c == '/';
    }

    private static boolean isQuote(char c) {
        return c == '\"' || c == '\'';
    }

    public static final String nameComponentToString(WNameComponent[] nc) {
        StringBuffer s = new StringBuffer("");
        if (nc != null) {
            for (int i = 0; i < nc.length; ++i) {
                if (i > 0) {
                    s.append('/');
                }
                String n = nc[i].id;
                for (int j = 0; j < n.length(); ++j) {
                    if (j != 0 && j != n.length() - 1 && Utils.isQuote(n.charAt(j)) || Utils.isSeparator(n.charAt(j))) {
                        s.append('\\');
                    }
                    s.append(n.charAt(j));
                }
                if (nc[i].kind.length() <= 0) continue;
                s.append('/').append(nc[i].kind);
            }
        }
        return s.toString();
    }

    private static final String notFoundReasonToString(NotFoundReason nfr) {
        switch (nfr.value()) {
            case 0: {
                return " could not be found.";
            }
            case 1: {
                return " is not a naming context.";
            }
            case 2: {
                return " is not a remote object.";
            }
        }
        return null;
    }

    private static String getPrefix(String name) throws NamingException {
        if (name.length() == 0) {
            return name;
        }
        if (name.charAt(0) == '\"') {
            int idx = name.indexOf(34, 1);
            if (idx < 0) {
                throw new InvalidNameException("No closing quote");
            }
            if (idx < name.length() - 1 && !Utils.isSeparator(name.charAt(idx + 1))) {
                throw new InvalidNameException("Closing quote must be at component end");
            }
            return name.substring(1, idx);
        }
        if (name.charAt(0) == '\'') {
            int idx = name.indexOf(39, 1);
            if (idx < 0) {
                throw new InvalidNameException("No closing quote");
            }
            if (idx < name.length() - 1 && !Utils.isSeparator(name.charAt(idx + 1))) {
                throw new InvalidNameException("Closing quote must be at component end");
            }
            return name.substring(1, idx);
        }
        StringBuffer prefix = new StringBuffer();
        block4: for (int i = 0; i < name.length(); ++i) {
            switch (name.charAt(i)) {
                case '\\': {
                    if (++i == name.length()) {
                        throw new InvalidNameException("An escape at the end of a name must be escaped");
                    }
                    prefix.append(name.charAt(i));
                    continue block4;
                }
                case '\"': 
                case '\'': {
                    throw new InvalidNameException("Unescaped quote in a component");
                }
                default: {
                    if (Utils.isSeparator(name.charAt(i))) {
                        return prefix.toString();
                    }
                    prefix.append(name.charAt(i));
                }
            }
        }
        return prefix.toString();
    }

    private static String getSuffix(String name) throws NamingException {
        if (name.length() == 0) {
            return name;
        }
        if (name.charAt(0) == '\"') {
            int idx = name.indexOf(34, 1);
            if (idx < 0) {
                throw new InvalidNameException("No closing quote");
            }
            if (idx < name.length() - 1 && !Utils.isSeparator(name.charAt(idx + 1))) {
                throw new InvalidNameException("Closing quote must be at component end");
            }
            if (++idx < name.length() && Utils.isSeparator(name.charAt(idx))) {
                ++idx;
            }
            return name.substring(idx);
        }
        if (name.charAt(0) == '\'') {
            int idx = name.indexOf(39, 1);
            if (idx < 0) {
                throw new InvalidNameException("No closing quote");
            }
            if (idx < name.length() - 1 && !Utils.isSeparator(name.charAt(idx + 1))) {
                throw new InvalidNameException("Closing quote must be at component end");
            }
            if (++idx < name.length() && Utils.isSeparator(name.charAt(idx))) {
                ++idx;
            }
            return name.substring(idx);
        }
        block4: for (int i = 0; i < name.length(); ++i) {
            switch (name.charAt(i)) {
                case '\\': {
                    if (++i != name.length()) continue block4;
                    throw new InvalidNameException("An escape at the end of a name must be escaped");
                }
                case '\"': 
                case '\'': {
                    throw new InvalidNameException("Unescaped quote in a component");
                }
                default: {
                    if (!Utils.isSeparator(name.charAt(i))) continue block4;
                    return name.substring(i + 1);
                }
            }
        }
        return "";
    }
}

