/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.j2ee.transaction;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.UserTransaction;
import javax.transaction.xa.XAResource;
import weblogic.corba.j2ee.transaction.TransactionManagerImpl;
import weblogic.transaction.ClientTransactionManager;

public class TransactionManagerWrapper
implements UserTransaction,
ClientTransactionManager,
Transaction {
    private static final ThreadLocal currentTx = new ThreadLocal();

    public static TransactionManagerWrapper getTransactionManager() {
        return TMMaker.SINGLETON;
    }

    protected TransactionManagerImpl getTM() {
        TransactionManagerImpl tm = (TransactionManagerImpl)currentTx.get();
        if (tm == null) {
            tm = new TransactionManagerImpl();
            currentTx.set(tm);
        }
        return tm;
    }

    protected TransactionManagerWrapper() {
    }

    @Override
    public void begin() throws NotSupportedException, SystemException {
        this.getTM().begin();
    }

    @Override
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.getTM().commit();
    }

    @Override
    public int getStatus() throws SystemException {
        return this.getTM().getStatus();
    }

    @Override
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.getTM().rollback();
    }

    @Override
    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.getTM().setRollbackOnly();
    }

    @Override
    public void setTransactionTimeout(int timeout) throws SystemException {
        this.getTM().setTransactionTimeout(timeout);
    }

    @Override
    public void resume(Transaction tx) throws InvalidTransactionException, IllegalStateException, SystemException {
        if (currentTx.get() != null) {
            throw new IllegalStateException();
        }
        try {
            TransactionManagerImpl ut = (TransactionManagerImpl)tx;
            ut.resume(tx);
            currentTx.set(ut);
        }
        catch (ClassCastException cce) {
            throw new InvalidTransactionException();
        }
    }

    @Override
    public Transaction suspend() throws SystemException {
        if (currentTx.get() == null) {
            throw new SystemException("No transaction in progress");
        }
        Transaction tx = this.getTM().suspend();
        currentTx.set(null);
        return tx;
    }

    @Override
    public void forceResume(Transaction tx) {
        try {
            if (tx == null) {
                return;
            }
            TransactionManagerImpl ut = (TransactionManagerImpl)tx;
            ut.forceResume(tx);
            currentTx.set(ut);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @Override
    public Transaction forceSuspend() {
        if (currentTx.get() == null) {
            return null;
        }
        Transaction tx = this.getTM().forceSuspend();
        currentTx.set(null);
        return tx;
    }

    @Override
    public Transaction getTransaction() throws SystemException {
        return this.getTM().getTransaction();
    }

    @Override
    public void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
        throw new SystemException("Not implemented");
    }

    @Override
    public boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
        throw new SystemException("Not implemented");
    }

    @Override
    public boolean enlistResource(XAResource xaRes) throws RollbackException, IllegalStateException, SystemException {
        throw new SystemException("Not implemented");
    }

    public String toString() {
        return super.toString() + " TransactionManagerWrapper";
    }

    private static final class TMMaker {
        private static final TransactionManagerWrapper SINGLETON = new TransactionManagerWrapper();

        private TMMaker() {
        }
    }
}

