/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.utils;

import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.Streamable;
import org.omg.CORBA.portable.ValueBase;
import weblogic.corba.utils.CorbaUtils;
import weblogic.corba.utils.RepositoryId;
import weblogic.iiop.PortableReplaceable;
import weblogic.utils.collections.ConcurrentHashMap;
import weblogic.utils.collections.ConcurrentWeakHashMap;
import weblogic.utils.io.ObjectStreamClass;

public final class ClassInfo {
    private static final boolean DEBUG = false;
    private RepositoryId repId;
    private RepositoryId localRepId;
    private RepositoryId[] repIdList;
    private Class theClass;
    private TypeDetails typeDetails;
    private ObjectStreamClass osc;
    private static Map<Class<?>, ClassInfoReference> classInfoMap = new ConcurrentWeakHashMap();
    private static Map<RepositoryId, ClassInfoReference> repositoryIdMap = new ConcurrentHashMap();
    private static boolean useFullRepositoryIdList = false;

    public ClassInfo(RepositoryId repId, String codebase) {
        this.repId = repId;
        this.theClass = CorbaUtils.getClassFromID(repId, codebase);
        if (this.theClass != null) {
            this.computeLocalRepositoryId(repId);
            this.initStreamInfo();
        }
    }

    private void computeLocalRepositoryId(RepositoryId repId) {
        repId.setClassLoader(this.theClass.getClassLoader());
        this.localRepId = new RepositoryId(this.theClass);
        if (this.localRepId.equals((Object)repId)) {
            this.localRepId = repId;
        }
    }

    ClassInfo(@NotNull Class theClass) {
        this.theClass = theClass;
        this.localRepId = this.repId = new RepositoryId(theClass);
        this.initStreamInfo();
    }

    private void initStreamInfo() {
        this.osc = ObjectStreamClass.lookup((Class)this.theClass);
        if (this.isCreateFullRepositoryIdLists()) {
            this.repIdList = RepositoryId.getRepositoryIdList(this.theClass);
        }
    }

    private boolean isCreateFullRepositoryIdLists() {
        return this.osc != null && this.osc.isCustomMarshaled() && useFullRepositoryIdList;
    }

    public ObjectStreamClass getDescriptor() {
        return this.osc;
    }

    public Serializable writeReplace(Object obj) {
        ObjectStreamClass osc = this.osc;
        Class<?> c = this.theClass;
        try {
            while (osc != null && osc.hasWriteReplace() && (obj = osc.writeReplace(obj)) != null && obj.getClass() != c) {
                c = obj.getClass();
                osc = ObjectStreamClass.lookup(c);
            }
            return (Serializable)obj;
        }
        catch (IOException ioe) {
            throw (MARSHAL)new MARSHAL(ioe.getMessage()).initCause((Throwable)ioe);
        }
    }

    public Class<?> forClass() {
        return this.theClass;
    }

    public RepositoryId getRepositoryId() {
        return this.repId;
    }

    public RepositoryId getLocalRepositoryId() {
        return this.localRepId;
    }

    public RepositoryId[] getRepositoryIdList() {
        return this.repIdList;
    }

    public static RepositoryId getRepositoryId(String repid) {
        ClassInfo info = ClassInfo.findClassInfo(new RepositoryId(repid));
        return info.getRepositoryId();
    }

    public boolean isAbstractInterface() {
        return this.getTypeDetails().isAbstractInterface();
    }

    public boolean isPortableReplaceable() {
        return this.getTypeDetails().isPortableReplaceable();
    }

    public boolean isIDLEntity() {
        return this.getTypeDetails().isIDLEntity();
    }

    public boolean isStreamable() {
        return this.getTypeDetails().isStreamable();
    }

    public boolean isValueBase() {
        return this.getTypeDetails().isValueBase();
    }

    public boolean isString() {
        return this.getTypeDetails().isString();
    }

    public boolean equals(Object other) {
        return other instanceof ClassInfo && this.equals((ClassInfo)other);
    }

    private boolean equals(ClassInfo other) {
        return other.theClass == this.theClass && other.repId.equals((Object)this.repId);
    }

    public int hashCode() {
        return this.repId == null ? 0 : this.repId.hashCode();
    }

    public String toString() {
        return "ClassInfo[" + this.repId.toPrettyString() + " => " + this.theClass + ", " + this.localRepId + "]";
    }

    public static ClassInfo findClassInfo(RepositoryId repId) {
        return ClassInfo.findClassInfo(repId, null);
    }

    public static ClassInfo findClassInfo(RepositoryId repId, String codebase) {
        ClassInfo classInfo;
        if (repId == null) {
            return null;
        }
        ClassInfoReference cir = repositoryIdMap.get(repId);
        ClassInfo value = ClassInfo.getFromReference(cir);
        if (value != null) {
            return value;
        }
        String annotation = CorbaUtils.getAnnotation(null);
        if (repId.getAnnotation() == null && annotation != null && (classInfo = ClassInfo.getFromReference(cir = repositoryIdMap.get(repId = new RepositoryId(repId, annotation)))) != null) {
            if (classInfo.theClass == null) {
                return classInfo;
            }
            if (classInfo.theClass.getClassLoader() == Thread.currentThread().getContextClassLoader()) {
                return classInfo;
            }
            classInfoMap.remove(classInfo.theClass);
        }
        ClassInfo cinfo = new ClassInfo(repId, codebase);
        if (cinfo.theClass != null) {
            repositoryIdMap.put(repId, new ClassInfoReference(cinfo));
        }
        if (!(cinfo.theClass == null || classInfoMap.get(cinfo.theClass) != null || repId != cinfo.getLocalRepositoryId() && cinfo.isValueType())) {
            cinfo.addToMap(cinfo.theClass);
        }
        return cinfo;
    }

    private static ClassInfo getFromReference(ClassInfoReference cir) {
        return cir == null ? null : (ClassInfo)cir.get();
    }

    private boolean isValueType() {
        if (this.theClass.isPrimitive() || CorbaUtils.isRemote(this.theClass) || CorbaUtils.isARemote(this.theClass) || IDLEntity.class.equals((Object)this.theClass)) {
            return false;
        }
        if (this.theClass.isInterface() && !this.isAbstractInterface()) {
            return true;
        }
        if (this.theClass.getComponentType() != null) {
            return false;
        }
        return Serializable.class.isAssignableFrom(this.theClass);
    }

    @NotNull
    public static ClassInfo findClassInfo(Class theClass) {
        ClassInfoReference cir = classInfoMap.get(theClass);
        ClassInfo cinfo = ClassInfo.getFromReference(cir);
        if (cinfo == null) {
            cinfo = new ClassInfo(theClass);
            repositoryIdMap.put(cinfo.repId, new ClassInfoReference(cinfo));
            cinfo.addToMap(theClass);
        }
        return cinfo;
    }

    private void addToMap(Class theClass) {
        classInfoMap.put(theClass, new ClassInfoReference(this));
    }

    public static void initialize(boolean fullRepid) {
        useFullRepositoryIdList = fullRepid;
    }

    public boolean isEnum() {
        return this.theClass.isEnum();
    }

    private TypeDetails getTypeDetails() {
        if (this.typeDetails == null) {
            this.typeDetails = this.createTypeDetails();
        }
        return this.typeDetails;
    }

    private synchronized TypeDetails createTypeDetails() {
        return this.typeDetails != null ? this.typeDetails : new TypeDetails(this.theClass);
    }

    private static void p(String msg) {
        System.out.println("<ClassInfo>: " + msg);
    }

    private static class ClassInfoReference
    extends WeakReference<ClassInfo> {
        private int hash;

        ClassInfoReference(ClassInfo key) {
            super(key);
            this.hash = key.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof ClassInfoReference)) {
                return false;
            }
            ClassInfoReference e = (ClassInfoReference)o;
            Object k1 = this.get();
            Object k2 = e.get();
            return this.hash == e.hash && (k1 == null ? k2 == null : k1.equals(k2));
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private class TypeDetails {
        private boolean string;
        private boolean abstractInterface;
        private boolean portableReplaceable;
        private boolean idlEntity;
        private boolean streamable;
        private boolean valueBase;

        TypeDetails(Class theClass) {
            this.string = String.class.isAssignableFrom(theClass);
            this.abstractInterface = CorbaUtils.isAbstractInterface(theClass);
            this.portableReplaceable = PortableReplaceable.class.isAssignableFrom(theClass);
            this.idlEntity = IDLEntity.class.isAssignableFrom(theClass);
            this.streamable = Streamable.class.isAssignableFrom(theClass);
            this.valueBase = ValueBase.class.isAssignableFrom(theClass);
        }

        public boolean isString() {
            return this.string;
        }

        public boolean isAbstractInterface() {
            return this.abstractInterface;
        }

        public boolean isIDLEntity() {
            return this.idlEntity;
        }

        boolean isPortableReplaceable() {
            return this.portableReplaceable;
        }

        boolean isStreamable() {
            return this.streamable;
        }

        boolean isValueBase() {
            return this.valueBase;
        }
    }
}

