/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.utils;

import java.lang.ref.WeakReference;
import java.rmi.RemoteException;
import java.util.Map;
import weblogic.corba.utils.ClassLoadingUtils;
import weblogic.corba.utils.CorbaUtils;
import weblogic.corba.utils.RepositoryId;
import weblogic.rmi.internal.DescriptorManager;
import weblogic.rmi.internal.RuntimeDescriptor;
import weblogic.utils.collections.ConcurrentHashMap;
import weblogic.utils.collections.ConcurrentWeakHashMap;

public final class RemoteInfo {
    private RepositoryId repId;
    private Class theClass;
    private boolean idlInterface = false;
    private RuntimeDescriptor descriptor = null;
    private static Map<Class<?>, RemoteInfo> classInfoMap = new ConcurrentWeakHashMap();
    private static Map<RepositoryId, RemoteInfoReference> repositoryIdMap = new ConcurrentHashMap();
    private static ClassLoadingUtils classLoadingUtils = new ClassLoadingUtils(){

        @Override
        public Class getClassFromID(RepositoryId repId) {
            return CorbaUtils.getClassFromID(repId);
        }

        @Override
        public Class getClassFromID(RepositoryId repId, String codebase) {
            return CorbaUtils.getClassFromID(repId, codebase);
        }
    };

    public RemoteInfo(RepositoryId repId) {
        this.repId = repId;
        this.theClass = classLoadingUtils.getClassFromID(repId);
        this.init();
    }

    public RemoteInfo(Class theClass) {
        this.theClass = theClass;
        this.repId = new RepositoryId(theClass);
        this.init();
    }

    private RemoteInfo(RepositoryId repId, Class c) {
        this.repId = repId;
        this.theClass = c;
        this.init();
    }

    private void init() {
        this.idlInterface = CorbaUtils.isIDLInterface(this.theClass);
        this.repId.setClassLoader(this.theClass.getClassLoader());
        try {
            Class c;
            this.descriptor = DescriptorManager.createRuntimeDescriptor((Class)this.theClass);
            if (this.descriptor == null && (c = classLoadingUtils.getClassFromID(this.repId)) != null && c != this.theClass) {
                this.descriptor = DescriptorManager.createRuntimeDescriptor((Class)c);
            }
        }
        catch (RemoteException re) {
            throw new AssertionError((Object)re);
        }
    }

    public Class<?> getTheClass() {
        return this.theClass;
    }

    public RuntimeDescriptor getDescriptor() {
        return this.descriptor;
    }

    public RepositoryId getRepositoryId() {
        return this.repId;
    }

    public String getClassName() {
        return this.theClass.getName();
    }

    public boolean isIDLInterface() {
        return this.idlInterface;
    }

    public static RepositoryId getRepositoryId(String repid) {
        RemoteInfo info = RemoteInfo.findRemoteInfo(new RepositoryId(repid));
        return info.getRepositoryId();
    }

    public boolean equals(Object other) {
        return other instanceof RemoteInfo && this.equals((RemoteInfo)other);
    }

    private boolean equals(RemoteInfo other) {
        return this == other || this.theClass == other.theClass && this.repId.equals((Object)other.repId);
    }

    public int hashCode() {
        return this.repId == null ? 0 : this.repId.hashCode();
    }

    public String toString() {
        return this.repId.toString();
    }

    public static RemoteInfo findRemoteInfo(RepositoryId repid) {
        return RemoteInfo.findRemoteInfo(repid, (String)null);
    }

    public static RemoteInfo findRemoteInfo(RepositoryId repId, String codebase) {
        RemoteInfo remoteInfo;
        String annotation;
        RemoteInfoReference cir = repositoryIdMap.get(repId);
        if (cir == null && repId.getAnnotation() == null && (annotation = CorbaUtils.getAnnotation(null)) != null && (cir = repositoryIdMap.get(new RepositoryId(repId, annotation))) != null) {
            repId.setAnnotation(annotation);
        }
        RemoteInfo remoteInfo2 = remoteInfo = cir != null ? (RemoteInfo)cir.get() : null;
        if (remoteInfo == null) {
            Class c = classLoadingUtils.getClassFromID(repId, codebase);
            if (c == null) {
                return null;
            }
            remoteInfo = new RemoteInfo(repId, c);
            repositoryIdMap.put(repId, new RemoteInfoReference(remoteInfo));
            classInfoMap.put(c, remoteInfo);
        }
        return remoteInfo;
    }

    public static RemoteInfo findRemoteInfo(RepositoryId repId, Class c) {
        RemoteInfo remoteInfo;
        RemoteInfoReference cir = repositoryIdMap.get(repId);
        RemoteInfo remoteInfo2 = remoteInfo = cir != null ? (RemoteInfo)cir.get() : null;
        if (remoteInfo == null) {
            remoteInfo = RemoteInfo.createRemoteInfo(repId, c);
        }
        return remoteInfo;
    }

    private static RemoteInfo createRemoteInfo(RepositoryId repId, Class c) {
        assert (repId != null && c != null);
        RemoteInfo rInfo = new RemoteInfo(repId, c);
        Class ifclass = classLoadingUtils.getClassFromID(repId);
        if (ifclass == null || ifclass == c) {
            repositoryIdMap.put(repId, new RemoteInfoReference(rInfo));
        }
        return rInfo;
    }

    public static RemoteInfo findRemoteInfo(Class theClass) {
        RemoteInfo cinfo = classInfoMap.get(theClass);
        if (cinfo == null) {
            cinfo = new RemoteInfo(theClass);
            Class ifclass = classLoadingUtils.getClassFromID(cinfo.repId);
            if (ifclass == null || ifclass == theClass) {
                repositoryIdMap.put(cinfo.repId, new RemoteInfoReference(cinfo));
            }
            classInfoMap.put(theClass, cinfo);
        }
        return cinfo;
    }

    private static class RemoteInfoReference
    extends WeakReference<RemoteInfo> {
        private int hash;

        RemoteInfoReference(RemoteInfo key) {
            super(key);
            this.hash = key.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof RemoteInfoReference)) {
                return false;
            }
            RemoteInfoReference e = (RemoteInfoReference)o;
            Object k1 = this.get();
            Object k2 = e.get();
            return this.hash == e.hash && (k1 == null ? k2 == null : k1.equals(k2));
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

