/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.utils;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.Serializable;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.rmi.CORBA.ClassDesc;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.InputStream;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.SendingContext.CodeBaseHelper;
import weblogic.corba.cos.naming.NamingContextAnyHelper;
import weblogic.corba.utils.CorbaUtils;
import weblogic.corba.utils.MarshaledString;
import weblogic.rmi.utils.Utilities;
import weblogic.utils.collections.ConcurrentHashMap;
import weblogic.utils.io.ObjectStreamClass;
import weblogic.utils.io.ObjectStreamField;

public final class RepositoryId
extends MarshaledString {
    private String annotation;
    private static final String[] ILLEGAL_CHARS = new String[]{"\\U0024", "__"};
    private static final String[] LEGAL_CHARS = new String[]{"$", "$"};
    private static final String STRING_ID = "IDL:omg.org/CORBA/WStringValue:1.0";
    public static final RepositoryId STRING = new RepositoryId("IDL:omg.org/CORBA/WStringValue:1.0");
    public static final RepositoryId NULL = new RepositoryId("IDL:omg.org/CORBA/AbstractBase:1.0");
    public static final RepositoryId EMPTY = new RepositoryId("");
    public static final RepositoryId OBJECT = new RepositoryId("IDL:omg.org/CORBA/Object:1.0");
    public static final RepositoryId NAMING = new RepositoryId(NamingContextHelper.id());
    private static final RepositoryId CLASS_DESC = new RepositoryId(ClassDesc.class);
    private static final RepositoryId NAMING_ANY = new RepositoryId(NamingContextAnyHelper.id());
    private static final RepositoryId CODEBASE = new RepositoryId(CodeBaseHelper.id());
    private static final RepositoryId INT_ID = new RepositoryId("RMI:int:0000000000000000");
    private static final RepositoryId BYTE_ID = new RepositoryId("RMI:byte:0000000000000000");
    private static final RepositoryId LONG_ID = new RepositoryId("RMI:long:0000000000000000");
    private static final RepositoryId FLOAT_ID = new RepositoryId("RMI:float:0000000000000000");
    private static final RepositoryId DOUBLE_ID = new RepositoryId("RMI:double:0000000000000000");
    private static final RepositoryId SHORT_ID = new RepositoryId("RMI:short:0000000000000000");
    private static final RepositoryId CHAR_ID = new RepositoryId("RMI:char:0000000000000000");
    private static final RepositoryId BOOLEAN_ID = new RepositoryId("RMI:boolean:0000000000000000");
    public static final HashMap<RepositoryId, Class<?>> PRIMITIVE_MAP = new HashMap(31);
    private static ConcurrentHashMap<String, String> classNameMap;

    public RepositoryId(InputStream in, int len) {
        super(in, len);
        this.initHash();
    }

    public RepositoryId(InputStream in) {
        super(in);
        this.initHash();
    }

    public RepositoryId(String repId) {
        super(repId);
        this.initHash();
    }

    RepositoryId(RepositoryId repid, String annotation) {
        super(repid);
        this.annotation = annotation;
        this.hash = repid.hash;
    }

    RepositoryId(Class theClass) {
        super(RepositoryId.createRMIRepositoryID(theClass));
        this.setClassLoader(theClass.getClassLoader());
        this.initHash();
    }

    void setClassLoader(ClassLoader loader) {
        if (this.annotation == null) {
            this.annotation = CorbaUtils.getAnnotation(loader);
        }
    }

    public boolean isIDLType() {
        return this.encodedString.length > 3 && this.encodedString[0] == 73 && this.encodedString[1] == 68 && this.encodedString[2] == 76;
    }

    public static RepositoryId createFromRemote(Class c) {
        return new RepositoryId(RepositoryId.createRMIRepositoryID(c));
    }

    public static Set<String> getRemoteIDs(Class aClass) {
        HashSet<String> results = new HashSet<String>();
        Class c = aClass;
        while (Utilities.isARemote((Class)c)) {
            Class<?>[] interfaces;
            for (Class<?> anInterface : interfaces = c.getInterfaces()) {
                if (!Utilities.isARemote(anInterface)) continue;
                results.add(CorbaUtils.isIDLInterface(anInterface) ? RepositoryId.getIDFromIDLEntity(anInterface) : RepositoryId.createRMIRepositoryID(anInterface));
            }
            c = c.getSuperclass();
        }
        return results;
    }

    static RepositoryId[] getRepositoryIdList(Class c) {
        if (c == null || c.getSuperclass() == null || c.getSuperclass().isInterface() || !Serializable.class.isAssignableFrom(c.getSuperclass())) {
            return null;
        }
        ArrayList<RepositoryId> a = new ArrayList<RepositoryId>();
        while (c != null && !c.isInterface() && Serializable.class.isAssignableFrom(c)) {
            a.add(new RepositoryId(c));
            c = c.getSuperclass();
        }
        return a.toArray(new RepositoryId[a.size()]);
    }

    private static String getIDFromIDLEntity(Class c) {
        String name = c.getName();
        String typeid = name.startsWith("org.omg.") ? "IDL:omg.org/" + name.substring("org.omg.".length()).replace('.', '/') + ":1.0" : "IDL:" + c.getName().replace('.', '/') + ":1.0";
        return typeid;
    }

    private static String unconvertIllegalCharacters(String name) {
        for (int j = 0; j < ILLEGAL_CHARS.length; ++j) {
            int idx = name.indexOf(ILLEGAL_CHARS[j]);
            int startidx = 0;
            if (idx < 0) continue;
            StringBuilder result = new StringBuilder();
            while (idx >= 0) {
                result.append(name.substring(startidx, idx)).append(LEGAL_CHARS[j]);
                startidx = idx + ILLEGAL_CHARS[j].length();
                idx = name.indexOf(ILLEGAL_CHARS[j], startidx);
            }
            name = result.append(name.substring(startidx, name.length() - 1)).toString();
        }
        return name;
    }

    public String getClassName() {
        String cname = (String)classNameMap.get((Object)this.toString());
        if (cname == null) {
            String typeid = this.toString();
            if (typeid.startsWith("IDL:omg.org/")) {
                typeid = "org.omg." + typeid.substring("IDL:omg.org/".length());
                int end = typeid.indexOf(58);
                if (end <= 0) {
                    return null;
                }
                cname = typeid.substring(0, end).replace('/', '.');
            } else {
                typeid = RepositoryId.unconvertIllegalCharacters(typeid);
                int start = typeid.indexOf(58);
                int end = typeid.indexOf(58, start + 1);
                if (start <= 0 || end <= 0) {
                    return null;
                }
                cname = typeid.substring(start + 1, end).replace('/', '.');
            }
            RepositoryId.addToMap(this, cname);
        }
        return cname;
    }

    private void initHash() {
        int h = 0;
        int len = this.encodedString.length;
        if (len > 21 && this.encodedString[0] == 82) {
            len -= 17;
        }
        for (int i = 4; i < len; ++i) {
            h = 31 * h + this.encodedString[i];
        }
        this.hash = h;
    }

    @Override
    public final int hashCode() {
        return this.hash;
    }

    @Override
    public final boolean equals(Object other) {
        return other instanceof RepositoryId && this.equals((RepositoryId)other);
    }

    private boolean equals(RepositoryId other) {
        return this.compareStrings(other) && Objects.equals(this.annotation, other.annotation);
    }

    private static String createRMIRepositoryID(Class cl) {
        String ret;
        if (RepositoryId.isIDLEntity(cl)) {
            return CorbaUtils.createIDFromIDLEntity(cl);
        }
        if (cl == String.class) {
            ret = STRING_ID;
        } else if (cl == Class.class) {
            ret = RepositoryId.createRMIRepositoryID(ClassDesc.class);
        } else {
            ObjectStreamClass osc;
            StringBuilder repid = new StringBuilder("RMI:");
            repid.append(RepositoryId.convertIllegalCharacters(cl.getName()));
            repid.append(":");
            Class<?> clazz = cl;
            if (clazz.isArray()) {
                while (clazz.getComponentType() != null) {
                    clazz = clazz.getComponentType();
                }
            }
            if ((osc = ObjectStreamClass.lookup((Class)clazz)) == null || clazz.isInterface() || osc.isArray() && osc.forClass().getComponentType().isPrimitive()) {
                repid.append(RepositoryId.toHexString(0L));
                ret = repid.toString();
            } else {
                repid.append(RepositoryId.toHexString(RepositoryId.computeHashCode(osc, clazz)));
                repid.append(":");
                repid.append(RepositoryId.toHexString(osc.getObjectStreamClass().getSerialVersionUID()));
                ret = repid.toString();
            }
        }
        return ret;
    }

    private static boolean isIDLEntity(Class c) {
        return !IDLEntity.class.equals((Object)c) && IDLEntity.class.isAssignableFrom(c);
    }

    public static String toHexString(long l) {
        StringBuilder b = new StringBuilder();
        String hex = Long.toHexString(l).toUpperCase();
        int i = 16 - hex.length();
        while (i-- > 0) {
            b.append('0');
        }
        b.append(hex);
        return b.toString();
    }

    private static String convertIllegalCharacters(String name) {
        StringBuilder result = new StringBuilder();
        block4: for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            switch (c) {
                case '\\': {
                    if ('u' == name.charAt(i + 1)) {
                        result.append("U");
                        for (int k = i + 2; k < i + 5; ++k) {
                            result.append(Character.toUpperCase(name.charAt(k)));
                        }
                        i += 4;
                        continue block4;
                    }
                    result.append(c);
                    continue block4;
                }
                case '$': {
                    result.append("\\U0024");
                    continue block4;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    private static long computeHashCode(ObjectStreamClass osc, Class cl) {
        try {
            if (!Serializable.class.isAssignableFrom(cl) || cl.isInterface()) {
                return 0L;
            }
            if (Externalizable.class.isAssignableFrom(cl)) {
                return 1L;
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream(512);
            MessageDigest digest = MessageDigest.getInstance("SHA");
            DigestOutputStream dout = new DigestOutputStream(bout, digest);
            DataOutputStream data = new DataOutputStream(dout);
            Class parent = cl.getSuperclass();
            if (parent != null) {
                data.writeLong(RepositoryId.computeHashCode(osc.getSuperclass(), parent));
            }
            if (osc.hasWriteObject()) {
                data.writeInt(2);
            } else {
                data.writeInt(1);
            }
            ObjectStreamField[] fields = osc.getFields();
            Arrays.sort(fields, new Comparator<ObjectStreamField>(){

                @Override
                public int compare(ObjectStreamField obj1, ObjectStreamField obj2) {
                    return obj1.getName().compareTo(obj2.getName());
                }
            });
            for (ObjectStreamField field : fields) {
                data.writeUTF(field.getName());
                data.writeUTF(field.getSignature());
            }
            data.flush();
            long hcode = 0L;
            byte[] hash = digest.digest();
            for (int i = 0; i < Math.min(8, hash.length); ++i) {
                hcode += (long)(hash[i] & 0xFF) << i * 8;
            }
            return hcode;
        }
        catch (IOException ioe) {
            return -1L;
        }
        catch (NoSuchAlgorithmException nsae) {
            return -1L;
        }
    }

    private static void addToMap(RepositoryId id, String className) {
        classNameMap.put((Object)id.toString(), (Object)className);
    }

    private static void initialize() {
        RepositoryId.addToMap(NAMING, "org.omg.CosNaming.NamingContext");
        RepositoryId.addToMap(STRING, "java.lang.String");
        RepositoryId.addToMap(NAMING_ANY, "weblogic.corba.cos.naming.NamingContextAny");
        try {
            Class.forName("com.sun.org.omg.SendingContext.CodeBase");
            RepositoryId.addToMap(CODEBASE, "com.sun.org.omg.SendingContext.CodeBase");
        }
        catch (ClassNotFoundException cnfe) {
            try {
                Class.forName("com.ibm.org.omg.SendingContext.CodeBase");
                RepositoryId.addToMap(CODEBASE, "com.ibm.org.omg.SendingContext.CodeBase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public boolean isClassDesc() {
        return this.compareStrings(CLASS_DESC);
    }

    public String toPrettyString() {
        return this.toString() + "@" + this.getAnnotation();
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(String annotation) {
        this.annotation = annotation;
    }

    static {
        PRIMITIVE_MAP.put(INT_ID, Integer.TYPE);
        PRIMITIVE_MAP.put(BYTE_ID, Byte.TYPE);
        PRIMITIVE_MAP.put(LONG_ID, Long.TYPE);
        PRIMITIVE_MAP.put(FLOAT_ID, Float.TYPE);
        PRIMITIVE_MAP.put(DOUBLE_ID, Double.TYPE);
        PRIMITIVE_MAP.put(SHORT_ID, Short.TYPE);
        PRIMITIVE_MAP.put(CHAR_ID, Character.TYPE);
        PRIMITIVE_MAP.put(BOOLEAN_ID, Boolean.TYPE);
        classNameMap = new ConcurrentHashMap();
        RepositoryId.initialize();
    }
}

