/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.context;

import org.jvnet.hk2.annotations.Service;
import weblogic.diagnostics.context.Correlation;
import weblogic.diagnostics.context.DiagnosticContext;
import weblogic.diagnostics.context.DiagnosticContextFactory;
import weblogic.diagnostics.context.DiagnosticContextImpl;
import weblogic.diagnostics.context.JavaSECorrelationImpl;
import weblogic.kernel.KernelStatus;

@Service
public final class CorrelationFactory
implements org.glassfish.hk2.api.Factory<Correlation> {
    static final String DMS_ENTRY_NAME_IN_MAP = "oracle.dms.context.internal.wls.WLSContextFamily";
    private static final Factory DEFAULT_FACTORY;
    private static Factory SINGLETON;
    private static boolean contextEnabled;
    private static int remotePropagationMode;
    private static int propagationMode;
    private static int nonInheritablePropagationMode;

    static synchronized void setFactory(Factory factory) {
        if (!KernelStatus.isServer() || SINGLETON != DEFAULT_FACTORY || factory == null) {
            return;
        }
        SINGLETON = factory;
    }

    public static boolean isEnabled() {
        return contextEnabled;
    }

    static void setEnabled(boolean val) {
        contextEnabled = val;
    }

    static int getRemotePropagationMode() {
        return remotePropagationMode;
    }

    static int getPropagationMode() {
        return propagationMode;
    }

    static void setPropagationMode(int val) {
        propagationMode = val;
    }

    static int getNonInheritablePropagationMode() {
        return nonInheritablePropagationMode;
    }

    @Override
    public Correlation provide() {
        return CorrelationFactory.findOrCreateCorrelation();
    }

    @Override
    public void dispose(Correlation correlation) {
    }

    public static Correlation findOrCreateCorrelation() {
        return CorrelationFactory.findOrCreateCorrelation(contextEnabled);
    }

    public static Correlation findOrCreateCorrelation(boolean enabled) {
        if (!KernelStatus.isServer()) {
            enabled = true;
        }
        return SINGLETON.findOrCreateCorrelation(enabled);
    }

    public static Correlation findCorrelation() {
        if (KernelStatus.isServer()) {
            return SINGLETON.findOrCreateCorrelation(false);
        }
        DiagnosticContext dc = DiagnosticContextFactory.getDiagnosticContext();
        if (dc == null) {
            return null;
        }
        return new JavaSECorrelationImpl((DiagnosticContextImpl)dc);
    }

    public static void invalidateCache() {
        SINGLETON.invalidateCache();
    }

    public static void setJFRThrottled(Correlation ctx) {
        SINGLETON.setJFRThrottled(ctx);
    }

    static void handleLocalContextAsNonInheritable() {
        SINGLETON.handleLocalContextAsNonInheritable();
    }

    static void setCorrelation(Correlation ctx) {
        SINGLETON.setCorrelation(ctx);
    }

    static void updateCorrelation(Correlation ctx) {
        SINGLETON.updateCorrelation(ctx);
    }

    static {
        SINGLETON = DEFAULT_FACTORY = new DefaultFactoryImpl();
        remotePropagationMode = 124;
        propagationMode = 383;
        nonInheritablePropagationMode = 1;
    }

    private static class DefaultFactoryImpl
    implements Factory {
        private DefaultFactoryImpl() {
        }

        @Override
        public Correlation findOrCreateCorrelation(boolean enabled) {
            if (KernelStatus.isServer()) {
                return null;
            }
            DiagnosticContext dc = DiagnosticContextFactory.findOrCreateDiagnosticContext(enabled);
            if (dc == null) {
                return null;
            }
            return new JavaSECorrelationImpl((DiagnosticContextImpl)dc);
        }

        @Override
        public void invalidateCache() {
        }

        @Override
        public void setJFRThrottled(Correlation ctx) {
        }

        @Override
        public void correlationPropagatedIn(Correlation ctx) {
        }

        @Override
        public void setCorrelation(Correlation ctx) {
            if (ctx == null) {
                DiagnosticContextFactory.setDiagnosticContext(null);
            }
            if (!(ctx instanceof JavaSECorrelationImpl)) {
                throw new UnsupportedOperationException("Operation not supported on client");
            }
            DiagnosticContextFactory.setDiagnosticContext(((JavaSECorrelationImpl)ctx).getDiagnosticContextImpl());
        }

        @Override
        public void updateCorrelation(Correlation ctx) {
            throw new UnsupportedOperationException("Operation not supported on client");
        }

        @Override
        public void handleLocalContextAsNonInheritable() {
        }
    }

    public static interface Factory {
        public Correlation findOrCreateCorrelation(boolean var1);

        public void invalidateCache();

        public void setJFRThrottled(Correlation var1);

        public void correlationPropagatedIn(Correlation var1);

        public void setCorrelation(Correlation var1);

        public void updateCorrelation(Correlation var1);

        public void handleLocalContextAsNonInheritable();
    }
}

