/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.context;

import java.util.HashSet;
import java.util.logging.Level;
import weblogic.diagnostics.context.Correlation;
import weblogic.diagnostics.context.CorrelationFactory;
import weblogic.diagnostics.context.InvalidDyeException;
import weblogic.diagnostics.context.JavaSECorrelationImpl;
import weblogic.diagnostics.type.DiagnosticException;
import weblogic.kernel.KernelStatus;

public final class CorrelationHelper {
    private static DyeInfo[] dyeInfos = new DyeInfo[]{new DyeInfo("ADDR1", 1L), new DyeInfo("ADDR2", 2L), new DyeInfo("ADDR3", 4L), new DyeInfo("ADDR4", 8L), new DyeInfo("USER1", 16L), new DyeInfo("USER2", 32L), new DyeInfo("USER3", 64L), new DyeInfo("USER4", 128L), new DyeInfo("COOKIE1", 256L), new DyeInfo("COOKIE2", 512L), new DyeInfo("COOKIE3", 1024L), new DyeInfo("COOKIE4", 2048L), new DyeInfo("EXECQ1", 4096L), new DyeInfo("EXECQ2", 8192L), new DyeInfo("EXECQ3", 16384L), new DyeInfo("EXECQ4", 32768L), new DyeInfo("THREADGROUP1", 65536L), new DyeInfo("THREADGROUP2", 131072L), new DyeInfo("THREADGROUP3", 262144L), new DyeInfo("THREADGROUP4", 524288L), new DyeInfo("PROTOCOL_T3", 0x100000L), new DyeInfo("PROTOCOL_HTTP", 0x200000L), new DyeInfo("PROTOCOL_RMI", 0x400000L), new DyeInfo("PROTOCOL_SOAP", 0x800000L), new DyeInfo("PROTOCOL_IIOP", 0x1000000L), new DyeInfo("PROTOCOL_JRMP", 0x2000000L), new DyeInfo("PROTOCOL_SSL", 0x4000000L), new DyeInfo("CONNECTOR1", 0x8000000L), new DyeInfo("CONNECTOR2", 0x10000000L), new DyeInfo("CONNECTOR3", 0x20000000L), new DyeInfo("CONNECTOR4", 0x40000000L), new DyeInfo("THROTTLE", 0x100000000L), new DyeInfo("JFR_THROTTLE", 0x200000000L), new DyeInfo("DYE_0", 0x100000000000000L), new DyeInfo("DYE_1", 0x200000000000000L), new DyeInfo("DYE_2", 0x400000000000000L), new DyeInfo("DYE_3", 0x800000000000000L), new DyeInfo("DYE_4", 0x1000000000000000L), new DyeInfo("DYE_5", 0x2000000000000000L), new DyeInfo("DYE_6", 0x4000000000000000L), new DyeInfo("DYE_7", Long.MIN_VALUE)};

    public static String getContextId() {
        Correlation ctx = CorrelationFactory.findOrCreateCorrelation();
        return ctx != null ? ctx.getECID() : null;
    }

    public static void setContextId(String dcid, String rid) throws DiagnosticException {
        if (KernelStatus.isServer()) {
            throw new DiagnosticException("Operation not allowed on server");
        }
        if (dcid == null) {
            throw new IllegalArgumentException("ID must not be null");
        }
        JavaSECorrelationImpl ctx = (JavaSECorrelationImpl)CorrelationFactory.findCorrelation();
        if (ctx != null) {
            throw new DiagnosticException("Existing DiagnosticContext can not be overridden");
        }
        ctx = new JavaSECorrelationImpl(dcid, rid);
        CorrelationFactory.setCorrelation(ctx);
    }

    public static void setApplicationDye(byte dye, boolean enable) throws InvalidDyeException {
        if (dye < 56 || dye > 63) {
            throw new InvalidDyeException("Invalid dye index " + dye);
        }
        Correlation ctx = CorrelationFactory.findOrCreateCorrelation();
        if (ctx != null) {
            ctx.setDye(dye, enable);
        }
    }

    public static boolean isDyedWith(byte dye) throws InvalidDyeException {
        Correlation ctx = CorrelationFactory.findOrCreateCorrelation();
        return ctx != null ? ctx.isDyedWith(dye) : false;
    }

    public static String getPayload() {
        Correlation ctx = CorrelationFactory.findOrCreateCorrelation();
        return ctx != null ? ctx.getPayload() : null;
    }

    public static void setPayload(String payload) {
        Correlation ctx = CorrelationFactory.findOrCreateCorrelation();
        if (ctx != null) {
            ctx.setPayload(payload);
        }
    }

    public static long parseDyeMask(String mask) {
        if (mask == null) {
            return 0L;
        }
        String[] maskNames = mask.split(",");
        return CorrelationHelper.parseDyeMask(maskNames);
    }

    public static long parseDyeMask(String[] maskNames) {
        long maskValue = 0L;
        int size = maskNames != null ? maskNames.length : 0;
        for (int i = 0; i < size; ++i) {
            String mName = maskNames[i].trim();
            maskValue |= CorrelationHelper.getDyeValue(mName);
        }
        return maskValue;
    }

    public static String[] getDyeFlagNames() {
        String[] dyeNames = new String[dyeInfos.length];
        for (int i = 0; i < dyeInfos.length; ++i) {
            dyeNames[i] = CorrelationHelper.dyeInfos[i].dyeName;
        }
        return dyeNames;
    }

    public static void validateDyeFlagNames(String[] maskNames) {
        if (maskNames == null || maskNames.length == 0) {
            return;
        }
        HashSet<String> dyeNames = new HashSet<String>();
        for (int i = 0; i < dyeInfos.length; ++i) {
            dyeNames.add(CorrelationHelper.dyeInfos[i].dyeName);
        }
        for (int j = 0; j < maskNames.length; ++j) {
            if (dyeNames.contains(maskNames[j])) continue;
            throw new IllegalArgumentException("Dye name is invalid " + maskNames[j]);
        }
    }

    private static long getDyeValue(String dyeName) {
        for (int i = 0; i < dyeInfos.length; ++i) {
            if (!dyeName.equals(CorrelationHelper.dyeInfos[i].dyeName)) continue;
            return CorrelationHelper.dyeInfos[i].dyeValue;
        }
        return 0L;
    }

    public static synchronized void registerDye(String dyeName, int index) throws InvalidDyeException {
        if (index < 0 || index > 63) {
            throw new InvalidDyeException("Invalid dye index " + index);
        }
        long dyeValue = 1L << index;
        int size = dyeInfos.length;
        for (int i = 0; i < size; ++i) {
            DyeInfo dyeInfo = dyeInfos[i];
            if (dyeName.equals(dyeInfo.dyeName)) {
                throw new InvalidDyeException("Dye " + dyeName + " is already defined");
            }
            if (dyeInfo.dyeValue != dyeValue) continue;
            throw new InvalidDyeException("Dye " + dyeInfo.dyeName + " is already defined as dye " + index);
        }
        DyeInfo[] tmp = new DyeInfo[size + 1];
        System.arraycopy(dyeInfos, 0, tmp, 0, size);
        tmp[size] = new DyeInfo(dyeName, dyeValue);
        dyeInfos = tmp;
    }

    public static String getRID() {
        Correlation ctx = CorrelationFactory.findOrCreateCorrelation();
        return ctx != null ? ctx.getRID() : null;
    }

    public static Level getLogLevel() {
        Correlation ctx = CorrelationFactory.findOrCreateCorrelation();
        return ctx != null ? ctx.getLogLevel() : null;
    }

    public static void setLogLevel(Level level) {
        Correlation ctx = CorrelationFactory.findOrCreateCorrelation();
        if (ctx != null) {
            ctx.setLogLevel(level);
        }
    }

    public static long getDyeVector() {
        Correlation ctx = CorrelationFactory.findOrCreateCorrelation();
        return ctx != null ? ctx.getDyeVector() : 0L;
    }

    public static void handleLocalContextAsNonInheritable() {
        CorrelationFactory.handleLocalContextAsNonInheritable();
    }

    public static String getStringifiedVectorForDebug(long vector) {
        StringBuffer sb = new StringBuffer();
        sb.append("dyeVector[");
        if ((vector & 1L) != 0L) {
            sb.append("M_ADDR1 ");
        }
        if ((vector & 2L) != 0L) {
            sb.append("M_ADDR2 ");
        }
        if ((vector & 4L) != 0L) {
            sb.append("M_ADDR3 ");
        }
        if ((vector & 8L) != 0L) {
            sb.append("M_ADDR4 ");
        }
        if ((vector & 0x10L) != 0L) {
            sb.append("M_USER1 ");
        }
        if ((vector & 0x20L) != 0L) {
            sb.append("M_USER2 ");
        }
        if ((vector & 0x40L) != 0L) {
            sb.append("M_USER3 ");
        }
        if ((vector & 0x80L) != 0L) {
            sb.append("M_USER4 ");
        }
        if ((vector & 0x100L) != 0L) {
            sb.append("M_COOKIE1 ");
        }
        if ((vector & 0x200L) != 0L) {
            sb.append("M_COOKIE2 ");
        }
        if ((vector & 0x400L) != 0L) {
            sb.append("M_COOKIE3 ");
        }
        if ((vector & 0x800L) != 0L) {
            sb.append("M_COOKIE4 ");
        }
        if ((vector & 0x1000L) != 0L) {
            sb.append("M_EXECQ1 ");
        }
        if ((vector & 0x2000L) != 0L) {
            sb.append("M_EXECQ2 ");
        }
        if ((vector & 0x4000L) != 0L) {
            sb.append("M_EXECQ3 ");
        }
        if ((vector & 0x8000L) != 0L) {
            sb.append("M_EXECQ4 ");
        }
        if ((vector & 0x10000L) != 0L) {
            sb.append("M_THREADGROUP1 ");
        }
        if ((vector & 0x20000L) != 0L) {
            sb.append("M_THREADGROUP2 ");
        }
        if ((vector & 0x40000L) != 0L) {
            sb.append("M_THREADGROUP3 ");
        }
        if ((vector & 0x80000L) != 0L) {
            sb.append("M_THREADGROUP4 ");
        }
        if ((vector & 0x100000L) != 0L) {
            sb.append("M_PROTOCOL_T3 ");
        }
        if ((vector & 0x200000L) != 0L) {
            sb.append("M_PROTOCOL_HTTP ");
        }
        if ((vector & 0x400000L) != 0L) {
            sb.append("M_PROTOCOL_RMI ");
        }
        if ((vector & 0x800000L) != 0L) {
            sb.append("M_PROTOCOL_SOAP ");
        }
        if ((vector & 0x1000000L) != 0L) {
            sb.append("M_PROTOCOL_IIOP ");
        }
        if ((vector & 0x2000000L) != 0L) {
            sb.append("M_PROTOCOL_JRMP ");
        }
        if ((vector & 0x4000000L) != 0L) {
            sb.append("M_PROTOCOL_SSL ");
        }
        if ((vector & 0x8000000L) != 0L) {
            sb.append("M_CONNECTOR1 ");
        }
        if ((vector & 0x10000000L) != 0L) {
            sb.append("M_CONNECTOR2 ");
        }
        if ((vector & 0x20000000L) != 0L) {
            sb.append("M_CONNECTOR3 ");
        }
        if ((vector & 0x40000000L) != 0L) {
            sb.append("M_CONNECTOR4 ");
        }
        if ((vector & 0x80000000L) != 0L) {
            sb.append("M_EVENT_BEING_PERSISTED ");
        }
        if ((vector & 0x100000000L) != 0L) {
            sb.append("M_THROTTLE ");
        }
        if ((vector & 0x200000000L) != 0L) {
            sb.append("M_JFR_THROTTLE ");
        }
        if ((vector & 0x100000000000000L) != 0L) {
            sb.append("M_DYE_0 ");
        }
        if ((vector & 0x200000000000000L) != 0L) {
            sb.append("M_DYE_1 ");
        }
        if ((vector & 0x400000000000000L) != 0L) {
            sb.append("M_DYE_2 ");
        }
        if ((vector & 0x800000000000000L) != 0L) {
            sb.append("M_DYE_3 ");
        }
        if ((vector & 0x1000000000000000L) != 0L) {
            sb.append("M_DYE_4 ");
        }
        if ((vector & 0x2000000000000000L) != 0L) {
            sb.append("M_DYE_5 ");
        }
        if ((vector & 0x4000000000000000L) != 0L) {
            sb.append("M_DYE_6 ");
        }
        if ((vector & Long.MIN_VALUE) != 0L) {
            sb.append("M_DYE_7 ");
        }
        sb.append("]");
        return sb.toString();
    }

    private static class DyeInfo {
        String dyeName;
        long dyeValue;

        DyeInfo(String dyeName, long dyeValue) {
            this.dyeName = dyeName;
            this.dyeValue = dyeValue;
        }
    }
}

