/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.context;

import java.util.logging.Level;
import weblogic.diagnostics.context.CorrelationHelper;
import weblogic.diagnostics.context.DiagnosticContextConstants;
import weblogic.diagnostics.context.InvalidDyeException;

public final class DiagnosticContextHelper
implements DiagnosticContextConstants {
    public static String getContextId() {
        return CorrelationHelper.getContextId();
    }

    public static void setDye(byte dye, boolean enable) throws InvalidDyeException {
        CorrelationHelper.setApplicationDye(dye, enable);
    }

    public static void setApplicationDye(byte dye, boolean enable) throws InvalidDyeException {
        CorrelationHelper.setApplicationDye(dye, enable);
    }

    public static boolean isDyedWith(byte dye) throws InvalidDyeException {
        return CorrelationHelper.isDyedWith(dye);
    }

    public static String getPayload() {
        return CorrelationHelper.getPayload();
    }

    public static void setPayload(String payload) {
        CorrelationHelper.setPayload(payload);
    }

    public static long parseDyeMask(String mask) {
        return CorrelationHelper.parseDyeMask(mask);
    }

    public static long parseDyeMask(String[] maskNames) {
        return CorrelationHelper.parseDyeMask(maskNames);
    }

    public static String[] getDyeFlagNames() {
        return CorrelationHelper.getDyeFlagNames();
    }

    public static void validateDyeFlagNames(String[] maskNames) {
        CorrelationHelper.validateDyeFlagNames(maskNames);
    }

    public static void registerDye(String dyeName, int index) throws InvalidDyeException {
        CorrelationHelper.registerDye(dyeName, index);
    }

    public static String getRID() {
        return CorrelationHelper.getRID();
    }

    public static int getLogLevel() {
        Level level = CorrelationHelper.getLogLevel();
        if (level == null) {
            return -1;
        }
        return level.intValue();
    }

    public static void setLogLevel(int level) {
        if (level != -1) {
            try {
                CorrelationHelper.setLogLevel(Level.parse(Integer.toString(level)));
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        CorrelationHelper.setLogLevel(null);
    }

    public static long getDyeVector() {
        return CorrelationHelper.getDyeVector();
    }

    public static void handleLocalContextAsNonInheritable() {
        CorrelationHelper.handleLocalContextAsNonInheritable();
    }
}

