/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.debug;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import weblogic.diagnostics.debug.DebugLogger;

public final class DebugLoggerRepository {
    static final String DEFAULT_CMDLINE_OVERRIDE_PREFIX = "weblogic.debug.";
    private Map debugLoggers = new HashMap();
    private Logger jdkLogger = DebugLoggerRepository.createAndInitAnonymousLogger();
    private String cmdlineOveridePrifix;
    private Properties debugLoggerParameters = new Properties();

    DebugLoggerRepository() {
        try {
            this.cmdlineOveridePrifix = System.getProperty("weblogic.diagnostics.debug.DefaultCommandLinePrefix", DEFAULT_CMDLINE_OVERRIDE_PREFIX);
        }
        catch (Exception e) {
            this.cmdlineOveridePrifix = DEFAULT_CMDLINE_OVERRIDE_PREFIX;
        }
    }

    DebugLoggerRepository(String propPrefix) {
        this.cmdlineOveridePrifix = propPrefix;
    }

    public Logger getLogger() {
        return this.jdkLogger;
    }

    public synchronized void setLogger(Logger l) {
        this.jdkLogger = l;
    }

    public synchronized DebugLogger getDebugLogger(String loggerName) {
        DebugLogger logger = (DebugLogger)this.debugLoggers.get(loggerName);
        if (logger == null) {
            logger = new DebugLogger(loggerName, this);
            this.debugLoggers.put(loggerName, logger);
            try {
                boolean debugEnabled = Boolean.getBoolean(this.cmdlineOveridePrifix + loggerName);
                logger.setDebugEnabled(debugEnabled);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return logger;
    }

    private static Logger createAndInitAnonymousLogger() {
        Logger logger = Logger.getAnonymousLogger();
        logger.setUseParentHandlers(false);
        logger.setLevel(Level.FINE);
        StreamHandler handler = new StreamHandler(System.out, new SimpleFormatter()){

            @Override
            public void publish(LogRecord lr) {
                super.publish(lr);
                super.flush();
            }

            @Override
            public void close() {
                super.flush();
            }
        };
        try {
            handler.setLevel(Level.FINE);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        logger.addHandler(handler);
        return logger;
    }

    public Properties getDebugLoggerParameters() {
        return this.debugLoggerParameters;
    }

    public void setDebugLoggerParameters(Properties params) {
        this.debugLoggerParameters = params;
        for (Object obj : this.debugLoggers.values()) {
            DebugLogger dl = (DebugLogger)obj;
            dl.getDebugParameters().clear();
        }
        if (this.debugLoggerParameters == null) {
            return;
        }
        for (Object key : this.debugLoggerParameters.keySet()) {
            String keyName;
            int index;
            if (key == null || (index = (keyName = key.toString()).indexOf(46)) < 0) continue;
            String debugLoggerName = keyName.substring(0, index);
            DebugLogger dl = this.getDebugLogger(debugLoggerName);
            if (keyName.length() <= index + 1) continue;
            String paramName = keyName.substring(index + 1);
            String value = this.debugLoggerParameters.get(key).toString();
            dl.getDebugParameters().put(paramName, value);
        }
    }
}

