/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.flightrecorder;

import java.lang.reflect.Method;

public class JFRDebug {
    private static boolean initialized = false;
    private static boolean isValid = false;
    private static Method beginDebugTimedEventMtd;
    private static Method commitDebugTimedEventMtd;
    private static Method generateDebugEventMtd;

    private static synchronized void ensureInitialized() {
        if (initialized) {
            return;
        }
        try {
            Class<?> managerClazz = Class.forName("weblogic.diagnostics.flightrecorder.FlightRecorderManager");
            beginDebugTimedEventMtd = managerClazz.getDeclaredMethod("beginDebugTimedEvent", String.class, String.class, Object.class);
            commitDebugTimedEventMtd = managerClazz.getDeclaredMethod("commitDebugTimedEvent", Object.class, Throwable.class, Object.class);
            generateDebugEventMtd = managerClazz.getDeclaredMethod("generateDebugEvent", String.class, String.class, Throwable.class, Object.class);
            isValid = true;
        }
        catch (Throwable th) {
            isValid = false;
        }
        initialized = true;
    }

    public static Object beginDebugTimedEvent(String component, String message, Object contributor) {
        if (!initialized) {
            JFRDebug.ensureInitialized();
        }
        if (!isValid) {
            return null;
        }
        try {
            return beginDebugTimedEventMtd.invoke(null, component, message, contributor);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static Object beginDebugTimedEvent(String message) {
        return JFRDebug.beginDebugTimedEvent(null, message, null);
    }

    public static Object beginDebugTimedEvent(String message, Object contributor) {
        return JFRDebug.beginDebugTimedEvent(null, message, contributor);
    }

    public static void commitDebugTimedEvent(Object event, Throwable debugTh, Object contributor) {
        JFRDebug.ensureInitialized();
        if (!isValid || event == null) {
            return;
        }
        try {
            commitDebugTimedEventMtd.invoke(null, event, debugTh, contributor);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void commitDebugTimedEvent(Object event, Throwable debugTh) {
        JFRDebug.commitDebugTimedEvent(event, debugTh, null);
    }

    public static void commitDebugTimedEvent(Object event) {
        JFRDebug.commitDebugTimedEvent(event, null, null);
    }

    public static void generateDebugEvent(String component, String message, Throwable debugTh, Object contributor) {
        JFRDebug.ensureInitialized();
        if (!isValid) {
            return;
        }
        try {
            generateDebugEventMtd.invoke(null, component, message, debugTh, contributor);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void generateDebugEvent(String component, String message, Throwable debugTh) {
        JFRDebug.generateDebugEvent(component, message, debugTh, null);
    }

    public static void generateDebugEvent(String message) {
        JFRDebug.generateDebugEvent(null, message, null, null);
    }

    public static void generateDebugEvent(String message, Object contributor) {
        JFRDebug.generateDebugEvent(null, message, null, contributor);
    }
}

