/*
 * Decompiled with CFR 0.152.
 */
package weblogic.i18n.logging;

import java.util.Date;
import weblogic.i18n.logging.LogMessage;
import weblogic.i18n.logging.Severities;

class BasicLogMessageFormatter {
    private static final String EOL = System.getProperty("line.separator");
    private String fieldPrefix;
    private String fieldSuffix;

    public BasicLogMessageFormatter() {
        this("", "");
    }

    public BasicLogMessageFormatter(String prefix, String suffix) {
        this.fieldPrefix = prefix;
        this.fieldSuffix = suffix;
    }

    public String getFieldPrefix() {
        return this.fieldPrefix;
    }

    public void setFieldPrefix(String fieldPrefix) {
        this.fieldPrefix = fieldPrefix;
    }

    public String getFieldSuffix() {
        return this.fieldSuffix;
    }

    public void setFieldSuffix(String fieldSuffix) {
        this.fieldSuffix = fieldSuffix;
    }

    String formatLogMessage(LogMessage logMessage) {
        StringBuffer buf = new StringBuffer();
        this.appendField(buf, new Date().toString());
        String severity = Severities.severityNumToString(logMessage.getSeverity());
        this.appendField(buf, severity);
        this.appendBaseLogMessageFields(logMessage, buf);
        return buf.toString();
    }

    String formatBaseLogMessageFields(LogMessage logMessage) {
        StringBuffer buf = new StringBuffer();
        this.appendBaseLogMessageFields(logMessage, buf);
        return buf.toString();
    }

    void appendBaseLogMessageFields(LogMessage logMessage, StringBuffer buf) {
        String msgId;
        this.appendField(buf, logMessage.getSubsystem());
        String prefix = logMessage.getMessageIdPrefix();
        if (prefix == null || prefix.length() == 0) {
            prefix = "BEA";
        }
        if ((msgId = logMessage.getMessageId()) == null || msgId.length() == 0) {
            msgId = "000000";
        }
        this.appendField(buf, prefix + "-" + msgId);
        if (logMessage.getThrowable() == null) {
            this.appendField(buf, logMessage.getMessage());
        } else {
            buf.append(this.fieldPrefix);
            buf.append(logMessage.getMessage());
            buf.append(EOL);
            Throwable th = logMessage.getThrowable();
            StackTraceElement[] stackTrace = th.getStackTrace();
            for (int i = 0; i < stackTrace.length; ++i) {
                buf.append("\tat ");
                buf.append(stackTrace[i]);
                buf.append(EOL);
            }
            buf.append(this.fieldSuffix);
        }
    }

    private void appendField(StringBuffer buf, String field) {
        buf.append(this.fieldPrefix);
        buf.append(field);
        buf.append(this.fieldSuffix);
    }
}

