/*
 * Decompiled with CFR 0.152.
 */
package weblogic.i18n.logging;

import java.text.MessageFormat;
import java.util.Locale;
import weblogic.i18n.Localizer;
import weblogic.i18n.logging.LogMessage;
import weblogic.i18ntools.L10nLookup;

public class CatalogMessage
extends LogMessage {
    private Object[] messageArgs;
    private boolean stackTraceEnabled;
    private String diagnosticVolume;
    private boolean excludePartition;

    public CatalogMessage(String msgId, Object[] args, String resourceName) {
        this(msgId, args, resourceName, null);
    }

    public CatalogMessage(String msgId, Object[] args, String resourceName, ClassLoader loader) {
        this.setMessageId(msgId);
        this.messageArgs = args;
        Localizer localizer = L10nLookup.getLocalizer(Locale.getDefault(), resourceName, loader);
        super.setMessage(MessageFormat.format(localizer.getBody(msgId), this.messageArgs));
        super.setSeverity(localizer.getSeverity(msgId));
        super.setMsgIdPrefix(localizer.getPrefix());
        super.setSubsystem(localizer.getSubSystem());
        this.initThrowable();
    }

    public CatalogMessage(String msgId, int severity, Object[] args, String resourceName) {
        this(msgId, severity, args, resourceName, null);
    }

    public CatalogMessage(String messageId, int severity, Object[] args, String resourceName, ClassLoader resourceClassLoader) {
        this(messageId, severity, args, L10nLookup.getLocalizer(Locale.getDefault(), resourceName, resourceClassLoader));
    }

    public CatalogMessage(String messageId, int severity, Object[] args, Localizer localizer) {
        this.setMessageId(messageId);
        this.messageArgs = args;
        super.setSeverity(severity);
        super.setMsgIdPrefix(localizer.getPrefix());
        super.setSubsystem(localizer.getSubSystem());
        super.setMessage(MessageFormat.format(localizer.getBody2(messageId), this.messageArgs));
        this.initThrowable();
    }

    public boolean isStackTraceEnabled() {
        return this.stackTraceEnabled;
    }

    public void setStackTraceEnabled(boolean stackTraceEnabled) {
        this.stackTraceEnabled = stackTraceEnabled;
    }

    public Object[] getArguments() {
        return this.messageArgs;
    }

    public String getDiagnosticVolume() {
        return this.diagnosticVolume;
    }

    public void setDiagnosticVolume(String diagnosticVolume) {
        this.diagnosticVolume = diagnosticVolume;
    }

    private void initThrowable() {
        Object throwableCandidate;
        int candidateIndex;
        Object[] args = this.messageArgs;
        if (args != null && (candidateIndex = args.length - 1) >= 0 && (throwableCandidate = args[candidateIndex]) instanceof Throwable) {
            this.setThrowable((Throwable)throwableCandidate);
        }
    }

    public boolean isExcludePartition() {
        return this.excludePartition;
    }

    public void setExcludePartition(boolean excludePartition) {
        this.excludePartition = excludePartition;
    }
}

