/*
 * Decompiled with CFR 0.152.
 */
package weblogic.i18n.logging;

import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.i18n.logging.BasicLogMessageFormatter;
import weblogic.i18n.logging.LogMessage;
import weblogic.i18n.logging.MessageDispatcher;
import weblogic.i18n.logging.MessageLogger;
import weblogic.i18n.logging.Severities;

public class CoreEnginePrimordialLoggerWrapper
implements MessageLogger,
MessageDispatcher {
    public static final String PRIMORDIAL_LOGGER_PROPERTY = "com.bea.logging.PrimordialLoggingService";
    private Logger primordialLogger;
    private BasicLogMessageFormatter basicFormatter = new BasicLogMessageFormatter("", ": ");
    private static CoreEnginePrimordialLoggerWrapper instance;

    private CoreEnginePrimordialLoggerWrapper(Logger l) {
        this.primordialLogger = l;
    }

    public static synchronized CoreEnginePrimordialLoggerWrapper getInstance() throws Exception {
        Class<?> clz;
        Logger frameworkLogger;
        String loggingBootstrapClass;
        if (instance == null && (loggingBootstrapClass = System.getProperty(PRIMORDIAL_LOGGER_PROPERTY)) != null && (frameworkLogger = (Logger)(clz = Class.forName(loggingBootstrapClass)).getMethod("getJDKLogger", null).invoke(null, (Object[])null)) != null) {
            instance = new CoreEnginePrimordialLoggerWrapper(frameworkLogger);
        }
        return instance;
    }

    @Override
    public boolean isSeverityEnabled(String subSystem, int messageSeverity) {
        return this.isSeverityEnabled(messageSeverity);
    }

    @Override
    public void log(String subsystem, int severityLevel, String message) {
        this.log(subsystem, severityLevel, message, null);
    }

    @Override
    public void log(String subsystem, int severityLevel, String message, Throwable throwable) {
        this.log(new LogMessage("", "", subsystem, severityLevel, message, throwable));
    }

    @Override
    public void log(LogMessage logMessage) {
        Level logLevel = Severities.severityToJDKLoggerLevel(logMessage.getSeverity());
        String message = this.basicFormatter.formatBaseLogMessageFields(logMessage);
        this.primordialLogger.log(logLevel, message, logMessage.getThrowable());
    }

    @Override
    public MessageDispatcher getMessageDispatcher(String name) {
        return this;
    }

    @Override
    public String getName() {
        return this.primordialLogger.getName();
    }

    @Override
    public boolean isSeverityEnabled(int severity) {
        return this.primordialLogger.isLoggable(Severities.severityToJDKLoggerLevel(severity));
    }

    @Override
    public int getSeverity() {
        Level level = this.primordialLogger.getLevel();
        if (level == null) {
            level = Level.INFO;
        }
        return Severities.getSeverity(level);
    }

    @Override
    public void setSeverity(int severity) {
        this.primordialLogger.setLevel(Severities.severityToJDKLoggerLevel(severity));
    }
}

