/*
 * Decompiled with CFR 0.152.
 */
package weblogic.i18n.logging;

import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import weblogic.i18n.logging.BasicMessageLogger;
import weblogic.i18n.logging.CoreEnginePrimordialLoggerWrapper;
import weblogic.i18n.logging.MessageDispatcher;
import weblogic.i18n.logging.MessageLogger;
import weblogic.i18n.logging.MessageLoggerNotFoundException;
import weblogic.i18n.logging.MessageLoggerRegistryListener;

public final class MessageLoggerRegistry {
    private static final String DELIM = ".";
    private static final boolean DEBUG = false;
    public static final String DEFAULT_MESSAGE_LOGGER_PROP = "weblogic.i18n.logging.MessageLogger";
    private static final int SKIP_COUNT = 100;
    private static Tree tree = new Tree();
    private static List listeners = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMessageLoggerRegistryListener(MessageLoggerRegistryListener l) {
        List list = listeners;
        synchronized (list) {
            if (listeners.size() % 100 == 0) {
                MessageLoggerRegistry.expungeStaleEntries();
            }
            WeakReference<MessageLoggerRegistryListener> w = new WeakReference<MessageLoggerRegistryListener>(l);
            listeners.add(w);
        }
    }

    private static void expungeStaleEntries() {
        Iterator i = listeners.iterator();
        while (i.hasNext()) {
            WeakReference w = (WeakReference)i.next();
            if (w.get() != null) continue;
            i.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeMessageLoggerResgistryListener(MessageLoggerRegistryListener listener) {
        List list = listeners;
        synchronized (list) {
            Iterator i = listeners.iterator();
            while (i.hasNext()) {
                WeakReference wr = (WeakReference)i.next();
                MessageLoggerRegistryListener l = (MessageLoggerRegistryListener)wr.get();
                if (l != null && l != listener) continue;
                i.remove();
            }
        }
    }

    public static void registerMessageLogger(String nodeName, MessageLogger msgLogger) {
        Node n = MessageLoggerRegistry.buildTreeNodesRecursive(MessageLoggerRegistry.tree.getRootNode(), nodeName);
        n.setValue(msgLogger);
        MessageLoggerRegistry.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyListeners() {
        List list = listeners;
        synchronized (list) {
            Iterator i = listeners.iterator();
            while (i.hasNext()) {
                WeakReference wr = (WeakReference)i.next();
                MessageLoggerRegistryListener l = (MessageLoggerRegistryListener)wr.get();
                if (l != null) {
                    l.messageLoggerRegistryUpdated();
                    continue;
                }
                i.remove();
            }
        }
    }

    public static MessageLogger findMessageLogger(String name) {
        Node n = MessageLoggerRegistry.findTreeNodeRecursive(MessageLoggerRegistry.tree.getRootNode(), name);
        MessageLogger logger = null;
        while (logger == null && n != null) {
            logger = (MessageLogger)n.getValue();
            n = n.getParent();
        }
        if (logger == null) {
            throw new MessageLoggerNotFoundException(name);
        }
        return logger;
    }

    public static MessageLogger getRootLogger() {
        return (MessageLogger)tree.rootNode.getValue();
    }

    private static Node buildTreeNodesRecursive(Node parent, String childTree) {
        int index = childTree.indexOf(DELIM);
        if (index > 0) {
            String immediateChild = childTree.substring(0, index);
            Node child = new Node(parent, immediateChild);
            parent.getChildren().add(child);
            if (index < childTree.length() - 1) {
                String remainder = childTree.substring(index + 1);
                return MessageLoggerRegistry.buildTreeNodesRecursive(child, remainder);
            }
            return child;
        }
        if (parent.getName().equals(childTree)) {
            return parent;
        }
        Node child = new Node(parent, childTree);
        parent.getChildren().add(child);
        return child;
    }

    private static Node findTreeNodeRecursive(Node parent, String childTree) {
        if (parent.getChildren().isEmpty()) {
            return parent;
        }
        int index = childTree.indexOf(DELIM);
        if (index > 0) {
            String immediateChild = childTree.substring(0, index);
            Node child = MessageLoggerRegistry.findChildNode(parent, immediateChild);
            if (child == null) {
                return parent;
            }
            if (index < childTree.length() - 1) {
                String remainder = childTree.substring(index + 1);
                return MessageLoggerRegistry.findTreeNodeRecursive(child, remainder);
            }
            return child;
        }
        Node child = MessageLoggerRegistry.findChildNode(parent, childTree);
        if (child == null) {
            return parent;
        }
        return child;
    }

    private static Node findChildNode(Node parent, String name) {
        for (Node n : parent.getChildren()) {
            if (!n.getName().equals(name)) continue;
            return n;
        }
        return null;
    }

    public static void main(String[] args) {
    }

    private static class Node {
        private Node parent;
        private String name;
        private Object value;
        private Set childNodes = new HashSet();

        private Node(Node p, String n) {
            this.parent = p;
            this.name = n;
        }

        private Node getParent() {
            return this.parent;
        }

        private String getName() {
            return this.name;
        }

        private Set getChildren() {
            return this.childNodes;
        }

        private Object getValue() {
            return this.value;
        }

        private void setValue(Object v) {
            this.value = v;
        }

        public boolean equals(Object o) {
            if (o != null && o instanceof Node) {
                return ((Node)o).name.equals(this.name);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    private static class Tree {
        private Node rootNode = new Node(null, "");

        private Tree() {
            this.rootNode.setValue(this.initializeRootNodeLogger());
        }

        private Object initializeRootNodeLogger() {
            MessageDispatcher defaultMessageLogger = null;
            try {
                defaultMessageLogger = CoreEnginePrimordialLoggerWrapper.getInstance();
                if (defaultMessageLogger == null) {
                    String messageLoggerImpl = System.getProperty(MessageLoggerRegistry.DEFAULT_MESSAGE_LOGGER_PROP, "weblogic.logging.WLMessageLogger");
                    Class<?> cls = Class.forName(messageLoggerImpl);
                    defaultMessageLogger = cls.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
            catch (Exception e) {
                defaultMessageLogger = new BasicMessageLogger();
            }
            return defaultMessageLogger;
        }

        private Node getRootNode() {
            return this.rootNode;
        }
    }
}

