/*
 * Decompiled with CFR 0.152.
 */
package weblogic.i18n.logging;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MessageResetScheduler {
    private Map<String, MessageResetEntry> messageTimestamps = new ConcurrentHashMap<String, MessageResetEntry>();

    public static MessageResetScheduler getInstance() {
        return SINGLETON.instance;
    }

    private MessageResetScheduler() {
    }

    public boolean isMessageLoggingDisabled(String id) {
        long delay;
        long currentTimestamp = System.currentTimeMillis();
        MessageResetEntry entry = this.messageTimestamps.get(id);
        long previousTimestamp = entry == null ? 0L : entry.timestamp;
        long diff = currentTimestamp - previousTimestamp;
        long l = delay = entry == null ? 0L : entry.delay;
        return diff < delay;
    }

    public boolean resetLogMessage(String id) {
        return this.messageTimestamps.remove(id) != null;
    }

    public void scheduleMessageReset(String id, long delay) {
        this.messageTimestamps.put(id, new MessageResetEntry(delay, System.currentTimeMillis()));
    }

    private static final class MessageResetEntry {
        long delay;
        long timestamp;

        MessageResetEntry(long delay, long timestamp) {
            this.delay = delay;
            this.timestamp = timestamp;
        }
    }

    private static class SINGLETON {
        static MessageResetScheduler instance = new MessageResetScheduler();

        private SINGLETON() {
        }
    }
}

