/*
 * Decompiled with CFR 0.152.
 */
package weblogic.i18n.logging;

import weblogic.i18n.logging.MessageLogger;
import weblogic.i18n.logging.MessageLoggerRegistry;
import weblogic.i18n.logging.MessageLoggerRegistryListener;

public class NonCatalogLogger
implements MessageLoggerRegistryListener {
    private String name;
    private MessageLogger messageLogger;

    public NonCatalogLogger(String name) {
        this.name = name;
        this.initMessageLogger();
        MessageLoggerRegistry.addMessageLoggerRegistryListener(this);
    }

    public void error(String msg) {
        this.messageLogger.log(this.name, 8, msg);
    }

    public void error(String msg, Throwable th) {
        this.messageLogger.log(this.name, 8, msg, th);
    }

    public void warning(String msg) {
        this.messageLogger.log(this.name, 16, msg);
    }

    public void warning(String msg, Throwable t) {
        this.messageLogger.log(this.name, 16, msg, t);
    }

    public void info(String msg) {
        this.messageLogger.log(this.name, 64, msg);
    }

    public void info(String msg, Throwable t) {
        this.messageLogger.log(this.name, 64, msg, t);
    }

    public void debug(String msg) {
        this.messageLogger.log(this.name, 128, msg);
    }

    public void debug(String msg, Throwable t) {
        this.messageLogger.log(this.name, 128, msg, t);
    }

    public void alert(String msg) {
        this.messageLogger.log(this.name, 2, msg);
    }

    public void alert(String msg, Throwable t) {
        this.messageLogger.log(this.name, 2, msg, t);
    }

    public void critical(String msg) {
        this.messageLogger.log(this.name, 4, msg);
    }

    public void critical(String msg, Throwable t) {
        this.messageLogger.log(this.name, 4, msg, t);
    }

    public void emergency(String msg) {
        this.messageLogger.log(this.name, 1, msg);
    }

    public void emergency(String msg, Throwable t) {
        this.messageLogger.log(this.name, 1, msg, t);
    }

    public void notice(String msg) {
        this.messageLogger.log(this.name, 32, msg);
    }

    public void notice(String msg, Throwable t) {
        this.messageLogger.log(this.name, 32, msg, t);
    }

    public void trace(String msg) {
        this.messageLogger.log(this.name, 256, msg);
    }

    public void trace(String msg, Throwable t) {
        this.messageLogger.log(this.name, 256, msg, t);
    }

    @Override
    public void messageLoggerRegistryUpdated() {
        this.initMessageLogger();
    }

    private void initMessageLogger() {
        this.messageLogger = MessageLoggerRegistry.findMessageLogger(this.name);
    }
}

