/*
 * Decompiled with CFR 0.152.
 */
package weblogic.i18n.logging;

import java.util.Locale;
import weblogic.i18n.Localizer;
import weblogic.i18n.logging.Severities;
import weblogic.i18ntools.L10nLookup;

public class SeverityI18N
extends Severities {
    private static Localizer localizer1;
    private static Localizer localizer2;
    private static String lang1;
    private static String lang2;

    public static String severityNumToString(int num, Locale loca) {
        String lang = loca.getLanguage();
        if ("en".equals(lang)) {
            switch (num) {
                case 0: {
                    return "Off";
                }
                case 1: {
                    return "Emergency";
                }
                case 2: {
                    return "Alert";
                }
                case 4: {
                    return "Critical";
                }
                case 32: {
                    return "Notice";
                }
                case 8: {
                    return "Error";
                }
                case 16: {
                    return "Warning";
                }
                case 64: {
                    return "Info";
                }
                case 128: {
                    return "Debug";
                }
                case 256: {
                    return "Trace";
                }
                case 512: {
                    return "Dynamic";
                }
            }
            return "Unknown";
        }
        Localizer localizer = SeverityI18N.quicklyGetLocalizer(loca, lang);
        return localizer.get(Severities.severityNumToString(num));
    }

    public static int severityStringToNum(String sevstr, Locale loca) {
        String lang = loca.getLanguage();
        if ("en".equals(lang)) {
            if (sevstr.equalsIgnoreCase("Off")) {
                return 0;
            }
            if (sevstr.equalsIgnoreCase("Emergency")) {
                return 1;
            }
            if (sevstr.equalsIgnoreCase("Alert")) {
                return 2;
            }
            if (sevstr.equalsIgnoreCase("Critical")) {
                return 4;
            }
            if (sevstr.equalsIgnoreCase("Notice")) {
                return 32;
            }
            if (sevstr.equalsIgnoreCase("Error")) {
                return 8;
            }
            if (sevstr.equalsIgnoreCase("Warning")) {
                return 16;
            }
            if (sevstr.equalsIgnoreCase("Info")) {
                return 64;
            }
            if (sevstr.equalsIgnoreCase("Debug")) {
                return 128;
            }
            if (sevstr.equalsIgnoreCase("Trace")) {
                return 256;
            }
            if (sevstr.equalsIgnoreCase("Dynamic")) {
                return 512;
            }
            return 0;
        }
        Localizer localizer = SeverityI18N.quicklyGetLocalizer(loca, lang);
        if (sevstr.equalsIgnoreCase(localizer.get("Off"))) {
            return 0;
        }
        if (sevstr.equalsIgnoreCase(localizer.get("Emergency"))) {
            return 1;
        }
        if (sevstr.equalsIgnoreCase(localizer.get("Alert"))) {
            return 2;
        }
        if (sevstr.equalsIgnoreCase(localizer.get("Critical"))) {
            return 4;
        }
        if (sevstr.equalsIgnoreCase(localizer.get("Notice"))) {
            return 32;
        }
        if (sevstr.equalsIgnoreCase(localizer.get("Error"))) {
            return 8;
        }
        if (sevstr.equalsIgnoreCase(localizer.get("Warning"))) {
            return 16;
        }
        if (sevstr.equalsIgnoreCase(localizer.get("Info"))) {
            return 64;
        }
        if (sevstr.equalsIgnoreCase(localizer.get("Debug"))) {
            return 128;
        }
        if (sevstr.equalsIgnoreCase(localizer.get("Trace"))) {
            return 256;
        }
        if (sevstr.equalsIgnoreCase(localizer.get("Dynamic"))) {
            return 512;
        }
        return 0;
    }

    private static Localizer quicklyGetLocalizer(Locale loca, String lang) {
        if (lang1 != null && lang1.equals(lang)) {
            return localizer1;
        }
        if (lang2 != null && lang2.equals(lang)) {
            return localizer2;
        }
        Localizer localizer = L10nLookup.getLocalizer(loca, "weblogic.i18n.logging.LoggingTextLocalizer");
        if (lang1 == null) {
            lang1 = lang;
            localizer1 = localizer;
        } else if (lang2 == null) {
            lang2 = lang;
            localizer2 = localizer;
        } else {
            lang1 = lang;
            localizer1 = localizer;
        }
        return localizer;
    }
}

