/*
 * Decompiled with CFR 0.152.
 */
package weblogic.i18ntools;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import weblogic.i18n.Localizer;

public final class L10nLookup
extends Properties {
    private static final long serialVersionUID = 508651606563984141L;
    private static boolean verbose = false;
    public static final String I18N_PROPERTIES = "i18n.properties";
    public static final String I18N_PROPERTIES_RESOURCE = "weblogic/i18n/i18n.properties";
    public static final String I18N_USER_PROPERTIES = "i18n_user.properties";
    public static final String I18N_USER_PROPERTIES_RESOURCE = "i18n_user.properties";
    public static final String I18N_EXT_PROPERTIES = "i18n_ext.properties";
    public static final String I18N_EXT_PROPERTIES_RESOURCE = "i18n_ext.properties";
    public static final int I18N_SERVER_MAX_MSG_ID = 500000;
    public static final int I18N_MAX_MSG_ID = 999999;
    public static final int I18N_MAX_ID_LENGTH = 6;
    public static final int EXTENDED_I18N_SERVER_MIN_MSG_ID = 1000000;
    public static final int EXTENDED_I18N_SERVER_MAX_MSG_ID = 9999999;
    private static final String EMPTY_STRING = "";
    private boolean resourcesLoaded = false;
    private Vector subSystems;

    public static L10nLookup getL10n() {
        return L10nLookupInitializer.SINGLETON;
    }

    public void load(String resource) throws IOException {
        this.loadProps(resource, false);
    }

    @Override
    public void load(InputStream is) throws IOException {
        super.load(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProps(String resource, boolean initializing) throws IOException {
        Enumeration<URL> list;
        InputStream fis = null;
        HashSet<String> resSet = new HashSet<String>();
        if (verbose) {
            new Exception().printStackTrace();
            L10nLookup.logger("Loading props from " + resource);
        }
        if ((list = Thread.currentThread().getContextClassLoader().getResources(resource)) != null) {
            while (list.hasMoreElements()) {
                URL url = list.nextElement();
                if (verbose) {
                    L10nLookup.logger("Adding " + url);
                }
                resSet.add(url.toString());
            }
        }
        if (initializing) {
            ClassLoader cl = L10nLookup.class.getClassLoader();
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            if ((list = cl.getResources(resource)) != null) {
                while (list.hasMoreElements()) {
                    URL url = list.nextElement();
                    if (verbose) {
                        L10nLookup.logger("Adding " + url);
                    }
                    resSet.add(url.toString());
                }
            }
        }
        for (String res : resSet) {
            if (verbose) {
                L10nLookup.logger("Loading from " + res);
            }
            try {
                fis = new URL(res).openStream();
                super.load(fis);
                this.closeIS(fis);
            }
            catch (IOException ioe) {
                try {
                    if (verbose) {
                        L10nLookup.logger("Skipping " + res);
                    }
                    if (initializing) {
                        throw ioe;
                    }
                    this.closeIS(fis);
                }
                catch (Throwable throwable) {
                    this.closeIS(fis);
                    throw throwable;
                }
            }
        }
    }

    @Override
    public Object put(Object key, Object value) {
        return super.put(key, ((String)value).intern());
    }

    private void closeIS(InputStream is) {
        block3: {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ioe) {
                if (!verbose) break block3;
                L10nLookup.logger("Error closing stream." + ioe.getMessage());
                ioe.printStackTrace();
            }
        }
    }

    private static void logger(String msg) {
        System.out.println(msg);
    }

    private L10nLookup(boolean loadResources) {
        if (loadResources) {
            this.ensureResourcesLoaded();
        }
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public synchronized void ensureResourcesLoaded() {
        block5: {
            if (this.resourcesLoaded) {
                return;
            }
            try {
                this.loadProps(I18N_PROPERTIES_RESOURCE, true);
            }
            catch (IOException ioe) {
                L10nLookup.logger("Unable to access I18n properties file, weblogic/i18n/i18n.properties: " + ioe.toString());
            }
            try {
                this.loadProps("i18n_user.properties", true);
            }
            catch (IOException ioe) {
                if (!verbose) break block5;
                L10nLookup.logger("Unable to access I18n user properties file, i18n_user.properties: " + ioe.toString());
            }
        }
        this.resourcesLoaded = true;
    }

    public Localizer getLocalizer(String id, Locale locale) throws MissingResourceException {
        return this.getLocalizer(id, locale, false);
    }

    public Localizer getLocalizer(String msgId, Locale locale, boolean detailed) throws MissingResourceException {
        String localizer;
        this.ensureResourcesLoaded();
        String id = msgId;
        String prefix = null;
        if (id.indexOf("-") != -1) {
            id = id.substring(msgId.indexOf("-") + 1);
            prefix = msgId.substring(0, msgId.indexOf("-"));
        }
        if ((localizer = this.getProperty(id)) == null) {
            try {
                if (Integer.parseInt(id) < 500000) {
                    this.loadProps(I18N_PROPERTIES_RESOURCE, false);
                } else {
                    this.loadProps("i18n_user.properties", false);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            localizer = this.getProperty(id);
            if (localizer == null) {
                throw new MissingResourceException("No localizer class found for message id.", "unknown", id);
            }
        }
        if (verbose) {
            L10nLookup.logger("Localizer is " + localizer);
        }
        for (int i = 0; i < localizer.length(); ++i) {
            Localizer loc;
            if (localizer.charAt(i) != ':') continue;
            String l = localizer.substring(++i);
            if (detailed) {
                l = l.concat("Detail");
            }
            if (verbose) {
                L10nLookup.logger("Getting bundle for " + l);
            }
            if ((loc = this.getLocalizerBundle(l, locale, Thread.currentThread().getContextClassLoader())) == null) {
                throw new MissingResourceException("No localizer class found for message id.", "unknown", id);
            }
            if (prefix != null && !prefix.equals(loc.getPrefix())) {
                throw new MissingResourceException("Prefix (" + prefix + ") in message id, " + msgId + ", does not match prefix in Localizer, " + loc.getPrefix(), loc.getClass().getName(), id);
            }
            return loc;
        }
        throw new MissingResourceException("Invalid I18n resource for " + id + ". Resource is " + localizer, "weblogic.i18n.Localizer", id);
    }

    public Localizer getLocalizer(int id, Locale locale) throws MissingResourceException {
        DecimalFormat df = new DecimalFormat("000000");
        return this.getLocalizer(df.format(id), locale, false);
    }

    public Localizer getLocalizer(String id) throws MissingResourceException {
        return this.getLocalizer(id, Locale.getDefault(), false);
    }

    public Localizer getLocalizer(int id) throws MissingResourceException {
        DecimalFormat df = new DecimalFormat("000000");
        return this.getLocalizer(df.format(id), Locale.getDefault(), false);
    }

    public static Localizer getLocalizer(Locale locale, String className) throws MissingResourceException {
        return L10nLookup.getLocalizer(locale, className, null);
    }

    public static Localizer getLocalizer(Locale locale, String className, ClassLoader classLoader) throws MissingResourceException {
        Localizer loc;
        if (className == null) {
            throw new NullPointerException("No class name provided");
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (classLoader != null && (loc = L10nLookupInitializer.SINGLETON.getLocalizerBundle(className, locale, classLoader)) != null) {
            return loc;
        }
        ClassLoader loader = L10nLookup.class.getClassLoader();
        Localizer loc2 = L10nLookupInitializer.SINGLETON.getLocalizerBundle(className, locale, loader);
        if (loc2 == null) {
            loader = Thread.currentThread().getContextClassLoader();
            if (loader != null) {
                loc2 = L10nLookupInitializer.SINGLETON.getLocalizerBundle(className, locale, loader);
            }
            if (loc2 == null) {
                throw new MissingResourceException("Can't locate bundle for class '" + className + "'", className, EMPTY_STRING);
            }
        }
        return loc2;
    }

    private Localizer getLocalizerBundle(String className, Locale locale, ClassLoader loader) {
        ResourceBundle bundle;
        Locale bundleLocale;
        Localizer loc = this.getLocalizerBundle_inner(className, locale, loader);
        if (loc != null && !L10nLookup.isParentLocale(bundleLocale = (bundle = loc.getBundle()).getLocale(), locale)) {
            locale = new Locale(EMPTY_STRING, EMPTY_STRING, EMPTY_STRING);
            loc = this.getLocalizerBundle_inner(className, locale, loader);
        }
        return loc;
    }

    private static boolean isParentLocale(Locale parent, Locale child) {
        String parentLang = parent.getLanguage();
        String childLang = child.getLanguage();
        if (EMPTY_STRING.equals(parentLang)) {
            return true;
        }
        if (!parentLang.equals(childLang)) {
            return false;
        }
        String parentCountry = parent.getCountry();
        String childCountry = child.getCountry();
        if (EMPTY_STRING.equals(parentCountry)) {
            return true;
        }
        if (!parentCountry.equals(childCountry)) {
            return false;
        }
        String parentVariant = parent.getVariant();
        String childVariant = child.getVariant();
        if (EMPTY_STRING.equals(parentVariant)) {
            return true;
        }
        return parentVariant.equals(childVariant);
    }

    private Localizer getLocalizerBundle_inner(String className, Locale locale, ClassLoader loader) {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(className, locale, loader);
            return new Localizer(bundle);
        }
        catch (MissingResourceException mre) {
            return null;
        }
    }

    public Vector getSubSystems() {
        this.ensureResourcesLoaded();
        if (this.subSystems == null) {
            this.subSystems = new Vector();
            Enumeration<Object> e = this.elements();
            while (e.hasMoreElements()) {
                int i;
                String val = (String)e.nextElement();
                String sub = val.substring(0, i = val.indexOf(58));
                if (this.subSystems.contains(sub)) continue;
                this.subSystems.add(sub);
            }
        }
        return this.subSystems;
    }

    private static class L10nLookupInitializer {
        private static final L10nLookup SINGLETON = new L10nLookup(false);

        private L10nLookupInitializer() {
        }
    }

    static class LocalizerKey {
        String s;
        Locale l;
        ClassLoader cl;
        int hash;

        LocalizerKey(String className, Locale locale, ClassLoader loader) {
            this.s = className;
            this.l = locale;
            this.cl = loader;
            this.hash = 0;
        }

        public int hashCode() {
            if (this.hash == 0) {
                if (this.s != null) {
                    this.hash = this.s.hashCode();
                }
                if (this.l != null) {
                    this.hash |= this.l.hashCode();
                }
                if (this.cl != null) {
                    this.hash |= this.cl.hashCode();
                }
            }
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof LocalizerKey) {
                LocalizerKey lk = (LocalizerKey)obj;
                if (this.s.equals(lk.s) && this.l.equals(lk.l) && (this.cl == null ? lk.cl == null : this.cl.equals(lk.cl))) {
                    return true;
                }
            }
            return false;
        }
    }
}

