/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop.ior;

enum CipherSuites {
    NONE{

        @Override
        short getTlsSupports() {
            return 2;
        }

        @Override
        CipherSuites transitionOnPlain() {
            return PLAIN_ONLY;
        }

        @Override
        CipherSuites transitionOnSecure() {
            return SECURE_ONLY;
        }
    }
    ,
    PLAIN_ONLY{

        @Override
        short getTlsSupports() {
            return 2;
        }

        @Override
        CipherSuites transitionOnSecure() {
            return BOTH;
        }
    }
    ,
    SECURE_ONLY{

        @Override
        short getTlsRequires() {
            return 6;
        }

        @Override
        CipherSuites transitionOnPlain() {
            return BOTH;
        }
    }
    ,
    BOTH;


    static CipherSuites getFromSuiteNames(String ... suiteNames) {
        if (suiteNames == null || suiteNames.length == 0) {
            return SECURE_ONLY;
        }
        CipherSuites result = NONE;
        for (String suiteName : suiteNames) {
            if (suiteName == null) continue;
            result = CipherSuites.isSecure(suiteName) ? result.transitionOnSecure() : result.transitionOnPlain();
        }
        return result;
    }

    private static boolean isSecure(String suiteName) {
        return !suiteName.contains("WITH_NULL");
    }

    short getTlsSupports() {
        return 38;
    }

    short getTlsRequires() {
        return 2;
    }

    CipherSuites transitionOnSecure() {
        return this;
    }

    CipherSuites transitionOnPlain() {
        return this;
    }
}

