/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop.ior;

import java.io.UnsupportedEncodingException;
import weblogic.iiop.ior.TaggedComponent;
import weblogic.iiop.protocol.CodeSet;
import weblogic.iiop.protocol.CorbaInputStream;
import weblogic.iiop.protocol.CorbaOutputStream;

public class CodeSetsComponent
extends TaggedComponent {
    private static final int[] DEFAULT_CHAR_CONVERSION_CODE_SETS = new int[]{65568, 65537, 0x5010001};
    private static final int[] DEFAULT_WCHAR_CONVERSION_CODE_SETS = new int[]{65792, 65801, 0x5010001};
    private static CodeSetsComponent DEFAULT;
    private int charNativeCodeSet;
    private int[] charConversionCodeSets;
    private int wcharNativeCodeSet;
    private int[] wcharConversionCodeSets;

    public int negotiatedCharCodeSet() throws UnsupportedEncodingException {
        if (CodeSet.supportedCharCodeSet(this.charNativeCodeSet)) {
            return this.charNativeCodeSet;
        }
        for (int charConversionCodeSet : this.charConversionCodeSets) {
            if (!CodeSet.supportedCharCodeSet(charConversionCodeSet)) continue;
            return charConversionCodeSet;
        }
        throw new UnsupportedEncodingException();
    }

    public int negotiatedWcharCodeSet() throws UnsupportedEncodingException {
        if (this.supportedWcharCodeSet(0x5010001)) {
            return 0x5010001;
        }
        if (CodeSet.supportedWcharCodeSet(this.wcharNativeCodeSet)) {
            return this.wcharNativeCodeSet;
        }
        for (int wcharConversionCodeSet : this.wcharConversionCodeSets) {
            if (!CodeSet.supportedWcharCodeSet(wcharConversionCodeSet)) continue;
            return wcharConversionCodeSet;
        }
        throw new UnsupportedEncodingException();
    }

    private CodeSetsComponent() {
        super(1);
        this.charNativeCodeSet = CodeSet.DEFAULT_CHAR_NATIVE_CODE_SET;
        this.charConversionCodeSets = DEFAULT_CHAR_CONVERSION_CODE_SETS;
        this.wcharNativeCodeSet = CodeSet.DEFAULT_WCHAR_NATIVE_CODE_SET;
        this.wcharConversionCodeSets = DEFAULT_WCHAR_CONVERSION_CODE_SETS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CodeSetsComponent getDefault() {
        if (DEFAULT != null) return DEFAULT;
        Class<CodeSetsComponent> clazz = CodeSetsComponent.class;
        synchronized (CodeSetsComponent.class) {
            DEFAULT = new CodeSetsComponent();
            // ** MonitorExit[var0] (shouldn't be in output)
            return DEFAULT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetDefault() {
        Class<CodeSetsComponent> clazz = CodeSetsComponent.class;
        synchronized (CodeSetsComponent.class) {
            DEFAULT = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    CodeSetsComponent(CorbaInputStream in) {
        super(1);
        this.read(in);
    }

    public final boolean supportedCharCodeSet(int cs) {
        if (this.charNativeCodeSet == cs) {
            return true;
        }
        for (int codeSet : this.charConversionCodeSets) {
            if (codeSet != cs) continue;
            return true;
        }
        return false;
    }

    public final boolean supportedWcharCodeSet(int cs) {
        if (this.wcharNativeCodeSet == cs) {
            return true;
        }
        for (int codeSet : this.wcharConversionCodeSets) {
            if (codeSet != cs) continue;
            return true;
        }
        return false;
    }

    @Override
    public final void read(CorbaInputStream in) {
        long handle = in.startEncapsulation();
        this.charNativeCodeSet = in.read_long();
        this.charConversionCodeSets = this.readCodeSetArray(in);
        this.wcharNativeCodeSet = in.read_long();
        this.wcharConversionCodeSets = this.readCodeSetArray(in);
        in.endEncapsulation(handle);
    }

    private int[] readCodeSetArray(CorbaInputStream in) {
        int numCodeSets = in.read_long();
        int[] codeSets = new int[numCodeSets];
        for (int i = 0; i < numCodeSets; ++i) {
            codeSets[i] = in.read_long();
        }
        return codeSets;
    }

    @Override
    public final void write(CorbaOutputStream out) {
        out.write_long(this.tag);
        long handle = out.startEncapsulation();
        out.write_long(this.charNativeCodeSet);
        this.writeCodeSets(out, this.charConversionCodeSets);
        out.write_long(this.wcharNativeCodeSet);
        this.writeCodeSets(out, this.wcharConversionCodeSets);
        out.endEncapsulation(handle);
    }

    public void writeCodeSets(CorbaOutputStream out, int[] codeSets) {
        out.write_long(codeSets.length);
        for (int codeSet : codeSets) {
            out.write_long(codeSet);
        }
    }
}

