/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jndi;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Binding;
import javax.naming.CompoundName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.spi.NamingManager;
import weblogic.jndi.NonListable;
import weblogic.jndi.OpaqueReference;

public class SimpleContext
implements Context {
    private boolean nonListable = false;
    private static Properties syntax = new Properties();
    protected static final NameParser parser;
    protected Map map = new ConcurrentHashMap();

    protected Context resolve(Name name, boolean createSubcontexts) throws NamingException {
        Object o = this.map.get(name.get(0));
        if (o instanceof Context) {
            return (Context)o;
        }
        if (createSubcontexts && o == null) {
            return this.createSubcontext(name.get(0));
        }
        throw new NameNotFoundException("remaining name: " + name);
    }

    protected Context resolve(Name name) throws NamingException {
        return this.resolve(name, false);
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        try {
            return this.doLookup(name);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Throwable e) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(e);
            throw namingException;
        }
    }

    private Object doLookup(Name name) throws NamingException {
        switch (name.size()) {
            case 0: {
                return this;
            }
            case 1: {
                String key = name.get(0);
                if (!this.map.containsKey(key)) {
                    throw new NameNotFoundException("remaining name: " + name);
                }
                Object result = this.map.get(key);
                if (result instanceof SimpleReference) {
                    result = ((SimpleReference)result).get();
                } else if (result instanceof LinkRef) {
                    result = new InitialContext(this.getEnvironment()).lookup(((LinkRef)result).getLinkName());
                } else if (result instanceof Reference) {
                    try {
                        result = NamingManager.getObjectInstance(result, name, this, this.getEnvironment());
                    }
                    catch (Exception exception) {}
                } else if (result instanceof OpaqueReference) {
                    result = ((OpaqueReference)result).getReferent(name, this);
                }
                return result;
            }
        }
        return this.resolve(name).lookup(name.getSuffix(1));
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.lookup(parser.parse(name));
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        switch (name.size()) {
            case 0: {
                throw new NamingException("bind name my not be empty");
            }
            case 1: {
                this.map.put(name.get(0), obj);
                return;
            }
        }
        this.resolve(name, true).bind(name.getSuffix(1), obj);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.bind(parser.parse(name), obj);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        switch (name.size()) {
            case 0: {
                throw new NamingException("rebind name may not be empty");
            }
            case 1: {
                this.map.put(name.get(0), obj);
                return;
            }
        }
        this.resolve(name).rebind(name.getSuffix(1), obj);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(parser.parse(name), obj);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        switch (name.size()) {
            case 0: {
                throw new NamingException("unbind name may not be empty");
            }
            case 1: {
                this.map.remove(name.get(0));
                return;
            }
        }
        this.resolve(name).unbind(name.getSuffix(1));
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.unbind(parser.parse(name));
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        this.bind(newName, this.lookup(oldName));
        this.unbind(oldName);
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        this.bind(newName, this.lookup(oldName));
        this.unbind(oldName);
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return name.isEmpty() ? new NamingEnumerationBase(this.getFilterNonListableMap().entrySet().iterator()){

            @Override
            public Object nextElement() {
                Map.Entry e = (Map.Entry)this.i.next();
                Object v = e.getValue();
                return new NameClassPair(e.getKey().toString(), v == null ? null : v.getClass().getName());
            }
        } : this.resolve(name).list(name.getSuffix(1));
    }

    private Map getFilterNonListableMap() {
        HashMap filteredMap = new HashMap();
        for (Object key : this.map.keySet()) {
            Object value = this.map.get(key);
            if (value instanceof SimpleContext && ((SimpleContext)value).nonListable || value instanceof NonListable) continue;
            filteredMap.put(key, value);
        }
        return filteredMap;
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list(parser.parse(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return name.isEmpty() ? new NamingEnumerationBase(this.getFilterNonListableMap().entrySet().iterator()){

            @Override
            public Object nextElement() {
                Map.Entry e = (Map.Entry)this.i.next();
                return new Binding(e.getKey().toString(), e.getValue());
            }
        } : this.resolve(name).listBindings(name.getSuffix(1));
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.listBindings(parser.parse(name));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        switch (name.size()) {
            case 0: {
                throw new NamingException("destroySubcontext name may not be empty");
            }
            case 1: {
                this.map.remove(name.get(0));
                return;
            }
        }
        this.resolve(name).destroySubcontext(name.getSuffix(1));
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(parser.parse(name));
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        switch (name.size()) {
            case 0: {
                throw new NamingException("createSubcontext name may not be empty");
            }
            case 1: {
                Context c = this.createNewSubcontext(this, name);
                this.map.put(name.get(0), c);
                return c;
            }
        }
        return this.resolve(name).createSubcontext(name.getSuffix(1));
    }

    public Context createNonListableSubcontext(Name name) throws NamingException {
        switch (name.size()) {
            case 0: {
                throw new NamingException("createNonListableSubcontext name may not be empty");
            }
            case 1: {
                SimpleContext c = new SimpleContext();
                c.nonListable = true;
                this.map.put(name.get(0), c);
                return c;
            }
        }
        return ((SimpleContext)this.resolve(name)).createNonListableSubcontext(name.getSuffix(1));
    }

    public Context createNonListableSubcontext(String name) throws NamingException {
        return this.createNonListableSubcontext(parser.parse(name));
    }

    protected Context createNewSubcontext(Context parent, Name name) throws NamingException {
        return new SimpleContext();
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(parser.parse(name));
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return name.isEmpty() ? parser : this.resolve(name).getNameParser(name.getSuffix(1));
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return this.getNameParser(parser.parse(name));
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Hashtable getEnvironment() throws NamingException {
        return null;
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException();
    }

    static {
        syntax.put("jndi.syntax.direction", "left_to_right");
        syntax.put("jndi.syntax.separator", "/");
        parser = new NameParser(){

            @Override
            public Name parse(String name) throws NamingException {
                return new CompoundName(name, syntax);
            }
        };
    }

    static abstract class NamingEnumerationBase
    implements NamingEnumeration {
        protected Iterator i;

        protected NamingEnumerationBase(Iterator i) {
            this.i = i;
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        @Override
        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        @Override
        public boolean hasMoreElements() {
            return this.i.hasNext();
        }

        @Override
        public void close() {
        }
    }

    public static interface SimpleReference<T> {
        public T get() throws NamingException;
    }
}

