/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.utils;

import java.io.File;

public class ApplicationNameUtils {
    public static String computeApplicationName(File descriptorFile) {
        String archiveName = ApplicationNameUtils.getArchiveNameWithoutSuffix(descriptorFile);
        if (archiveName != null) {
            return archiveName;
        }
        return descriptorFile.getName();
    }

    public static String getArchiveNameWithoutSuffix(File file) {
        if (file == null) {
            return null;
        }
        String baseName = file.getName();
        String[] parts = baseName.split("\\.");
        if (parts.length >= 2 && parts[parts.length - 1].length() == 3 && (baseName.endsWith("ar") || "zip".equalsIgnoreCase(parts[parts.length - 1]))) {
            return baseName.substring(0, baseName.length() - 4);
        }
        return null;
    }
}

