/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.auth.login;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.EmptyStackException;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import weblogic.corba.client.ClientORBInitializer;
import weblogic.corba.client.spi.ServiceManager;
import weblogic.security.auth.callback.URLCallback;
import weblogic.security.auth.login.PasswordCredential;
import weblogic.security.subject.SubjectProxy;

public class UsernamePasswordLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler = null;
    private Map sharedState = null;
    private Map options = null;
    private boolean debug = false;
    private boolean authOnLogin = false;
    private String url = null;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private String username = null;
    private String password = null;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        this.subject = subject;
        if (options != null) {
            Object val = options.get("debug");
            if (val != null && ((String)val).equalsIgnoreCase("true")) {
                this.debug = true;
                this.log("UsernamePasswordLoginModule.initialize(), debug enabled");
            }
            if ((val = options.get("URL")) != null) {
                this.url = (String)val;
                if (this.debug) {
                    this.log("UsernamePasswordLoginModule.initialize(), URL " + this.url);
                }
            }
            if ((val = options.get("authOnLogin")) != null && ((String)val).equalsIgnoreCase("true")) {
                this.authOnLogin = true;
                if (this.debug) {
                    this.log("UsernamePasswordLoginModule.initialize(), authOnLogin enabled");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean login() throws LoginException {
        block31: {
            if (this.callbackHandler == null) {
                if (this.debug) {
                    this.log("UsernamePasswordLoginModule.login(), no callback handler specifed");
                }
                throw new LoginException("No callback handler specified");
            }
            Callback[] callbacks = new Callback[]{new NameCallback("username: "), new PasswordCallback("password: ", false), new URLCallback("URL: ")};
            try {
                this.callbackHandler.handle(callbacks);
                this.username = ((NameCallback)callbacks[0]).getName();
                if (this.debug) {
                    if (this.username == null) {
                        this.log("UsernamePasswordLoginModule.login(), No username");
                    } else {
                        this.log("UsernamePasswordLoginModule.login(), username " + this.username);
                    }
                }
                if (this.username == null) {
                    throw new LoginException("No username specified");
                }
                char[] charPassword = ((PasswordCallback)callbacks[1]).getPassword();
                if (charPassword == null) {
                    charPassword = new char[]{};
                }
                this.password = new String(charPassword);
                String callbackURL = ((URLCallback)callbacks[2]).getURL();
                if (callbackURL != null) {
                    this.url = callbackURL;
                }
                if (this.debug) {
                    if (this.url == null) {
                        this.log("UsernamePasswordLoginModule.login(), No URL");
                    } else {
                        this.log("UsernamePasswordLoginModule.login(), URL " + this.url);
                    }
                }
                if (this.url == null) {
                    this.url = "";
                }
            }
            catch (IOException ioe) {
                if (this.debug) {
                    this.log("UsernamePasswordLoginModule CallbackHandler Error: " + ioe.getMessage());
                }
                throw new LoginException(ioe.toString());
            }
            catch (UnsupportedCallbackException uce) {
                if (this.debug) {
                    this.log("UsernamePasswordLoginModule CallbackHandler Error: " + uce.getMessage());
                }
                throw new LoginException("Callback not available: " + uce.getCallback().toString());
            }
            if (this.url != null) {
                try {
                    if (this.authOnLogin) {
                        try {
                            Hashtable<String, String> env = new Hashtable<String, String>();
                            env.put("java.naming.provider.url", this.url);
                            env.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
                            env.put("java.naming.security.principal", this.username);
                            env.put("java.naming.security.credentials", this.password);
                            new InitialContext(env).lookup("weblogic/security/SecurityManager");
                            break block31;
                        }
                        finally {
                            try {
                                ServiceManager.getSecurityManager().popSubject();
                            }
                            catch (EmptyStackException env) {}
                        }
                    }
                    ClientORBInitializer.initialize();
                }
                catch (SecurityException se) {
                    if (this.debug) {
                        this.log("UsernamePasswordLoginModule Error: SecurityException on authenticate, " + se.getMessage());
                    }
                    throw new LoginException(se.toString());
                }
                catch (NamingException ne) {
                    if (this.debug) {
                        this.log("UsernamePasswordLoginModule Error: NamingException on authenticate, " + ne.getMessage());
                    }
                    throw new LoginException(ne.toString());
                }
            }
        }
        this.succeeded = true;
        return this.succeeded;
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.succeeded) {
            final PasswordCredential passwordCred = new PasswordCredential(this.username, this.password);
            final SubjectProxy as = new SubjectProxy(this.subject);
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    UsernamePasswordLoginModule.this.subject.getPrivateCredentials().add(passwordCred);
                    UsernamePasswordLoginModule.this.subject.getPrivateCredentials().add(as);
                    return null;
                }
            });
            this.url = null;
            this.commitSucceeded = true;
            return true;
        }
        this.username = null;
        this.password = null;
        this.url = null;
        return false;
    }

    @Override
    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.username = null;
            this.password = null;
            this.url = null;
        } else {
            this.logout();
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        block2: {
            this.succeeded = false;
            this.commitSucceeded = false;
            this.username = null;
            this.password = null;
            this.url = null;
            try {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        UsernamePasswordLoginModule.this.subject.getPrincipals().clear();
                        UsernamePasswordLoginModule.this.subject.getPrivateCredentials().clear();
                        UsernamePasswordLoginModule.this.subject.getPublicCredentials().clear();
                        return null;
                    }
                });
            }
            catch (SecurityException se) {
                if (!this.debug) break block2;
                se.printStackTrace();
            }
        }
        return true;
    }

    private void log(String msg) {
        System.out.println(msg);
    }
}

