/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.subject;

import java.util.EmptyStackException;
import org.jvnet.hk2.annotations.Service;
import weblogic.core.base.api.FastThreadLocalMarker;
import weblogic.kernel.AuditableThread;
import weblogic.kernel.ThreadLocalStack;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectManager;
import weblogic.security.subject.SubjectStack;
import weblogic.security.subject.SubjectStackDelegate;
import weblogic.utils.annotation.Secure;

@Service
@Secure
public class DelegatingSubjectStack
implements SubjectStack,
FastThreadLocalMarker {
    private static final ThreadLocalStack threadSubject = new ThreadLocalStack(true);
    private SubjectStackDelegate delegate;

    @Override
    public AbstractSubject getCurrentSubject(AbstractSubject kernelIdentity) {
        SubjectManager.getSubjectManager().checkKernelIdentity(kernelIdentity);
        AbstractSubject obj = (AbstractSubject)threadSubject.get();
        if (this.delegate != null) {
            obj = this.delegate.getCurrentSubject(kernelIdentity, obj);
        }
        return obj;
    }

    @Override
    public AbstractSubject getCurrentSubject(AbstractSubject kernelIdentity, AuditableThread auditableThread) {
        SubjectManager.getSubjectManager().checkKernelIdentity(kernelIdentity);
        AbstractSubject obj = (AbstractSubject)threadSubject.get(auditableThread);
        if (this.delegate != null) {
            obj = this.delegate.getCurrentSubject(kernelIdentity, obj);
        }
        return obj;
    }

    @Override
    public void pushSubject(AbstractSubject kernelIdentity, AbstractSubject userIdentity) {
        if (userIdentity == null) {
            throw new IllegalArgumentException("Illegal null Subject passed as a parameter.");
        }
        SubjectManager.getSubjectManager().checkKernelIdentity(kernelIdentity);
        if (this.delegate != null) {
            this.delegate.pushSubject(kernelIdentity, userIdentity);
        }
        threadSubject.push(userIdentity);
    }

    @Override
    public void popSubject(AbstractSubject kernelIdentity) {
        SubjectManager.getSubjectManager().checkKernelIdentity(kernelIdentity);
        Object o = null;
        try {
            o = threadSubject.popAndPeek();
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
        if (this.delegate != null) {
            this.delegate.popSubject(kernelIdentity, (AbstractSubject)o);
        }
    }

    @Override
    public int getSize() {
        return threadSubject.getSize();
    }

    public void addDelegate(SubjectStackDelegate delegate) {
        if (this.delegate != null) {
            this.delegate.addDelegate(delegate);
        } else {
            this.delegate = delegate;
        }
    }

    @Override
    public String getFastThreadLocalClassName() {
        return this.getClass().getCanonicalName();
    }
}

