/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.subject;

import java.security.AccessController;
import java.security.Permission;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Set;
import javax.security.auth.Subject;
import weblogic.kernel.AuditableThread;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectProxy;
import weblogic.security.subject.SubjectStack;

public abstract class SubjectManager
implements SubjectStack {
    public static final String KERNEL_USERNAME = "<WLS Kernel>";
    public static final String ANONYMOUS_USERNAME = SubjectManager.initAnonymousUsername();
    private static final String DEFAULT_ANONYMOUS_USERNAME = "<anonymous>";
    private static final GetKernelIdentityAction THE_ONE = new GetKernelIdentityAction();
    protected static final Permission KERNEL_PERM = new RuntimePermission("weblogic.kernelPermission");
    private static SubjectManager singleton;

    public static final PrivilegedAction getKernelIdentityAction() {
        return THE_ONE;
    }

    public static final Permission getKernelPermission() {
        return KERNEL_PERM;
    }

    public void checkKernelPermission() {
        AccessController.checkPermission(KERNEL_PERM);
    }

    public boolean isKernelIdentity(AbstractSubject s) {
        return s == this.getCachedKernelIdentity();
    }

    private AbstractSubject getCachedKernelIdentity() {
        return KernelIdentityMaker.KERNEL_ID;
    }

    public void checkKernelIdentity(AbstractSubject s) {
        if (!this.isKernelIdentity(s)) {
            throw new SecurityException("Subject '" + (s == null ? "<null>" : s.toString()) + "' is not the kernel identity");
        }
    }

    protected abstract AbstractSubject getKernelIdentity();

    public static final SubjectManager getSubjectManager() {
        if (singleton == null) {
            return new SubjectManager(){

                @Override
                protected AbstractSubject getKernelIdentity() {
                    return null;
                }

                @Override
                public AbstractSubject getCurrentSubject(AbstractSubject k) {
                    throw new SecurityException("SubjectManager not installed");
                }

                @Override
                public AbstractSubject getCurrentSubject(AbstractSubject k, AuditableThread thread) {
                    throw new SecurityException("SubjectManager not installed");
                }

                @Override
                public void pushSubject(AbstractSubject k, AbstractSubject u) {
                    throw new SecurityException("SubjectManager not installed");
                }

                @Override
                public void popSubject(AbstractSubject k) {
                    throw new SecurityException("SubjectManager not installed");
                }

                @Override
                protected AbstractSubject createAbstractSubject(Subject subject) {
                    throw new SecurityException("SubjectManager not installed");
                }

                @Override
                public int getSize() {
                    throw new SecurityException("SubjectManager not installed");
                }

                @Override
                public AbstractSubject getAnonymousSubject() {
                    throw new SecurityException("SubjectManager not installed");
                }
            };
        }
        return singleton;
    }

    protected static final boolean subjectManagerInstalled() {
        return singleton != null;
    }

    public static final void setSubjectManager(SubjectManager manager) {
        if (singleton != null) {
            AccessController.checkPermission(KERNEL_PERM);
        }
        singleton = manager;
    }

    public static final PrivilegedAction setSubjectManagerAction(SubjectManager manager) {
        return new SetSubjectManagerAction(manager);
    }

    public Object runAs(Subject userIdentity, PrivilegedAction action) {
        if (userIdentity == null) {
            throw new SecurityException("Null user identity");
        }
        return this.getAbstractSubject(userIdentity).doAs(this.getCachedKernelIdentity(), action);
    }

    public Object runAs(Subject userIdentity, PrivilegedExceptionAction action) throws PrivilegedActionException {
        if (userIdentity == null) {
            throw new SecurityException("Null user identity");
        }
        return this.getAbstractSubject(userIdentity).doAs(this.getCachedKernelIdentity(), action);
    }

    protected abstract AbstractSubject createAbstractSubject(Subject var1);

    private final AbstractSubject getAbstractSubject(final Subject subject) {
        return (AbstractSubject)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                for (Object obj : subject.getPrivateCredentials()) {
                    if (!(obj instanceof AbstractSubject)) continue;
                    return obj;
                }
                return SubjectManager.this.createAbstractSubject(subject);
            }
        });
    }

    public String getSubjectName(AbstractSubject subject) {
        if (subject == null) {
            throw new AssertionError((Object)"subject is null");
        }
        if (this.isKernelIdentity(subject)) {
            return KERNEL_USERNAME;
        }
        Principal user = SubjectManager.getOnePrincipal(subject, SubjectProxy.class);
        if (user == null) {
            return ANONYMOUS_USERNAME;
        }
        return user.getName();
    }

    public static Principal getOnePrincipal(AbstractSubject subject, Class type) {
        return SubjectManager.getOnePrincipalClass(subject.getPrincipals(), type);
    }

    public static Principal getOnePrincipalClass(Set principals, Class type) {
        for (Principal p : principals) {
            if (!type.isAssignableFrom(p.getClass())) continue;
            return p;
        }
        return null;
    }

    private static String initAnonymousUsername() {
        try {
            return System.getProperty("weblogic.security.anonymousUserName", DEFAULT_ANONYMOUS_USERNAME);
        }
        catch (Exception ignore) {
            return DEFAULT_ANONYMOUS_USERNAME;
        }
    }

    public abstract AbstractSubject getAnonymousSubject();

    private static final class GetKernelIdentityAction
    implements PrivilegedAction {
        private GetKernelIdentityAction() {
        }

        public final Object run() {
            return SubjectManager.getSubjectManager().getKernelIdentity();
        }
    }

    private static class KernelIdentityMaker {
        private static AbstractSubject KERNEL_ID = (AbstractSubject)AccessController.doPrivileged(SubjectManager.getKernelIdentityAction());

        private KernelIdentityMaker() {
        }
    }

    private static final class SetSubjectManagerAction
    implements PrivilegedAction {
        private final SubjectManager manager;

        private SetSubjectManagerAction(SubjectManager manager) {
            this.manager = manager;
        }

        public final Object run() {
            SubjectManager.setSubjectManager(this.manager);
            return null;
        }
    }
}

