/*
 * Decompiled with CFR 0.152.
 */
package weblogic.server;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.StringTokenizer;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.HK2Loader;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.Populator;
import org.glassfish.hk2.api.PopulatorPostProcessor;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorFactory;
import org.glassfish.hk2.api.ServiceLocatorListener;
import org.glassfish.hk2.utilities.ClassLoaderPostProcessor;
import org.glassfish.hk2.utilities.ClasspathDescriptorFileFinder;
import org.glassfish.hk2.utilities.DuplicatePostProcessor;
import org.glassfish.hk2.utilities.HK2LoaderImpl;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.external.generator.ServiceLocatorGeneratorImpl;
import weblogic.server.IgnorePostProcessor;
import weblogic.server.debug.InstanceGatherer;

@Service
@Singleton
public class GlobalServiceLocator {
    public static final String IGNORE_PROPERTY = "weblogic.hk2.ignored.services";
    public static final String INCLUDE_PROPERTY = "weblogic.hk2.included.services";
    public static final String HK2_READ_FILES = "weblogic.hk2.gsl.read.files";
    public static final String HK2_INSTANCE_COUNTER_PROPERTY = "weblogic.hk2.instance.counter";
    private static final String HK2_READ_FILES_DEFAULT = "weblogic";
    public static final String WEBLOGIC_LOCATOR_NAME = "weblogic";
    public static final String WEBLOGIC_HK2_INHABITANT_PATH = "META-INF/hk2-locator/weblogic";
    private static final Object locatorLock = new Object();
    private static ServiceLocator staticLocator;
    private static MultiException initializationException;
    private static final LinkedHashSet<ClassLoader> failedClassLoaders;
    private static boolean gslInitialized;
    private final ServiceLocator locator;
    private static final String IGNORE_PATH;
    private static final String INCLUDE_PATH;
    private static final String INSTANCE_COUNTER;
    private static final String DOM_CONFIG_UTILITIES = "org.jvnet.hk2.config.HK2DomConfigUtilities";
    private static final String DOM_CONFIG_UTILITIES_METHOD = "enableHK2DomConfiguration";
    private static final String DOM_CONFIG_TYPES_UTILITIES = "org.jvnet.hk2.config.types.HK2DomConfigTypesUtilities";
    private static final String DOM_CONFIG_TYPES_UTILITIES_METHOD = "enableHK2DomConfigurationConfigTypes";

    private static void checkState() {
        if (initializationException == null) {
            return;
        }
        MultiException findException = new MultiException(initializationException.getErrors());
        findException.addError(new IllegalStateException("The GlobalServiceLocator failed to initailize, see above errors"));
        throw findException;
    }

    private static void bootstrapLocator(ServiceLocator localLocator) {
        GlobalServiceLocator gslInstance = localLocator.getService(GlobalServiceLocator.class, new Annotation[0]);
        if (gslInstance == null || staticLocator == null) {
            System.err.println("GlobalServiceLocator could not be found after initialization of " + localLocator + ".  The local GlobalServiceLocator instance is " + gslInstance + ".  The static GlobalServiceLocator is " + staticLocator + ".  The classloaders used to find the hk2 metadata files is " + failedClassLoaders + ".  All known descriptors follow");
            ServiceLocatorUtilities.dumpAllDescriptors(localLocator, System.err);
            if (initializationException != null) {
                System.err.println(initializationException.getMessage());
                initializationException.printStackTrace(System.err);
            } else {
                System.err.println("There is no intitialization exception");
            }
            throw new IllegalStateException("HK2 has not been initialized after creating GlobalServiceLocator");
        }
    }

    private static void populate(Populator populator, DuplicatePostProcessor dupProcessor, IgnorePostProcessor ignoreProcessor, ClassLoader loader) throws MultiException, IOException {
        PopulatorPostProcessor[] processors = ignoreProcessor == null ? new PopulatorPostProcessor[]{dupProcessor, new ClassLoaderPostProcessor(loader)} : new PopulatorPostProcessor[]{dupProcessor, ignoreProcessor, new ClassLoaderPostProcessor(loader)};
        populator.populate(new ClasspathDescriptorFileFinder(loader, GlobalServiceLocator.getFilesToRead()), processors);
    }

    public static ServiceLocator getServiceLocator() throws IllegalStateException, MultiException {
        Object object = locatorLock;
        synchronized (object) {
            if (staticLocator != null) {
                return staticLocator;
            }
            GlobalServiceLocator.checkState();
            ServiceLocatorFactory locatorFactory = ServiceLocatorFactory.getInstance();
            ServiceLocator localLocator = null;
            if (gslInitialized && (localLocator = locatorFactory.find("weblogic")) != null) {
                GlobalServiceLocator.bootstrapLocator(localLocator);
                if (staticLocator != null) {
                    return staticLocator;
                }
                GlobalServiceLocator.checkState();
                throw new IllegalStateException("HK2 has not been initialized after finding locator");
            }
            gslInitialized = true;
            failedClassLoaders.clear();
            try {
                locatorFactory.addListener(new Listener());
                localLocator = locatorFactory.create("weblogic", null, new ServiceLocatorGeneratorImpl());
                ServiceLocatorUtilities.enableLookupExceptions(localLocator);
                ServiceLocatorUtilities.enableImmediateScope(localLocator);
                ServiceLocatorUtilities.enablePerThreadScope(localLocator);
                DynamicConfigurationService dcs = localLocator.getService(DynamicConfigurationService.class, new Annotation[0]);
                Populator populator = dcs.getPopulator();
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                if (loader != null) {
                    failedClassLoaders.add(loader);
                }
                if ((loader = GlobalServiceLocator.class.getClassLoader()) != null) {
                    failedClassLoaders.add(loader);
                }
                if ((loader = ClassLoader.getSystemClassLoader()) != null) {
                    failedClassLoaders.add(loader);
                }
                if (failedClassLoaders.isEmpty()) {
                    throw new AssertionError((Object)"Could not find any classloader for the GlobalServiceLocator to use");
                }
                DuplicatePostProcessor dupProcessor = new DuplicatePostProcessor();
                IgnorePostProcessor ignoreProcessor = null;
                if (IGNORE_PATH != null || INCLUDE_PATH != null) {
                    try {
                        ignoreProcessor = new IgnorePostProcessor(IGNORE_PATH, INCLUDE_PATH);
                    }
                    catch (IOException ioe) {
                        throw new IllegalStateException(ioe);
                    }
                }
                for (ClassLoader cl : failedClassLoaders) {
                    GlobalServiceLocator.populate(populator, dupProcessor, ignoreProcessor, cl);
                    try {
                        HK2LoaderImpl hk2Loader = new HK2LoaderImpl(cl);
                        GlobalServiceLocator.secureCallInitializerMethod(DOM_CONFIG_UTILITIES, cl, localLocator, DOM_CONFIG_UTILITIES_METHOD, hk2Loader);
                        GlobalServiceLocator.secureCallInitializerMethod(DOM_CONFIG_TYPES_UTILITIES, cl, localLocator, DOM_CONFIG_TYPES_UTILITIES_METHOD, hk2Loader);
                    }
                    catch (Throwable throwable) {}
                }
                GlobalServiceLocator.bootstrapLocator(localLocator);
                failedClassLoaders.clear();
                return staticLocator;
            }
            catch (MultiException me) {
                initializationException = me;
                throw initializationException;
            }
            catch (Throwable th) {
                initializationException = new MultiException(th);
                throw initializationException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dispose() {
        Object object = locatorLock;
        synchronized (object) {
            gslInitialized = false;
            initializationException = null;
            if (staticLocator == null) {
                return;
            }
            failedClassLoaders.clear();
            staticLocator.shutdown();
            staticLocator = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject
    public GlobalServiceLocator(ServiceLocator serviceLocator) {
        this.locator = serviceLocator;
        Object object = locatorLock;
        synchronized (object) {
            staticLocator = serviceLocator;
        }
    }

    private static String[] getFilesToRead() {
        StringTokenizer st = new StringTokenizer(GlobalServiceLocator.getSystemProperty(HK2_READ_FILES, "weblogic"), ",");
        LinkedList<String> retVal = new LinkedList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            retVal.add(token);
        }
        return retVal.toArray(new String[retVal.size()]);
    }

    private static String getSystemProperty(final String prop, final String def) {
        try {
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(prop, def);
                }
            });
        }
        catch (Throwable th) {
            return def;
        }
    }

    private static void secureCallInitializerMethod(final String initializerClass, final ClassLoader loader, final ServiceLocator locator, final String methodName, final HK2Loader hk2Loader) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                GlobalServiceLocator.callInitializerMethod(initializerClass, loader, locator, methodName, hk2Loader);
                return null;
            }
        });
    }

    private static void callInitializerMethod(String initializerClass, ClassLoader loader, ServiceLocator locator, String methodName, HK2Loader hk2Loader) {
        Method method;
        Class<?> foundClass = GlobalServiceLocator.myLoadClass(initializerClass, loader);
        if (foundClass == null) {
            return;
        }
        Class[] parameterTypes = new Class[]{ServiceLocator.class, HK2Loader.class};
        try {
            method = foundClass.getMethod(methodName, parameterTypes);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
        Object[] parameters = new Object[]{locator, hk2Loader};
        try {
            method.invoke(null, parameters);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    private static Class<?> myLoadClass(String lookForMe, ClassLoader loader) {
        try {
            return loader.loadClass(lookForMe);
        }
        catch (Throwable th) {
            return null;
        }
    }

    public String toString() {
        return "GlobalServiceLocator(" + this.locator + "," + System.identityHashCode(this) + ")";
    }

    static {
        failedClassLoaders = new LinkedHashSet();
        gslInitialized = false;
        IGNORE_PATH = GlobalServiceLocator.getSystemProperty(IGNORE_PROPERTY, null);
        INCLUDE_PATH = GlobalServiceLocator.getSystemProperty(INCLUDE_PROPERTY, null);
        INSTANCE_COUNTER = GlobalServiceLocator.getSystemProperty(HK2_INSTANCE_COUNTER_PROPERTY, null);
    }

    private static class Listener
    implements ServiceLocatorListener {
        private Listener() {
        }

        @Override
        public void initialize(Set<ServiceLocator> initialLocators) {
            if (INSTANCE_COUNTER == null) {
                return;
            }
            for (ServiceLocator locator : initialLocators) {
                ServiceLocatorUtilities.addClasses(locator, InstanceGatherer.class);
            }
        }

        @Override
        public void locatorAdded(ServiceLocator added) {
            if (INSTANCE_COUNTER == null) {
                return;
            }
            ServiceLocatorUtilities.addClasses(added, InstanceGatherer.class);
        }

        @Override
        public void locatorDestroyed(ServiceLocator destroyed) {
        }
    }
}

