/*
 * Decompiled with CFR 0.152.
 */
package weblogic.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import org.glassfish.hk2.api.PopulatorPostProcessor;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.DescriptorImpl;
import weblogic.server.GlobalServiceLocator;

public class IgnorePostProcessor
implements PopulatorPostProcessor {
    private static final String ALWAYS_INCLUDE = GlobalServiceLocator.class.getName();
    private final HashSet<String> ignoreMe = new HashSet();
    private final HashSet<String> includeMe;

    IgnorePostProcessor(String ignoreFileAsString, String includeFileAsString) throws IOException {
        File file;
        if (ignoreFileAsString != null) {
            file = new File(ignoreFileAsString);
            if (!file.exists() || !file.canRead()) {
                throw new IOException("The property weblogic.hk2.ignored.services was set to " + ignoreFileAsString + " but there is no file at that location or the file is not readable");
            }
            IgnorePostProcessor.readFile(file, this.ignoreMe);
        }
        if (includeFileAsString == null) {
            this.includeMe = null;
            return;
        }
        this.includeMe = new HashSet();
        this.includeMe.add(ALWAYS_INCLUDE);
        file = new File(includeFileAsString);
        if (!file.exists() || !file.canRead()) {
            throw new IOException("The property weblogic.hk2.included.services was set to " + includeFileAsString + " but there is no file at that location or the file is not readable");
        }
        IgnorePostProcessor.readFile(file, this.includeMe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readFile(File file, HashSet<String> fillMeIn) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#") || line.startsWith("!") || line.startsWith("$") || line.startsWith("//") || line.isEmpty() || line.trim().isEmpty()) continue;
                fillMeIn.add(line);
            }
        }
    }

    @Override
    public DescriptorImpl process(ServiceLocator serviceLocator, DescriptorImpl descriptorImpl) {
        if (this.ignoreMe.contains(descriptorImpl.getImplementation())) {
            return null;
        }
        if (this.includeMe == null) {
            return descriptorImpl;
        }
        if (!this.includeMe.contains(descriptorImpl.getImplementation())) {
            return null;
        }
        return descriptorImpl;
    }
}

