/*
 * Decompiled with CFR 0.152.
 */
package weblogic.server.debug;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.DescriptorType;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.InstanceLifecycleEvent;
import org.glassfish.hk2.api.InstanceLifecycleEventType;
import org.glassfish.hk2.api.InstanceLifecycleListener;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorState;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.jvnet.hk2.external.runtime.ServiceLocatorRuntimeBean;

@Singleton
public class InstanceGatherer
implements InstanceLifecycleListener {
    private static List<InstanceGatherer> INSTANCES = new ArrayList<InstanceGatherer>(10);
    private final Map<ActiveDescriptor<?>, Long> counter = new HashMap();
    @Inject
    private ServiceLocator locator;
    @Inject
    private ServiceLocatorRuntimeBean runtime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addInstance(InstanceGatherer add) {
        Class<InstanceGatherer> clazz = InstanceGatherer.class;
        synchronized (InstanceGatherer.class) {
            INSTANCES.add(add);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private InstanceGatherer() {
        InstanceGatherer.addInstance(this);
    }

    @Override
    public Filter getFilter() {
        return BuilderHelper.allFilter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lifecycleEvent(InstanceLifecycleEvent lifecycleEvent) {
        if (!InstanceLifecycleEventType.POST_PRODUCTION.equals((Object)lifecycleEvent.getEventType())) {
            return;
        }
        ActiveDescriptor<?> ad = lifecycleEvent.getActiveDescriptor();
        if (ad == null) {
            return;
        }
        InstanceGatherer instanceGatherer = this;
        synchronized (instanceGatherer) {
            Long currentCount = this.counter.get(ad);
            if (currentCount == null) {
                currentCount = 1L;
                this.counter.put(ad, currentCount);
                return;
            }
            currentCount = currentCount + 1L;
            this.counter.put(ad, currentCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        TreeSet<OutputKey> sorted = new TreeSet<OutputKey>();
        InstanceGatherer instanceGatherer = this;
        synchronized (instanceGatherer) {
            for (Map.Entry<ActiveDescriptor<?>, Long> entry : this.counter.entrySet()) {
                sorted.add(new OutputKey(entry.getValue(), entry.getKey()));
            }
        }
        boolean first = true;
        StringBuffer sb = new StringBuffer();
        int lcv = 1;
        for (OutputKey ok : sorted) {
            if (first) {
                first = false;
            } else {
                sb.append("\n");
            }
            sb.append(lcv++ + ". " + ok.secondaryKey.getImplementation() + "(" + ok.secondaryKey.getServiceId() + "," + ok.secondaryKey.getLocatorId() + (ok.secondaryKey.getDescriptorType().equals((Object)DescriptorType.PROVIDE_METHOD) ? ",provide" : "") + ") created " + ok.numIterations + " times");
        }
        sb.append("\nNumber of Descriptors: " + this.runtime.getNumberOfDescriptors());
        sb.append("\nNumber of Children: " + this.runtime.getNumberOfChildren());
        sb.append("\nService Cache Size: " + this.runtime.getServiceCacheSize());
        sb.append("\nService Cache Maximum Size: " + this.runtime.getServiceCacheMaximumSize());
        sb.append("\nReflection Cache Size: " + this.runtime.getReflectionCacheSize());
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Class<InstanceGatherer> clazz = InstanceGatherer.class;
        synchronized (InstanceGatherer.class) {
            INSTANCES.clear();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String allInstanceSummary() {
        Class<InstanceGatherer> clazz = InstanceGatherer.class;
        synchronized (InstanceGatherer.class) {
            StringBuffer sb = new StringBuffer();
            if (INSTANCES.isEmpty()) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return "No InstanceGatherer instances to report";
            }
            HashSet<InstanceGatherer> shutdown = new HashSet<InstanceGatherer>();
            for (InstanceGatherer instance : INSTANCES) {
                sb.append("\n#### Instances for ServiceLocator " + instance.locator + " ####\n");
                if (!instance.locator.getState().equals((Object)ServiceLocatorState.RUNNING)) {
                    sb.append("Locator " + instance.locator + " has shut down\n");
                    shutdown.add(instance);
                }
                sb.append(instance.toString());
                sb.append("\n#### Finshed information dump for locator " + instance.locator + " ####\n");
            }
            for (InstanceGatherer removeMe : shutdown) {
                INSTANCES.remove(removeMe);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sb.toString();
        }
    }

    private static final class OutputKey
    implements Comparable<OutputKey> {
        private final long numIterations;
        private final ActiveDescriptor<?> secondaryKey;

        private OutputKey(long numIterations, ActiveDescriptor<?> secondaryKey) {
            this.numIterations = numIterations;
            this.secondaryKey = secondaryKey;
        }

        @Override
        public int compareTo(OutputKey o) {
            if (this.numIterations > o.numIterations) {
                return -1;
            }
            if (this.numIterations < o.numIterations) {
                return 1;
            }
            if (this.secondaryKey.getLocatorId() < o.secondaryKey.getLocatorId()) {
                return -1;
            }
            if (this.secondaryKey.getLocatorId() > o.secondaryKey.getLocatorId()) {
                return 1;
            }
            if (this.secondaryKey.getServiceId() < o.secondaryKey.getServiceId()) {
                return -1;
            }
            if (this.secondaryKey.getServiceId() > o.secondaryKey.getServiceId()) {
                return 1;
            }
            return 0;
        }

        public int hashCode() {
            return new Long(this.numIterations).hashCode() ^ this.secondaryKey.hashCode();
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof OutputKey)) {
                return false;
            }
            OutputKey other = (OutputKey)o;
            return this.numIterations == other.numIterations && this.secondaryKey.equals(other.secondaryKey);
        }
    }
}

