/*
 * Decompiled with CFR 0.152.
 */
package weblogic.t3.srvr;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import weblogic.diagnostics.debug.DebugLogger;

public class FileOwnerFixer {
    private static FileOwnerFixer fof = new FileOwnerFixer();
    private static boolean isActive = FileOwnerFixer.supportsPosixFileAttributeView();
    private ConcurrentLinkedQueue<Path> paths = new ConcurrentLinkedQueue();
    private static final DebugLogger dbgLogger = DebugLogger.getDebugLogger("DebugFileOwnerFixer");
    int modifiedCount = 0;

    public static void addPathJDK6(File file) {
        if (file == null) {
            if (dbgLogger.isDebugEnabled()) {
                dbgLogger.debug("An attempt was made to register a null file", new Throwable());
            }
        } else {
            FileOwnerFixer.addPath(file.toPath());
        }
    }

    public static void addPath(Path path) {
        if (path == null) {
            if (dbgLogger.isDebugEnabled()) {
                dbgLogger.debug("An attempt was made to register a null path", new Throwable());
            }
        } else if (isActive && FileOwnerFixer.isStateOK("An attempt was made to add a path, " + path + ", after the ownerships have been fixed.")) {
            fof.doAddPath(path);
        }
    }

    public static int fixFileOwnerships(String uid, String gid) {
        if (isActive && FileOwnerFixer.isStateOK("An attempt to fix file ownership was made after ownerships were already fixed once.")) {
            int modifiedCount = fof.doFixFileOwnerships(uid, gid);
            fof = null;
            return modifiedCount;
        }
        return 0;
    }

    private static boolean supportsPosixFileAttributeView() {
        return FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
    }

    private void doAddPath(Path path) {
        if (this.thisAndAncestorsWereNeverAdded(path)) {
            this.paths.add(this.getEarliestNewAncestor(path));
        }
    }

    private Path getEarliestNewAncestor(Path path) {
        Path parent = path.getParent();
        if (parent == null || Files.exists(parent, new LinkOption[0])) {
            return path;
        }
        return this.getEarliestNewAncestor(parent);
    }

    private boolean thisAndAncestorsWereNeverAdded(Path path) {
        for (Path p : this.paths) {
            if (!path.startsWith(p)) continue;
            return false;
        }
        return true;
    }

    private static boolean isStateOK(String message) {
        if (fof == null && dbgLogger.isDebugEnabled()) {
            dbgLogger.debug(message, new Throwable());
        }
        return fof != null;
    }

    private int doFixFileOwnerships(String uid, String gid) {
        UserPrincipalLookupService upls = FileSystems.getDefault().getUserPrincipalLookupService();
        UserPrincipal up = this.getUserPrincipal(uid, upls);
        GroupPrincipal gp = this.getGroupPrincipal(gid, upls);
        if (this.paths.size() > 0) {
            for (Path path : this.getDistinctPaths(this.paths.toArray(new Path[this.paths.size()]))) {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    this.fixTreeOwnership(up, gp, path);
                    continue;
                }
                if (!Files.exists(path, new LinkOption[0])) continue;
                this.fixPathOwnership(up, gp, path);
            }
        }
        return this.modifiedCount;
    }

    protected List<Path> getDistinctPaths(Path ... ps) {
        LinkedList<Path> distinctPaths = new LinkedList<Path>();
        boolean[] isDup = new boolean[ps.length];
        for (int i = 0; i < ps.length - 1; ++i) {
            if (isDup[i]) continue;
            Path basePath = ps[i];
            boolean keepBasePath = true;
            for (int j = i + 1; j < ps.length; ++j) {
                Path otherPath = ps[j];
                if (basePath.startsWith(otherPath)) {
                    keepBasePath = false;
                    continue;
                }
                if (!otherPath.startsWith(basePath)) continue;
                isDup[j] = true;
            }
            if (!keepBasePath) continue;
            distinctPaths.add(basePath);
        }
        if (!isDup[ps.length - 1]) {
            distinctPaths.add(ps[ps.length - 1]);
        }
        return distinctPaths;
    }

    private void fixTreeOwnership(final UserPrincipal up, final GroupPrincipal gp, Path path) {
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (Files.exists(file, new LinkOption[0])) {
                        FileOwnerFixer.this.fixPathOwnership(up, gp, file);
                        return FileVisitResult.CONTINUE;
                    }
                    return FileVisitResult.SKIP_SUBTREE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    if (Files.exists(dir, new LinkOption[0])) {
                        FileOwnerFixer.this.fixPathOwnership(up, gp, dir);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw FileOwnerFixer.handleException(e, "Unable to walk directory tree at " + path);
        }
    }

    private void fixPathOwnership(UserPrincipal up, GroupPrincipal gp, Path path) {
        try {
            Files.setOwner(path, up);
            Files.getFileAttributeView(path, PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS).setGroup(gp);
            ++this.modifiedCount;
        }
        catch (IOException e) {
            throw FileOwnerFixer.handleException(e, "Failed to set ownership for path " + path);
        }
    }

    private GroupPrincipal getGroupPrincipal(String gid, UserPrincipalLookupService upls) {
        try {
            return upls.lookupPrincipalByGroupName(gid);
        }
        catch (IOException e) {
            throw FileOwnerFixer.handleException(e, "Failed to retrieve group principal for group id " + gid);
        }
    }

    private UserPrincipal getUserPrincipal(String uid, UserPrincipalLookupService upls) {
        try {
            return upls.lookupPrincipalByName(uid);
        }
        catch (IOException e) {
            throw FileOwnerFixer.handleException(e, "Failed to retrieve user principal for user id " + uid);
        }
    }

    private static RuntimeException handleException(IOException e, String msg) {
        return new RuntimeException(msg, e);
    }
}

