/*
 * Decompiled with CFR 0.152.
 */
package weblogic.transaction;

import java.util.EmptyStackException;
import java.util.Stack;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.UserTransaction;
import weblogic.kernel.KernelStatus;
import weblogic.transaction.ClientTransactionManager;
import weblogic.transaction.InterposedTransactionManager;

public abstract class TransactionHelper {
    private static TransactionHelper singleton;
    private static Stack txStack;

    public static TransactionHelper getTransactionHelper() {
        if (singleton == null) {
            try {
                singleton = (TransactionHelper)Class.forName("weblogic.transaction.internal.CETransactionHelperImpl").newInstance();
            }
            catch (Exception ignore) {
                try {
                    singleton = (TransactionHelper)Class.forName("weblogic.transaction.internal.TransactionHelperImpl").newInstance();
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e.toString());
                }
            }
        }
        return singleton;
    }

    public static void setTransactionHelper(TransactionHelper helper) {
        singleton = helper;
    }

    public static void pushTransactionHelper(TransactionHelper helper) {
        if (!KernelStatus.isServer()) {
            txStack.push(helper);
            singleton = helper;
        }
    }

    public static TransactionHelper popTransactionHelper() throws EmptyStackException {
        if (!KernelStatus.isServer()) {
            try {
                singleton = (TransactionHelper)txStack.pop();
            }
            catch (EmptyStackException emptyStackException) {
                // empty catch block
            }
        }
        return singleton;
    }

    public abstract UserTransaction getUserTransaction();

    public abstract ClientTransactionManager getTransactionManager();

    public Transaction getTransaction() {
        try {
            ClientTransactionManager tm = this.getTransactionManager();
            if (tm != null) {
                return tm.getTransaction();
            }
        }
        catch (SystemException se) {
            se.printStackTrace();
        }
        return null;
    }

    public static InterposedTransactionManager getClientInterposedTransactionManager(Context initialContext, String serverName) {
        try {
            return TransactionHelper.doGetClientInterposedTransactionManager(initialContext, serverName);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static InterposedTransactionManager getClientInterposedTransactionManagerThrowsOnException(Context initialContext, String serverName) throws Exception {
        return TransactionHelper.doGetClientInterposedTransactionManager(initialContext, serverName);
    }

    private static InterposedTransactionManager doGetClientInterposedTransactionManager(Context initialContext, String serverName) throws NamingException {
        InterposedTransactionManager itm = (InterposedTransactionManager)initialContext.lookup("weblogic.transaction.coordinators." + serverName);
        itm.setSSLURLFromClientInfo(itm, initialContext);
        return itm;
    }

    static {
        txStack = new Stack();
    }
}

