/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;

public final class ArrayIterator
implements Iterator {
    private final Object[] array;
    private final int maxIndex;
    private int index;

    public ArrayIterator(Object[] a) {
        this(a, 0, a.length);
    }

    public ArrayIterator(Object[] a, int off, int len) {
        if (off < 0) {
            throw new IllegalArgumentException();
        }
        if (off > a.length) {
            throw new IllegalArgumentException();
        }
        if (len > a.length - off) {
            throw new IllegalArgumentException();
        }
        this.array = a;
        this.index = off;
        this.maxIndex = len + off;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.maxIndex;
    }

    public Object next() {
        if (this.index >= this.maxIndex) {
            throw new NoSuchElementException();
        }
        return this.array[this.index++];
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

