/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io;

import java.util.HashSet;
import java.util.StringTokenizer;

public abstract class ClassFilter {
    static final String BLACK_LIST_PROPERTY = "weblogic.rmi.blacklist";
    static final String DISABLE_DEFAULT_BLACKLIST_PROPERTY = "weblogic.rmi.disabledefaultblacklist";
    static final String DISABLE_BLACK_LIST_PROPERTY = "weblogic.rmi.disableblacklist";
    private static final String DEFAULT_BLACK_LIST = "+org.apache.commons.collections.functors,+com.sun.org.apache.xalan.internal.xsltc.trax,+javassist,+org.codehaus.groovy.runtime.ConvertedClosure,+org.codehaus.groovy.runtime.ConversionHandler,+org.codehaus.groovy.runtime.MethodClosure";
    private static final HashSet<String> BLACK_LIST = new HashSet(32);

    private static boolean isBlackListDisabled() {
        return Boolean.getBoolean(DISABLE_BLACK_LIST_PROPERTY);
    }

    private static boolean isDefaultBlacklistEntriesDisabled() {
        return Boolean.getBoolean(DISABLE_DEFAULT_BLACKLIST_PROPERTY);
    }

    private static void updateBlackList(String blackList) {
        if (blackList != null) {
            StringTokenizer st = new StringTokenizer(blackList, ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                ClassFilter.processToken(token);
            }
        }
    }

    private static void processToken(String token) {
        if (token.startsWith("+")) {
            BLACK_LIST.add(token.substring(1));
        } else if (token.startsWith("-")) {
            BLACK_LIST.remove(token.substring(1));
        } else {
            BLACK_LIST.add(token);
        }
    }

    public static boolean isBlackListed(String className) {
        String pkgName;
        if (!className.isEmpty() && BLACK_LIST.contains(className)) {
            return true;
        }
        try {
            pkgName = className.substring(0, className.lastIndexOf(46));
        }
        catch (Exception ignored) {
            return false;
        }
        return !pkgName.isEmpty() && BLACK_LIST.contains(pkgName);
    }

    static {
        if (!ClassFilter.isBlackListDisabled()) {
            if (!ClassFilter.isDefaultBlacklistEntriesDisabled()) {
                ClassFilter.updateBlackList(DEFAULT_BLACK_LIST);
            }
            ClassFilter.updateBlackList(System.getProperty(BLACK_LIST_PROPERTY, null));
        }
    }
}

