/*
 * Decompiled with CFR 0.152.
 */
package weblogic.workarea;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.utils.io.ClassFilter;
import weblogic.workarea.PrimitiveWorkContext;
import weblogic.workarea.WorkContextInput;
import weblogic.workarea.WorkContextOutput;

public class SerializableWorkContext
implements PrimitiveWorkContext,
Serializable {
    private static final DebugLogger debugWorkContext = DebugLogger.getDebugLogger("DebugWorkContext");
    private static final long serialVersionUID = 3485637846065994552L;
    private byte[] data;
    private transient Serializable object;
    private transient boolean mutable = false;

    public SerializableWorkContext() {
    }

    SerializableWorkContext(Serializable s) throws IOException {
        this(s, false);
    }

    SerializableWorkContext(Serializable s, boolean mutable) throws IOException {
        this.object = s;
        this.mutable = mutable;
        if (!mutable) {
            this.data = this.serialize(this.object);
        }
    }

    public String toString() {
        return "Serializable";
    }

    @Override
    public Object get() {
        try {
            return this.getSerializable();
        }
        catch (IOException ioe) {
            return this.data;
        }
        catch (ClassNotFoundException cnfe) {
            return this.data;
        }
    }

    public Serializable getSerializable() throws IOException, ClassNotFoundException {
        if (this.object != null) {
            return this.object;
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(this.data);
        ObjectInputStream in = new ObjectInputStream(bin){

            @Override
            protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                String className = desc.getName();
                if (className != null && className.length() > 0) {
                    try {
                        if (ClassFilter.isBlackListed(className)) {
                            if (debugWorkContext.isDebugEnabled()) {
                                debugWorkContext.debug("Unauthorized deserialization attempt");
                            }
                            throw new InvalidClassException("Unauthorized deserialization attempt", className);
                        }
                        return Class.forName(className, false, Thread.currentThread().getContextClassLoader());
                    }
                    catch (ClassNotFoundException cnfe) {
                        return super.resolveClass(desc);
                    }
                }
                throw new ClassNotFoundException(className);
            }

            @Override
            protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
                ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
                ClassLoader nonPublicLoader = null;
                boolean hasNonPublicInterface = false;
                Class[] classObjs = new Class[interfaces.length];
                for (int i = 0; i < interfaces.length; ++i) {
                    Class<?> cl = Class.forName(interfaces[i], false, ctxLoader);
                    if ((cl.getModifiers() & 1) == 0) {
                        if (hasNonPublicInterface) {
                            if (nonPublicLoader != cl.getClassLoader()) {
                                throw new IllegalAccessError("conflicting non-public interface class loaders");
                            }
                        } else {
                            nonPublicLoader = cl.getClassLoader();
                            hasNonPublicInterface = true;
                        }
                    }
                    classObjs[i] = cl;
                }
                try {
                    return Proxy.getProxyClass(hasNonPublicInterface ? nonPublicLoader : ctxLoader, classObjs);
                }
                catch (IllegalArgumentException e) {
                    throw new ClassNotFoundException(null, e);
                }
            }
        };
        Serializable obj = (Serializable)in.readObject();
        in.close();
        if (obj instanceof Carrier) {
            this.object = ((Carrier)obj).getSerializable();
            this.mutable = ((Carrier)obj).isMutable();
        } else {
            this.object = obj;
        }
        return this.object;
    }

    public int hashCode() {
        if (!this.mutable) {
            return Arrays.hashCode(this.data);
        }
        Object gotten = this.get();
        if (gotten == null) {
            return 0;
        }
        return gotten.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SerializableWorkContext) {
            if (!this.mutable && !((SerializableWorkContext)obj).mutable) {
                return Arrays.equals(((SerializableWorkContext)obj).data, this.data);
            }
            return this.get().equals(((SerializableWorkContext)obj).get());
        }
        return false;
    }

    @Override
    public void writeContext(WorkContextOutput out) throws IOException {
        if (this.mutable) {
            Carrier carrier = new Carrier(this.object);
            carrier.setMutable();
            this.data = this.serialize(carrier);
        }
        out.writeInt(this.data.length);
        out.write(this.data);
    }

    @Override
    public void readContext(WorkContextInput in) throws IOException {
        this.data = new byte[in.readInt()];
        in.readFully(this.data);
    }

    private byte[] serialize(Serializable s) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bout);
        out.writeObject(s);
        out.flush();
        out.close();
        return bout.toByteArray();
    }

    private static class Carrier
    implements Serializable {
        private static final int VERSION = 1;
        private static final long serialVersionUID = -197593099539117489L;
        private Serializable serializable;
        private boolean mutable;

        public Carrier() {
        }

        Carrier(Serializable object) {
            this.serializable = object;
        }

        Serializable getSerializable() {
            return this.serializable;
        }

        void setMutable() {
            this.mutable = true;
        }

        boolean isMutable() {
            return this.mutable;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeInt(1);
            out.writeObject(this.serializable);
            out.writeBoolean(this.mutable);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            int version = in.readInt();
            this.serializable = (Serializable)in.readObject();
            this.mutable = in.readBoolean();
        }
    }
}

