/*
 * Decompiled with CFR 0.152.
 */
package weblogic.workarea.utils;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import weblogic.workarea.WorkContext;
import weblogic.workarea.WorkContextInput;

public final class WorkContextInputAdapter
implements WorkContextInput {
    private final ObjectInput oi;

    public WorkContextInputAdapter(ObjectInput oi) {
        this.oi = oi;
    }

    @Override
    public String readASCII() throws IOException {
        int len = this.readInt();
        byte[] buf = new byte[len];
        this.readFully(buf);
        return new String(buf, 0);
    }

    @Override
    public WorkContext readContext() throws IOException, ClassNotFoundException {
        Class<?> rcClass = null;
        rcClass = Thread.currentThread().getContextClassLoader() != null ? Class.forName(this.readASCII(), false, Thread.currentThread().getContextClassLoader()) : Class.forName(this.readASCII());
        try {
            WorkContext runtimeContext = (WorkContext)rcClass.newInstance();
            runtimeContext.readContext(this);
            return runtimeContext;
        }
        catch (InstantiationException ie) {
            throw (IOException)new NotSerializableException("WorkContext must have a public no-arg constructor").initCause(ie);
        }
        catch (IllegalAccessException iae) {
            throw (IOException)new NotSerializableException("WorkContext must have a public no-arg constructor").initCause(iae);
        }
    }

    @Override
    public void readFully(byte[] bytes) throws IOException {
        this.oi.readFully(bytes);
    }

    @Override
    public void readFully(byte[] bytes, int i, int i1) throws IOException {
        this.oi.readFully(bytes, i, i1);
    }

    @Override
    public int skipBytes(int i) throws IOException {
        return this.oi.skipBytes(i);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.oi.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.oi.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.oi.readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        return this.oi.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.oi.readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        return this.oi.readChar();
    }

    @Override
    public int readInt() throws IOException {
        return this.oi.readInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.oi.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.oi.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.oi.readDouble();
    }

    @Override
    public String readLine() throws IOException {
        return this.oi.readLine();
    }

    @Override
    public String readUTF() throws IOException {
        return this.oi.readUTF();
    }
}

