




/*
 * This is a generated file. Do not edit this file.
 */
package weblogic.management.security;

import java.util.*;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.zip.CRC32;
import weblogic.descriptor.*;
import weblogic.descriptor.BeanUpdateEvent.PropertyUpdate;
import weblogic.descriptor.internal.*;
import weblogic.descriptor.internal.ReferenceManager.Resolver;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.beangen.StringHelper;
import weblogic.utils.ArrayUtils;
import weblogic.utils.StringUtils;
import weblogic.utils.Debug;
import weblogic.utils.collections.ArrayIterator;
import weblogic.utils.collections.CombinedIterator;
import weblogic.descriptor.internal.Munger.ReaderEventInfo;

import weblogic.descriptor.DescriptorBean;
import weblogic.management.commo.StandardInterface;
import weblogic.management.utils.ErrorCollectionException;
import weblogic.management.utils.InvalidParameterException;
import java.util.Properties;


/**
 * Corresponds to ImportMBean
 * (Interface=weblogic.management.security.ImportMBean)
 * @author Copyright (c) 2003,2014, Oracle and/or its affiliates. All rights reserved.
 * @version 0.1
 *
 * Provides a set of methods for importing provider specific data.
 A provider MBean can optionally extend this MBean.
 The WebLogic Server Administration Console detects when a provider
 extends this MBean and automatically provides a GUI for using these methods.
 *
 * @xsdgen:complexType.typeName importType
 * @xsdgen:complexType.targetNamespace http://xmlns.oracle.com/weblogic/security
 * @xsdgen:complexType.ignoreSuper
 */
public class ImportMBeanImpl
  extends weblogic.management.commo.AbstractCommoConfigurationBean
  implements ImportMBean, java.io.Serializable
{
  private String[] _SupportedImportConstraints;
  private String[] _SupportedImportFormats;


  /**
   * 
   * (Interface=weblogic.management.security.ImportMBean Attribute=ImportMBeanImpl)
   *
   */
  public ImportMBeanImpl() {
    super();
    _initializeProperty(-1);
  }

  /**
   * 
   * (Interface=weblogic.management.security.ImportMBean Attribute=ImportMBeanImpl)
   *
   */
  public ImportMBeanImpl(weblogic.descriptor.DescriptorBean param0, int param1) {
    super(param0, param1);
    _initializeProperty(-1);
  }

  /**
   * 
   * (Interface=weblogic.management.security.ImportMBean Attribute=ImportMBeanImpl)
   *
   */
  public ImportMBeanImpl(weblogic.descriptor.DescriptorBean param0, int param1, boolean param2) {
    super(param0, param1);
    _setTransient(param2);
    _initializeProperty(-1);
  }

  /**
   * Returns the list of import data formats that this provider supports.
   * (Interface=weblogic.management.security.ImportMBean Attribute=getSupportedImportFormats)
   *
   * @xsdgen:element.exclude
   * @transient
   */
  public String[] getSupportedImportFormats() {
    return _SupportedImportFormats;
  }

  /**
   * 
   * (Interface=weblogic.management.security.ImportMBean Attribute=isSupportedImportFormatsInherited)
   *
   * return true if the value of property SupportedImportFormats is inherited from template
   */
  public boolean isSupportedImportFormatsInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.ImportMBean Attribute=isSupportedImportFormatsSet)
   *
   * @xsdgen:isSetMethodFor supported-import-format
   */
  public boolean isSupportedImportFormatsSet() {
    return _isSet(2);
  }

  /**
   * 
   * (Interface=weblogic.management.security.ImportMBean Attribute=setSupportedImportFormats)
   *
   */
  public void setSupportedImportFormats(String[] param0)
    throws javax.management.InvalidAttributeValueException
  {
    param0 = (param0 == null) ? new String[0] : param0;
    param0 = _getHelper()._trimElements(param0);
    _SupportedImportFormats = param0;
  }

  /**
   * Returns the list of import constraints that this provider supports.
   * (Interface=weblogic.management.security.ImportMBean Attribute=getSupportedImportConstraints)
   *
   * @xsdgen:element.exclude
   * @transient
   */
  public String[] getSupportedImportConstraints() {
    return _SupportedImportConstraints;
  }

  /**
   * 
   * (Interface=weblogic.management.security.ImportMBean Attribute=isSupportedImportConstraintsInherited)
   *
   * return true if the value of property SupportedImportConstraints is inherited from template
   */
  public boolean isSupportedImportConstraintsInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.ImportMBean Attribute=isSupportedImportConstraintsSet)
   *
   * @xsdgen:isSetMethodFor supported-import-constraint
   */
  public boolean isSupportedImportConstraintsSet() {
    return _isSet(3);
  }

  /**
   * 
   * (Interface=weblogic.management.security.ImportMBean Attribute=setSupportedImportConstraints)
   *
   */
  public void setSupportedImportConstraints(String[] param0)
    throws javax.management.InvalidAttributeValueException
  {
    param0 = (param0 == null) ? new String[0] : param0;
    param0 = _getHelper()._trimElements(param0);
    _SupportedImportConstraints = param0;
  }

  /**
   * Imports provider specific data from a specified format.
 When errors occur, the MBean throws an ErrorCollectionException
 containing a list of <code>java.lang.Exceptions</code>,
 where the text of each exception describes the error.
   * (Interface=weblogic.management.security.ImportMBean Attribute=importData)
   *
   */
  public void importData(String param0, String param1, java.util.Properties param2)
    throws InvalidParameterException, ErrorCollectionException
  {
    throw new AssertionError("Method not implemented");
  }

  /**
   * 
   * (Interface=weblogic.management.security.ImportMBean Attribute=_getKey)
   *
   */
  public Object _getKey() {
    return super._getKey();
  }

  /**
   * 
   * (Interface=weblogic.management.security.ImportMBean Attribute=_validate)
   *
   */
  public void _validate()
    throws IllegalArgumentException
  {
    super._validate();
  }



 





  protected void _unSet(int idx) {
    if (!_initializeProperty(idx)) {
      super._unSet(idx);
    } else {
      _markSet(idx, false);
    }
  }


  /**
   * @return new instance of helper
   */
  protected AbstractDescriptorBeanHelper _createHelper() {
    return new Helper(this);
  }

  /**
   * @return true if any property is set
   */
  public boolean _isAnythingSet() {
    return super._isAnythingSet()
      ;
  }



  /**
   * @return true if property initialized, false idx refers to a property
   * handled by superclass
   */
  private boolean _initializeProperty(int idx) {
    boolean initOne = idx > -1;
    if (!initOne) {
      idx = 3;
    }
    try {
      switch (idx) {
      case 3:
        _SupportedImportConstraints = new String[]{};
        if (initOne) break;
      case 2:
        _SupportedImportFormats = new String[]{};
        if (initOne) break;
      default:
        if (initOne) return false;
      }
      return true;
    } catch (RuntimeException e) {
      throw e;
    } catch (Exception e) {
      throw (Error)new AssertionError("Impossible Exception").initCause(e);
    }
  }


  /**
   * This helper class contains methods that are used infrequently and
   * can be easily separated from the bean implementations.  It is loaded
   * on demand to minimize memory usage.
   *
   * @xsdgen:complexType.exclude
   */
  protected static class Helper
    extends weblogic.management.commo.AbstractCommoConfigurationBean.Helper
  {
    private ImportMBeanImpl bean;

    protected Helper(ImportMBeanImpl bean) {
      super(bean);
      this.bean = bean;
    }

    /**
     * @return property name indexed by propIndex.
     */
    public String getPropertyName(int propIndex) {
      switch (propIndex) {
      case 3: return "SupportedImportConstraints";
      case 2: return "SupportedImportFormats";
      default: return super.getPropertyName(propIndex);
      }
    }


    /**
     * @return property index of propName.
     */
    public int getPropertyIndex(String propName) {
      if (false) return -1;
      else if (propName.equals("SupportedImportConstraints")) return 3;
      else if (propName.equals("SupportedImportFormats")) return 2;
      else return super.getPropertyIndex(propName);
    }

    /**
     * @return iterator over all children
     */
    public Iterator getChildren() {
      List iterators = new ArrayList();
      return new CombinedIterator(iterators);
    }

    /**
     * Compute hash value for version helper
     */
    protected long computeHashValue(CRC32 crc) {
      try {
        StringBuffer buf = new StringBuffer();
        long superValue = super.computeHashValue(crc);
        if (superValue != 0) {
          buf.append(String.valueOf(superValue));
        }

        long childValue = 0;
        if (bean.isSupportedImportConstraintsSet()){
          buf.append("SupportedImportConstraints");
          buf.append(Arrays.toString(ArrayUtils.copyAndSort(bean.getSupportedImportConstraints())));
        }
        if (bean.isSupportedImportFormatsSet()){
          buf.append("SupportedImportFormats");
          buf.append(Arrays.toString(ArrayUtils.copyAndSort(bean.getSupportedImportFormats())));
        }
        crc.update(buf.toString().getBytes());
        return crc.getValue();
      } catch (Exception e) {
        throw (Error)new AssertionError("Impossible Exception").initCause(e);
      }
    }
    /**
     * Compute difference between this and other
     */
    protected void computeDiff(AbstractDescriptorBean other) {
      try {
        super.computeDiff(other);
      ImportMBeanImpl otherTyped = (ImportMBeanImpl)other;
      } catch (Exception e) {
        throw (Error)new AssertionError("Impossible Exception").initCause(e);
      }
    }

    protected void applyPropertyUpdate(BeanUpdateEvent event, PropertyUpdate update) {
      try {
        ImportMBeanImpl original = (ImportMBeanImpl)event.getSourceBean();
        ImportMBeanImpl proposed = (ImportMBeanImpl)event.getProposedBean();
        String prop = update.getPropertyName();
        int type = update.getUpdateType();
        if (update.isDerivedUpdate()) {
          return;
        }
        if (prop.equals("SupportedImportConstraints")) {
        } else
        if (prop.equals("SupportedImportFormats")) {
        } else
        {
          super.applyPropertyUpdate(event, update);
        }
      // FIXME ehalpern - hack to handle cases where setters throw
      // javax.management.InvalidAttributeValueException.
      } catch (RuntimeException e) {
        throw e;
      } catch (Exception e) {
        throw (Error)new AssertionError("Impossible Exception").initCause(e);
      }
    }

    protected AbstractDescriptorBean finishCopy(
    AbstractDescriptorBean initialCopy, boolean includeObsolete, List excludeProps
    ) {
      Object o;
      try {
        ImportMBeanImpl copy = (ImportMBeanImpl)initialCopy;
        super.finishCopy(copy, includeObsolete, excludeProps);
        return copy;
      // FIXME ehalpern - hack to handle cases where setters throw
      // javax.management.InvalidAttributeValueException.
      } catch (RuntimeException e) {
        throw e;
      } catch (Exception e) {
        throw (Error)new AssertionError("Impossible Exception").initCause(e);
      }
    }

    protected void inferSubTree(Class clazz, Object annotation) {
    	super.inferSubTree(clazz, annotation);
    	Object currentAnnotation = null;
           }
  }


  // FIXME ec@weblogic.com 01-Feb-05 -- no longer used. Remove when ADB method is removed
  public weblogic.descriptor.internal.Munger.SchemaHelper _getSchemaHelper() {
    return null;
  }

  // FIXME ec@weblogic.com 01-Feb-05 -- remove
  public String _getElementName(int propIndex) {
    return _getSchemaHelper2().getElementName(propIndex);
  }

  protected String getSchemaLocation() {
    return "http://xmlns.oracle.com/weblogic/1.0/security.xsd";
  }

  protected String getTargetNamespace() {
    return "http://xmlns.oracle.com/weblogic/security";
  }

  private static SchemaHelper2 _schemaHelper;
  public weblogic.descriptor.internal.SchemaHelper _getSchemaHelper2() {
    if (_schemaHelper == null)
	_schemaHelper = new SchemaHelper2();
    return _schemaHelper;
  }

   // new schema helper
  /**
   * @xsdgen:complexType.exclude
   */
  public static class SchemaHelper2
   extends weblogic.descriptor.internal.AbstractSchemaHelper2
   implements weblogic.descriptor.internal.SchemaHelper
  {
    public int getPropertyIndex(String s) {
      switch(s.length()) {
      case 27:
        if (false) return -1;
        else if (s.equals("supported-import-constraint"))
          return 3;
        break;
      case 23:
        if (false) return -1;
        else if (s.equals("supported-import-format"))
          return 2;
        break;
      default:
        break;
      }
      return super.getPropertyIndex(s);
    }

    public weblogic.descriptor.internal.SchemaHelper getSchemaHelper(int propIndex) {
      switch(propIndex) {
      default:
        return super.getSchemaHelper(propIndex);
      }
    }



    public String getElementName(int propIndex) {
      switch (propIndex) {
        case 3: return "supported-import-constraint";
        case 2: return "supported-import-format";
        default: return super.getElementName(propIndex);
      }
    }


    public boolean isArray(int propIndex) {
      switch(propIndex) {
      case 3:
        return true;
      case 2:
        return true;
      default:
        return super.isArray(propIndex);
      }
    }














  }




  public String wls_getInterfaceClassName() {
    return "weblogic.management.security.ImportMBean"; 
  }

}
