




/*
 * This is a generated file. Do not edit this file.
 */
package weblogic.management.security;

import java.util.*;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.zip.CRC32;
import weblogic.descriptor.*;
import weblogic.descriptor.BeanUpdateEvent.PropertyUpdate;
import weblogic.descriptor.internal.*;
import weblogic.descriptor.internal.ReferenceManager.Resolver;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.beangen.StringHelper;
import weblogic.utils.ArrayUtils;
import weblogic.utils.StringUtils;
import weblogic.utils.Debug;
import weblogic.utils.collections.ArrayIterator;
import weblogic.utils.collections.CombinedIterator;
import weblogic.descriptor.internal.Munger.ReaderEventInfo;

import weblogic.descriptor.DescriptorBean;
import weblogic.management.commo.StandardInterface;
import javax.management.InvalidAttributeValueException;


/**
 * Corresponds to RDBMSSecurityStoreMBean
 * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean)
 * @author Copyright (c) 2003,2014, Oracle and/or its affiliates. All rights reserved.
 * @version 0.1
 *
 * <p>The MBean that represents configuration attributes for a RDBMS security store. It is used to specify the required
 and optional properties for connecting to a RDBMS back-end store.</p>
 *
 * @xsdgen:complexType.typeName rdbms-security-storeType
 * @xsdgen:complexType.targetNamespace http://xmlns.oracle.com/weblogic/security
 * @xsdgen:complexType.ignoreSuper
 */
public class RDBMSSecurityStoreMBeanImpl
  extends weblogic.management.commo.AbstractCommoConfigurationBean
  implements RDBMSSecurityStoreMBean, java.io.Serializable
{
  private String _CompatibilityObjectName;
  private String _ConnectionProperties;
  private String _ConnectionURL;
  private String _DriverName;
  private int _JMSExceptionReconnectAttempts;
  private String _JMSTopic;
  private String _JMSTopicConnectionFactory;
  private String _JNDIPassword;
  private byte[] _JNDIPasswordEncrypted;
  private String _JNDIUsername;
  private String _Name;
  private String _NotificationProperties;
  private String _Password;
  private byte[] _PasswordEncrypted;
  private RealmMBean _Realm;
  private String _Username;
  private transient RDBMSSecurityStoreImpl _customizer;


  /**
   * 
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=RDBMSSecurityStoreMBeanImpl)
   *
   */
  public RDBMSSecurityStoreMBeanImpl() {
    super();
    try {
      _customizer = new weblogic.management.security.RDBMSSecurityStoreImpl(new weblogic.management.commo.RequiredModelMBeanWrapper(this));
    } catch (Exception e) {
      if (e instanceof RuntimeException)
        throw (RuntimeException)e;
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
    _initializeProperty(-1);
  }

  /**
   * 
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=RDBMSSecurityStoreMBeanImpl)
   *
   */
  public RDBMSSecurityStoreMBeanImpl(weblogic.descriptor.DescriptorBean param0, int param1) {
    super(param0, param1);
    try {
      _customizer = new weblogic.management.security.RDBMSSecurityStoreImpl(new weblogic.management.commo.RequiredModelMBeanWrapper(this));
    } catch (Exception e) {
      if (e instanceof RuntimeException)
        throw (RuntimeException)e;
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
    _initializeProperty(-1);
  }

  /**
   * 
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=RDBMSSecurityStoreMBeanImpl)
   *
   */
  public RDBMSSecurityStoreMBeanImpl(weblogic.descriptor.DescriptorBean param0, int param1, boolean param2) {
    super(param0, param1);
    _setTransient(param2);
    try {
      _customizer = new weblogic.management.security.RDBMSSecurityStoreImpl(new weblogic.management.commo.RequiredModelMBeanWrapper(this));
    } catch (Exception e) {
      if (e instanceof RuntimeException)
        throw (RuntimeException)e;
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
    _initializeProperty(-1);
  }

  /**
   * The username to use when connecting to the datastore.
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=getUsername)
   *
   * @xsdgen:element.name username
   * @xsdgen:element.nillable false
   * @xsdgen:element.minLength 1
   * @dynamic false
   */
  public String getUsername() {
    return _Username;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=isUsernameInherited)
   *
   * return true if the value of property Username is inherited from template
   */
  public boolean isUsernameInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=isUsernameSet)
   *
   * @xsdgen:isSetMethodFor username
   */
  public boolean isUsernameSet() {
    return _isSet(2);
  }

  /**
   * <p>Sets the value of the Username attribute.</p>
 
 <p>The string value must be explicitly specified and satisfy the constraint (value != null) &&
 (value.trim().length() > 0.</p>
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=setUsername)
   *
   */
  public void setUsername(String param0)
    throws javax.management.InvalidAttributeValueException
  {
    param0 = (param0 == null) ? null : param0.trim();
    LegalChecks.checkNonEmptyString("Username", param0);
    LegalChecks.checkNonNull("Username", param0);
    String _oldVal = _Username;
    _Username = param0;
    _postSet(2, _oldVal, param0);
  }

  /**
   * <p>The password for the user specified in the <code>Username</code> attribute for connecting
 to the datastore.</p>
 
 <p>When getting the value of this attribute, WebLogic Server does the following:</p>
 <ul>
 <li>Retrieves the value of the <code>PasswordEncrypted</code> attribute.</li>
 <li>Decrypts the value and returns the unencrypted password as a String.</li>
 </ul>

 <p>When you set the value of this attribute, WebLogic Server does the following:</p>
 <ul>
 <li>Encrypts the value.</li>
 <li>Sets the value of the <code>PasswordEncrypted</code> attribute to the encrypted value.</li>
 </ul>
 
 <p>Note that use of the <code>Password</code> attribute is a potential security risk because the String object
 that contains the unencrypted password remains in the JVM's memory until garbage collection removes it
 and the memory is reallocated. Depending on how memory is allocated in the JVM, a significant amount of time
 could pass before this unencrypted data is removed from memory.</p>
 
 <p>Instead of using this attribute, use <code>PasswordEncrypted</code>.</p>
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=getPassword)
   *
   * @xsdgen:element.exclude
   * @transient
   */
  public String getPassword() {
    byte[] bEncrypted = getPasswordEncrypted();
    return (bEncrypted == null) ? null : _decrypt("Password", bEncrypted);
  }

  /**
   * 
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=isPasswordInherited)
   *
   * return true if the value of property Password is inherited from template
   */
  public boolean isPasswordInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=isPasswordSet)
   *
   * @xsdgen:isSetMethodFor password
   */
  public boolean isPasswordSet() {
    return isPasswordEncryptedSet();
  }

  /**
   * Sets the value of the Password attribute.
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=setPassword)
   *
   */
  public void setPassword(String param0)
    throws javax.management.InvalidAttributeValueException
  {
    param0 = (param0 == null) ? null : param0.trim();
    setPasswordEncrypted(param0 == null ? null : _encrypt("Password", param0));
  }

  /**
   * <p>Returns the encrypted password to authenticate the user defined in the <code>Username</code> attribute when
 connecting to the data store.</p>
 
 <p>To set this attribute, use <code>weblogic.management.EncryptionHelper.encrypt()</code> to encrypt the
 value. Then set this attribute to the output of the encrypt() method.</p>
 
 <p>To compare a password that a user enters with the encrypted value of this attribute, go to the same
 WebLogic Server instance that you used to set and encrypt this attribute and use
 <code>weblogic.management.EncryptionHelper.encrypt()</code> to encrypt the user-supplied password.
 Then compare the encrypted values.</p>
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=getPasswordEncrypted)
   *
   * @xsdgen:element.exclude
   */
  public byte[] getPasswordEncrypted() {
    return _getHelper()._cloneArray(_PasswordEncrypted);
  }

  /**
   * 
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=getPasswordEncryptedAsString)
   *
   * @xsdgen:element.name password-encrypted
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   */
  public String getPasswordEncryptedAsString() {
    byte[] obj = getPasswordEncrypted();
    return (obj == null) ? null : (new String(obj));
  }

  /**
   * 
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=isPasswordEncryptedInherited)
   *
   * return true if the value of property PasswordEncrypted is inherited from template
   */
  public boolean isPasswordEncryptedInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=isPasswordEncryptedSet)
   *
   * @xsdgen:isSetMethodFor password-encrypted
   */
  public boolean isPasswordEncryptedSet() {
    return _isSet(4);
  }

  /**
   * 
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=setPasswordEncryptedAsString)
   *
   */
  public void setPasswordEncryptedAsString(String param0) {
    try {
    byte[] encryptedBytes = (param0 == null) ? null : param0.getBytes();
    setPasswordEncrypted(encryptedBytes);
    } catch (Exception e) {
      if (e instanceof RuntimeException)
        throw (RuntimeException)e;
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
  }

  /**
   * The JNDI user name used for Kodo notification.
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=getJNDIUsername)
   *
   * @xsdgen:element.name jndi-username
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @dynamic false
   */
  public String getJNDIUsername() {
    return _JNDIUsername;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=isJNDIUsernameInherited)
   *
   * return true if the value of property JNDIUsername is inherited from template
   */
  public boolean isJNDIUsernameInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=isJNDIUsernameSet)
   *
   * @xsdgen:isSetMethodFor jndi-username
   */
  public boolean isJNDIUsernameSet() {
    return _isSet(5);
  }

  /**
   * Sets the value of the JNDI Username attribute.
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=setJNDIUsername)
   *
   */
  public void setJNDIUsername(String param0)
    throws javax.management.InvalidAttributeValueException
  {
    param0 = (param0 == null) ? null : param0.trim();
    String _oldVal = _JNDIUsername;
    _JNDIUsername = param0;
    _postSet(5, _oldVal, param0);
  }

  /**
   * <p>The password to authenticate the user defined in the <code>JNDIUsername</code> attribute for Kodo notification.</p>
 <p>When getting the value of this attribute, WebLogic Server does the following:</p>
 <ul>
 <li>Retrieves the value of the <code>JNDIPasswordEncrypted</code> attribute.</li>
 <li>Decrypts the value and returns the unencrypted password as a String. </li>
 </ul>
 
 <p>When you set the value of this attribute, WebLogic Server does the following:</p>
 <ul>
 <li>Encrypts the value.</li>
 <li>Sets the value of the <code>JNDIPasswordEncrypted</code> attribute to the encrypted value.</li>
 </ul>
 
 <p>Using this attribute (<code>JNDIPassword</code>) is a potential security risk because the String object
 (which contains the unencrypted password) remains in the JVM's memory until garbage collection removes it
 and the memory is reallocated. Depending on how memory is allocated in the JVM, a significant amount of time
 could pass before this unencrypted data is removed from memory.</p>
 
 <p>Instead of using this attribute, use <code>JNDIPasswordEncrypted</code>.</p>
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=getJNDIPassword)
   *
   * @xsdgen:element.exclude
   * @transient
   */
  public String getJNDIPassword() {
    byte[] bEncrypted = getJNDIPasswordEncrypted();
    return (bEncrypted == null) ? null : _decrypt("JNDIPassword", bEncrypted);
  }

  /**
   * 
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=isJNDIPasswordInherited)
   *
   * return true if the value of property JNDIPassword is inherited from template
   */
  public boolean isJNDIPasswordInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=isJNDIPasswordSet)
   *
   * @xsdgen:isSetMethodFor jndi-password
   */
  public boolean isJNDIPasswordSet() {
    return isJNDIPasswordEncryptedSet();
  }

  /**
   * Sets the value of the JNDIPassword attribute.
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=setJNDIPassword)
   *
   */
  public void setJNDIPassword(String param0)
    throws javax.management.InvalidAttributeValueException
  {
    param0 = (param0 == null) ? null : param0.trim();
    setJNDIPasswordEncrypted(param0 == null ? null : _encrypt("JNDIPassword", param0));
  }

  /**
   * <p>Returns the encrypted password to authenticate the user defined in the <code>JNDIUsername</code> attribute for
 Kodo notification.</p>
 
 <p>To set this attribute, use <code>weblogic.management.EncryptionHelper.encrypt()</code> to encrypt the
 value. Then set this attribute to the output of the encrypt() method.</p>
 
 <p>To compare a password that a user enters with the encrypted value of this attribute, go to the same
 WebLogic Server instance that you used to set and encrypt this attribute and use
 <code>weblogic.management.EncryptionHelper.encrypt()</code> to encrypt the user-supplied password.
 Then compare the encrypted values.</p>
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=getJNDIPasswordEncrypted)
   *
   * @xsdgen:element.exclude
   */
  public byte[] getJNDIPasswordEncrypted() {
    return _getHelper()._cloneArray(_JNDIPasswordEncrypted);
  }

  /**
   * 
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=getJNDIPasswordEncryptedAsString)
   *
   * @xsdgen:element.name jndi-password-encrypted
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   */
  public String getJNDIPasswordEncryptedAsString() {
    byte[] obj = getJNDIPasswordEncrypted();
    return (obj == null) ? null : (new String(obj));
  }

  /**
   * 
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=isJNDIPasswordEncryptedInherited)
   *
   * return true if the value of property JNDIPasswordEncrypted is inherited from template
   */
  public boolean isJNDIPasswordEncryptedInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=isJNDIPasswordEncryptedSet)
   *
   * @xsdgen:isSetMethodFor jndi-password-encrypted
   */
  public boolean isJNDIPasswordEncryptedSet() {
    return _isSet(7);
  }

  /**
   * 
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=setJNDIPasswordEncryptedAsString)
   *
   */
  public void setJNDIPasswordEncryptedAsString(String param0) {
    try {
    byte[] encryptedBytes = (param0 == null) ? null : param0.getBytes();
    setJNDIPasswordEncrypted(encryptedBytes);
    } catch (Exception e) {
      if (e instanceof RuntimeException)
        throw (RuntimeException)e;
      throw new java.lang.reflect.UndeclaredThrowableException(e);
    }
  }

  /**
   * <p>The URL of the database to which to connect. The format of the URL varies by JDBC driver.</p>
 
 <p>The URL is passed to the JDBC driver to create the physical database connections.</p>
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=getConnectionURL)
   *
   * @xsdgen:element.name connection-url
   * @xsdgen:element.nillable false
   * @xsdgen:element.minLength 1
   * @dynamic false
   */
  public String getConnectionURL() {
    return _ConnectionURL;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=isConnectionURLInherited)
   *
   * return true if the value of property ConnectionURL is inherited from template
   */
  public boolean isConnectionURLInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=isConnectionURLSet)
   *
   * @xsdgen:isSetMethodFor connection-url
   */
  public boolean isConnectionURLSet() {
    return _isSet(8);
  }

  /**
   * <p>Sets the value of the ConnectionURL attribute.</p>
 
 <p>The string value must be explicitly specified and satisfy the constraint (value != null) &&
 (value.trim().length() > 0.</p>
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=setConnectionURL)
   *
   */
  public void setConnectionURL(String param0)
    throws javax.management.InvalidAttributeValueException
  {
    param0 = (param0 == null) ? null : param0.trim();
    LegalChecks.checkNonEmptyString("ConnectionURL", param0);
    LegalChecks.checkNonNull("ConnectionURL", param0);
    String _oldVal = _ConnectionURL;
    _ConnectionURL = param0;
    _postSet(8, _oldVal, param0);
  }

  /**
   * <p>The full package name of the JDBC driver class used to create the physical database connections in the
 connection pool. Note that this driver class must be in the classpath of any server to which it is deployed.</p>
 
 <p>For example:</p>
 <ul>
 <li><code>oracle.jdbc.OracleDriver</code></li>
 <li><code>com.microsoft.sqlserver.jdbc.SQLServerDriver</code></li>
 </ul>
 <p>It must be the name of a class that implements the <code>java.sql.Driver</code> interface. The full
 pathname of the JDBC driver is available in the documentation. </p>
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=getDriverName)
   *
   * @xsdgen:element.name driver-name
   * @xsdgen:element.nillable false
   * @xsdgen:element.minLength 1
   * @dynamic false
   */
  public String getDriverName() {
    return _DriverName;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=isDriverNameInherited)
   *
   * return true if the value of property DriverName is inherited from template
   */
  public boolean isDriverNameInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=isDriverNameSet)
   *
   * @xsdgen:isSetMethodFor driver-name
   */
  public boolean isDriverNameSet() {
    return _isSet(9);
  }

  /**
   * <p>Sets the value of the DriverName attribute.</p>
 
 <p>The string value must be explicitly specified and satisfy the constraint (value != null) &&
 (value.trim().length() > 0.</p>
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=setDriverName)
   *
   */
  public void setDriverName(String param0)
    throws javax.management.InvalidAttributeValueException
  {
    param0 = (param0 == null) ? null : param0.trim();
    LegalChecks.checkNonEmptyString("DriverName", param0);
    LegalChecks.checkNonNull("DriverName", param0);
    String _oldVal = _DriverName;
    _DriverName = param0;
    _postSet(9, _oldVal, param0);
  }

  /**
   * <p>The JDBC driver specific connection parameters. This attribute is a comma-delimited list of key-value
 properties to pass to the driver for configuration of JDBC connection pool, in the form of <code><i>xx</i>Key=<i>xx</i>Value,
 <i>xx</i>Key=<i>xx</i>Value</code>.</p>
 
 <p>The syntax of the attribute will be validated and an <code>InvalidAttributeValueException</code> is thrown
 if the check failed.</p>
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=getConnectionProperties)
   *
   * @xsdgen:element.name connection-properties
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @dynamic false
   */
  public String getConnectionProperties() {
    return _ConnectionProperties;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=isConnectionPropertiesInherited)
   *
   * return true if the value of property ConnectionProperties is inherited from template
   */
  public boolean isConnectionPropertiesInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=isConnectionPropertiesSet)
   *
   * @xsdgen:isSetMethodFor connection-properties
   */
  public boolean isConnectionPropertiesSet() {
    return _isSet(10);
  }

  /**
   * Sets the value of the ConnectionProperties attribute.
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=setConnectionProperties)
   *
   */
  public void setConnectionProperties(String param0)
    throws javax.management.InvalidAttributeValueException
  {
    param0 = (param0 == null) ? null : param0.trim();
    RDBMSSecurityStoreValidator.validateProperties(param0);
    String _oldVal = _ConnectionProperties;
    _ConnectionProperties = param0;
    _postSet(10, _oldVal, param0);
  }

  /**
   * The JMS topic to which the Kodo remote commit provider should publish notifications and subscribe 
 for notifications sent from other JVMs. This setting varies depending on the application server in use.
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=getJMSTopic)
   *
   * @xsdgen:element.name jms-topic
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @dynamic false
   */
  public String getJMSTopic() {
    return _JMSTopic;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=isJMSTopicInherited)
   *
   * return true if the value of property JMSTopic is inherited from template
   */
  public boolean isJMSTopicInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=isJMSTopicSet)
   *
   * @xsdgen:isSetMethodFor jms-topic
   */
  public boolean isJMSTopicSet() {
    return _isSet(11);
  }

  /**
   * Sets the value of the JMSTopic attribute.
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=setJMSTopic)
   *
   */
  public void setJMSTopic(String param0)
    throws javax.management.InvalidAttributeValueException
  {
    param0 = (param0 == null) ? null : param0.trim();
    String _oldVal = _JMSTopic;
    _JMSTopic = param0;
    _postSet(11, _oldVal, param0);
  }

  /**
   * <p>The JNDI name of a <code>javax.jms.TopicConnectionFactory</code> instance to use for finding JMS topics.</p>
 
 <p>This setting varies depending on the application server in use. Consult the JMS documentation for details
 about how this parameter should be specified.</p>
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=getJMSTopicConnectionFactory)
   *
   * @xsdgen:element.name jms-topic-connection-factory
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @dynamic false
   */
  public String getJMSTopicConnectionFactory() {
    return _JMSTopicConnectionFactory;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=isJMSTopicConnectionFactoryInherited)
   *
   * return true if the value of property JMSTopicConnectionFactory is inherited from template
   */
  public boolean isJMSTopicConnectionFactoryInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=isJMSTopicConnectionFactorySet)
   *
   * @xsdgen:isSetMethodFor jms-topic-connection-factory
   */
  public boolean isJMSTopicConnectionFactorySet() {
    return _isSet(12);
  }

  /**
   * Sets the value of the JMSTopicConnectionFactory attribute.
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=setJMSTopicConnectionFactory)
   *
   */
  public void setJMSTopicConnectionFactory(String param0)
    throws javax.management.InvalidAttributeValueException
  {
    param0 = (param0 == null) ? null : param0.trim();
    String _oldVal = _JMSTopicConnectionFactory;
    _JMSTopicConnectionFactory = param0;
    _postSet(12, _oldVal, param0);
  }

  /**
   * <p>The number of times to attempt to reconnect if the JMS system notifies Kodo of a serious connection
 error.</p>
 
 <p>The default is 0, and by default the error is logged but ignored. The value cannot be less than 0.</p>
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=getJMSExceptionReconnectAttempts)
   *
   * @xsdgen:element.name jms-exception-reconnect-attempts
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @xsdgen:element.minInclusive 0
   * @xsdgen:element.default 0
   * @dynamic false
   */
  public int getJMSExceptionReconnectAttempts() {
    return _JMSExceptionReconnectAttempts;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=isJMSExceptionReconnectAttemptsInherited)
   *
   * return true if the value of property JMSExceptionReconnectAttempts is inherited from template
   */
  public boolean isJMSExceptionReconnectAttemptsInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=isJMSExceptionReconnectAttemptsSet)
   *
   * @xsdgen:isSetMethodFor jms-exception-reconnect-attempts
   */
  public boolean isJMSExceptionReconnectAttemptsSet() {
    return _isSet(13);
  }

  /**
   * Sets the value of the JMSExceptionReconnectAttempts attribute.
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=setJMSExceptionReconnectAttempts)
   *
   */
  public void setJMSExceptionReconnectAttempts(int param0)
    throws javax.management.InvalidAttributeValueException
  {
    LegalChecks.checkMin("JMSExceptionReconnectAttempts", param0, 0);
    int _oldVal = _JMSExceptionReconnectAttempts;
    _JMSExceptionReconnectAttempts = param0;
    _postSet(13, _oldVal, param0);
  }

  /**
   * <p>The comma-delimited list of key-value properties to pass to the JNDI InitialContext on construction,
 in the form of <code><i>xx</i>Key=<i>xx</i>Value, <i>xx</i>Key=<i>xx</i>Value</code>.</p>
 
 <p>The following are examples of keys:</p>
 <ul>
 <li><code>java.naming.provider.url:</code> property for specifying configuration information for the service provider
 to use. The value of the property should contain a URL string (For example: <code>iiops://localhost:7002</code>).</li>
 <li><code>java.naming.factory.initial:</code> property for specifying the initial context factory to use. The value of
 the property should be the fully qualified class name of the factory class that will create an initial
 context (For example: <code>weblogic.jndi.WLInitialContextFactory</code>).</li>
 </ul>
 
 <p>When setting the attribute, the syntax of its value is validated, and an
 <code>InvalidAttributeValueException</code> is thrown if the check fails.</p>
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=getNotificationProperties)
   *
   * @xsdgen:element.name notification-properties
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @dynamic false
   */
  public String getNotificationProperties() {
    return _NotificationProperties;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=isNotificationPropertiesInherited)
   *
   * return true if the value of property NotificationProperties is inherited from template
   */
  public boolean isNotificationPropertiesInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=isNotificationPropertiesSet)
   *
   * @xsdgen:isSetMethodFor notification-properties
   */
  public boolean isNotificationPropertiesSet() {
    return _isSet(14);
  }

  /**
   * Sets the value of the NotificationProperties attribute.
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=setNotificationProperties)
   *
   */
  public void setNotificationProperties(String param0)
    throws javax.management.InvalidAttributeValueException
  {
    param0 = (param0 == null) ? null : param0.trim();
    RDBMSSecurityStoreValidator.validateProperties(param0);
    String _oldVal = _NotificationProperties;
    _NotificationProperties = param0;
    _postSet(14, _oldVal, param0);
  }

  /**
   * Returns the realm that contains this RDBMS security store. Returns null if this RDBMS security store is
 not contained by a realm.
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=getRealm)
   *
   * @xsdgen:element.exclude
   * @transient
   */
  public RealmMBean getRealm() {
    return _customizer.getRealm();
  }

  /**
   * 
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=isRealmInherited)
   *
   * return true if the value of property Realm is inherited from template
   */
  public boolean isRealmInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=isRealmSet)
   *
   * @xsdgen:isSetMethodFor realm
   */
  public boolean isRealmSet() {
    return _isSet(15);
  }

  /**
   * 
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=setRealm)
   *
   */
  public void setRealm(RealmMBean param0)
    throws javax.management.InvalidAttributeValueException
  {
    _Realm = param0;
  }

  /**
   * The name of this configuration.
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=getName)
   *
   * @xsdgen:element.name name
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @xsdgen:element.default RDBMSSecurityStore
   * @dynamic false
   */
  public String getName() {
    return _Name;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=isNameInherited)
   *
   * return true if the value of property Name is inherited from template
   */
  public boolean isNameInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=isNameSet)
   *
   * @xsdgen:isSetMethodFor name
   */
  public boolean isNameSet() {
    return _isSet(16);
  }

  /**
   * 
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=setName)
   *
   */
  public void setName(String param0)
    throws javax.management.InvalidAttributeValueException
  {
    param0 = (param0 == null) ? null : param0.trim();
    String _oldVal = _Name;
    _Name = param0;
    _postSet(16, _oldVal, param0);
  }

  /**
   * 
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=getCompatibilityObjectName)
   *
   * @xsdgen:element.name compatibility-object-name
   * @xsdgen:element.required false
   * @xsdgen:element.nillable true
   * @dynamic false
   */
  public String getCompatibilityObjectName() {
    return _customizer.getCompatibilityObjectName();
  }

  /**
   * 
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=isCompatibilityObjectNameInherited)
   *
   * return true if the value of property CompatibilityObjectName is inherited from template
   */
  public boolean isCompatibilityObjectNameInherited() {
    return false;
  }

  /**
   * 
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=isCompatibilityObjectNameSet)
   *
   * @xsdgen:isSetMethodFor compatibility-object-name
   */
  public boolean isCompatibilityObjectNameSet() {
    return _isSet(17);
  }

  /**
   * 
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=setCompatibilityObjectName)
   *
   */
  public void setCompatibilityObjectName(String param0)
    throws javax.management.InvalidAttributeValueException
  {
    param0 = (param0 == null) ? null : param0.trim();
    String _oldVal = _CompatibilityObjectName;
    _CompatibilityObjectName = param0;
    _postSet(17, _oldVal, param0);
  }

  /**
   * 
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=_getKey)
   *
   */
  public Object _getKey() {
    return super._getKey();
  }

  /**
   * 
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=_validate)
   *
   */
  public void _validate()
    throws IllegalArgumentException
  {
    super._validate();
    weblogic.descriptor.beangen.LegalChecks.checkIsSet("ConnectionURL", isConnectionURLSet());
    weblogic.descriptor.beangen.LegalChecks.checkIsSet("DriverName", isDriverNameSet());
    weblogic.descriptor.beangen.LegalChecks.checkIsSet("Username", isUsernameSet());
  }

  /**
   * 
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=setJNDIPasswordEncrypted)
   *
   */
  public void setJNDIPasswordEncrypted(byte[] param0) {
    byte[] _oldVal = _JNDIPasswordEncrypted;
    if(_isProductionModeEnabled()) {
      if(param0 != null && !_isEncrypted(param0)) {
        throw new IllegalArgumentException("In production mode, it's not allowed to set a clear text value to the property: JNDIPasswordEncrypted of RDBMSSecurityStoreMBean");
      }
    }
    _getHelper()._clearArray(_JNDIPasswordEncrypted);
    _JNDIPasswordEncrypted = _getHelper()._cloneArray(param0);
    _postSet(7, _oldVal, param0);
  }

  /**
   * 
   * (Interface=weblogic.management.security.RDBMSSecurityStoreMBean Attribute=setPasswordEncrypted)
   *
   */
  public void setPasswordEncrypted(byte[] param0) {
    byte[] _oldVal = _PasswordEncrypted;
    if(_isProductionModeEnabled()) {
      if(param0 != null && !_isEncrypted(param0)) {
        throw new IllegalArgumentException("In production mode, it's not allowed to set a clear text value to the property: PasswordEncrypted of RDBMSSecurityStoreMBean");
      }
    }
    _getHelper()._clearArray(_PasswordEncrypted);
    _PasswordEncrypted = _getHelper()._cloneArray(param0);
    _postSet(4, _oldVal, param0);
  }



 





  protected void _unSet(int idx) {
    if (!_initializeProperty(idx)) {
      super._unSet(idx);
    } else {
      _markSet(idx, false);
      if (idx == 6) _markSet(7, false);
      if (idx == 3) _markSet(4, false);
    }
  }


  /**
   * @return new instance of helper
   */
  protected AbstractDescriptorBeanHelper _createHelper() {
    return new Helper(this);
  }

  /**
   * @return true if any property is set
   */
  public boolean _isAnythingSet() {
    return super._isAnythingSet()
      ;
  }



  /**
   * @return true if property initialized, false idx refers to a property
   * handled by superclass
   */
  private boolean _initializeProperty(int idx) {
    boolean initOne = idx > -1;
    if (!initOne) {
      idx = 17;
    }
    try {
      switch (idx) {
      case 17:
        _CompatibilityObjectName = null;
        if (initOne) break;
      case 10:
        _ConnectionProperties = null;
        if (initOne) break;
      case 8:
        _ConnectionURL = null;
        if (initOne) break;
      case 9:
        _DriverName = null;
        if (initOne) break;
      case 13:
        _JMSExceptionReconnectAttempts = 0;
        if (initOne) break;
      case 11:
        _JMSTopic = null;
        if (initOne) break;
      case 12:
        _JMSTopicConnectionFactory = null;
        if (initOne) break;
      case 6:
        _JNDIPasswordEncrypted = null;
        if (initOne) break;
      case 7:
        _JNDIPasswordEncrypted = null;
        if (initOne) break;
      case 5:
        _JNDIUsername = null;
        if (initOne) break;
      case 16:
        _Name = "RDBMSSecurityStore";
        if (initOne) break;
      case 14:
        _NotificationProperties = null;
        if (initOne) break;
      case 3:
        _PasswordEncrypted = null;
        if (initOne) break;
      case 4:
        _PasswordEncrypted = null;
        if (initOne) break;
      case 15:
        _Realm = null;
        if (initOne) break;
      case 2:
        _Username = null;
        if (initOne) break;
      default:
        if (initOne) return false;
      }
      return true;
    } catch (RuntimeException e) {
      throw e;
    } catch (Exception e) {
      throw (Error)new AssertionError("Impossible Exception").initCause(e);
    }
  }


  /**
   * This helper class contains methods that are used infrequently and
   * can be easily separated from the bean implementations.  It is loaded
   * on demand to minimize memory usage.
   *
   * @xsdgen:complexType.exclude
   */
  protected static class Helper
    extends weblogic.management.commo.AbstractCommoConfigurationBean.Helper
  {
    private RDBMSSecurityStoreMBeanImpl bean;

    protected Helper(RDBMSSecurityStoreMBeanImpl bean) {
      super(bean);
      this.bean = bean;
    }

    /**
     * @return property name indexed by propIndex.
     */
    public String getPropertyName(int propIndex) {
      switch (propIndex) {
      case 17: return "CompatibilityObjectName";
      case 10: return "ConnectionProperties";
      case 8: return "ConnectionURL";
      case 9: return "DriverName";
      case 13: return "JMSExceptionReconnectAttempts";
      case 11: return "JMSTopic";
      case 12: return "JMSTopicConnectionFactory";
      case 6: return "JNDIPassword";
      case 7: return "JNDIPasswordEncrypted";
      case 5: return "JNDIUsername";
      case 16: return "Name";
      case 14: return "NotificationProperties";
      case 3: return "Password";
      case 4: return "PasswordEncrypted";
      case 15: return "Realm";
      case 2: return "Username";
      default: return super.getPropertyName(propIndex);
      }
    }


    /**
     * @return property index of propName.
     */
    public int getPropertyIndex(String propName) {
      if (false) return -1;
      else if (propName.equals("CompatibilityObjectName")) return 17;
      else if (propName.equals("ConnectionProperties")) return 10;
      else if (propName.equals("ConnectionURL")) return 8;
      else if (propName.equals("DriverName")) return 9;
      else if (propName.equals("JMSExceptionReconnectAttempts")) return 13;
      else if (propName.equals("JMSTopic")) return 11;
      else if (propName.equals("JMSTopicConnectionFactory")) return 12;
      else if (propName.equals("JNDIPassword")) return 6;
      else if (propName.equals("JNDIPasswordEncrypted")) return 7;
      else if (propName.equals("JNDIUsername")) return 5;
      else if (propName.equals("Name")) return 16;
      else if (propName.equals("NotificationProperties")) return 14;
      else if (propName.equals("Password")) return 3;
      else if (propName.equals("PasswordEncrypted")) return 4;
      else if (propName.equals("Realm")) return 15;
      else if (propName.equals("Username")) return 2;
      else return super.getPropertyIndex(propName);
    }

    /**
     * @return iterator over all children
     */
    public Iterator getChildren() {
      List iterators = new ArrayList();
      return new CombinedIterator(iterators);
    }

    /**
     * Compute hash value for version helper
     */
    protected long computeHashValue(CRC32 crc) {
      try {
        StringBuffer buf = new StringBuffer();
        long superValue = super.computeHashValue(crc);
        if (superValue != 0) {
          buf.append(String.valueOf(superValue));
        }

        long childValue = 0;
        if (bean.isCompatibilityObjectNameSet()){
          buf.append("CompatibilityObjectName");
          buf.append(String.valueOf(bean.getCompatibilityObjectName()));
        }
        if (bean.isConnectionPropertiesSet()){
          buf.append("ConnectionProperties");
          buf.append(String.valueOf(bean.getConnectionProperties()));
        }
        if (bean.isConnectionURLSet()){
          buf.append("ConnectionURL");
          buf.append(String.valueOf(bean.getConnectionURL()));
        }
        if (bean.isDriverNameSet()){
          buf.append("DriverName");
          buf.append(String.valueOf(bean.getDriverName()));
        }
        if (bean.isJMSExceptionReconnectAttemptsSet()){
          buf.append("JMSExceptionReconnectAttempts");
          buf.append(String.valueOf(bean.getJMSExceptionReconnectAttempts()));
        }
        if (bean.isJMSTopicSet()){
          buf.append("JMSTopic");
          buf.append(String.valueOf(bean.getJMSTopic()));
        }
        if (bean.isJMSTopicConnectionFactorySet()){
          buf.append("JMSTopicConnectionFactory");
          buf.append(String.valueOf(bean.getJMSTopicConnectionFactory()));
        }
        if (bean.isJNDIPasswordSet()){
          buf.append("JNDIPassword");
          buf.append(String.valueOf(bean.getJNDIPassword()));
        }
        if (bean.isJNDIPasswordEncryptedSet()){
          buf.append("JNDIPasswordEncrypted");
          buf.append(Arrays.toString(ArrayUtils.copyAndSort(bean.getJNDIPasswordEncrypted())));
        }
        if (bean.isJNDIUsernameSet()){
          buf.append("JNDIUsername");
          buf.append(String.valueOf(bean.getJNDIUsername()));
        }
        if (bean.isNameSet()){
          buf.append("Name");
          buf.append(String.valueOf(bean.getName()));
        }
        if (bean.isNotificationPropertiesSet()){
          buf.append("NotificationProperties");
          buf.append(String.valueOf(bean.getNotificationProperties()));
        }
        if (bean.isPasswordSet()){
          buf.append("Password");
          buf.append(String.valueOf(bean.getPassword()));
        }
        if (bean.isPasswordEncryptedSet()){
          buf.append("PasswordEncrypted");
          buf.append(Arrays.toString(ArrayUtils.copyAndSort(bean.getPasswordEncrypted())));
        }
        if (bean.isRealmSet()){
          buf.append("Realm");
          buf.append(String.valueOf(bean.getRealm()));
        }
        if (bean.isUsernameSet()){
          buf.append("Username");
          buf.append(String.valueOf(bean.getUsername()));
        }
        crc.update(buf.toString().getBytes());
        return crc.getValue();
      } catch (Exception e) {
        throw (Error)new AssertionError("Impossible Exception").initCause(e);
      }
    }
    /**
     * Compute difference between this and other
     */
    protected void computeDiff(AbstractDescriptorBean other) {
      try {
        super.computeDiff(other);
      RDBMSSecurityStoreMBeanImpl otherTyped = (RDBMSSecurityStoreMBeanImpl)other;
      computeDiff("CompatibilityObjectName", bean.getCompatibilityObjectName(), otherTyped.getCompatibilityObjectName(), false);
      computeDiff("ConnectionProperties", bean.getConnectionProperties(), otherTyped.getConnectionProperties(), false);
      computeDiff("ConnectionURL", bean.getConnectionURL(), otherTyped.getConnectionURL(), false);
      computeDiff("DriverName", bean.getDriverName(), otherTyped.getDriverName(), false);
      computeDiff("JMSExceptionReconnectAttempts", bean.getJMSExceptionReconnectAttempts(), otherTyped.getJMSExceptionReconnectAttempts(), false);
      computeDiff("JMSTopic", bean.getJMSTopic(), otherTyped.getJMSTopic(), false);
      computeDiff("JMSTopicConnectionFactory", bean.getJMSTopicConnectionFactory(), otherTyped.getJMSTopicConnectionFactory(), false);
      computeDiff("JNDIPasswordEncrypted", bean.getJNDIPasswordEncrypted(), otherTyped.getJNDIPasswordEncrypted(), false);
      computeDiff("JNDIUsername", bean.getJNDIUsername(), otherTyped.getJNDIUsername(), false);
      computeDiff("Name", bean.getName(), otherTyped.getName(), false);
      computeDiff("NotificationProperties", bean.getNotificationProperties(), otherTyped.getNotificationProperties(), false);
      computeDiff("PasswordEncrypted", bean.getPasswordEncrypted(), otherTyped.getPasswordEncrypted(), false);
      computeDiff("Username", bean.getUsername(), otherTyped.getUsername(), false);
      } catch (Exception e) {
        throw (Error)new AssertionError("Impossible Exception").initCause(e);
      }
    }

    protected void applyPropertyUpdate(BeanUpdateEvent event, PropertyUpdate update) {
      try {
        RDBMSSecurityStoreMBeanImpl original = (RDBMSSecurityStoreMBeanImpl)event.getSourceBean();
        RDBMSSecurityStoreMBeanImpl proposed = (RDBMSSecurityStoreMBeanImpl)event.getProposedBean();
        String prop = update.getPropertyName();
        int type = update.getUpdateType();
        if (update.isDerivedUpdate()) {
          return;
        }
        if (prop.equals("CompatibilityObjectName")) {
          original._conditionalUnset(update.isUnsetUpdate(), 17);
        } else
        if (prop.equals("ConnectionProperties")) {
          original.setConnectionProperties(proposed.getConnectionProperties());
          original._conditionalUnset(update.isUnsetUpdate(), 10);
        } else
        if (prop.equals("ConnectionURL")) {
          original.setConnectionURL(proposed.getConnectionURL());
          original._conditionalUnset(update.isUnsetUpdate(), 8);
        } else
        if (prop.equals("DriverName")) {
          original.setDriverName(proposed.getDriverName());
          original._conditionalUnset(update.isUnsetUpdate(), 9);
        } else
        if (prop.equals("JMSExceptionReconnectAttempts")) {
          original.setJMSExceptionReconnectAttempts(proposed.getJMSExceptionReconnectAttempts());
          original._conditionalUnset(update.isUnsetUpdate(), 13);
        } else
        if (prop.equals("JMSTopic")) {
          original.setJMSTopic(proposed.getJMSTopic());
          original._conditionalUnset(update.isUnsetUpdate(), 11);
        } else
        if (prop.equals("JMSTopicConnectionFactory")) {
          original.setJMSTopicConnectionFactory(proposed.getJMSTopicConnectionFactory());
          original._conditionalUnset(update.isUnsetUpdate(), 12);
        } else
        if (prop.equals("JNDIPassword")) {
        } else
        if (prop.equals("JNDIPasswordEncrypted")) {
          original.setJNDIPasswordEncrypted(proposed.getJNDIPasswordEncrypted());
          original._conditionalUnset(update.isUnsetUpdate(), 7);
        } else
        if (prop.equals("JNDIUsername")) {
          original.setJNDIUsername(proposed.getJNDIUsername());
          original._conditionalUnset(update.isUnsetUpdate(), 5);
        } else
        if (prop.equals("Name")) {
          original.setName(proposed.getName());
          original._conditionalUnset(update.isUnsetUpdate(), 16);
        } else
        if (prop.equals("NotificationProperties")) {
          original.setNotificationProperties(proposed.getNotificationProperties());
          original._conditionalUnset(update.isUnsetUpdate(), 14);
        } else
        if (prop.equals("Password")) {
        } else
        if (prop.equals("PasswordEncrypted")) {
          original.setPasswordEncrypted(proposed.getPasswordEncrypted());
          original._conditionalUnset(update.isUnsetUpdate(), 4);
        } else
        if (prop.equals("Realm")) {
        } else
        if (prop.equals("Username")) {
          original.setUsername(proposed.getUsername());
          original._conditionalUnset(update.isUnsetUpdate(), 2);
        } else
        {
          super.applyPropertyUpdate(event, update);
        }
      // FIXME ehalpern - hack to handle cases where setters throw
      // javax.management.InvalidAttributeValueException.
      } catch (RuntimeException e) {
        throw e;
      } catch (Exception e) {
        throw (Error)new AssertionError("Impossible Exception").initCause(e);
      }
    }

    protected AbstractDescriptorBean finishCopy(
    AbstractDescriptorBean initialCopy, boolean includeObsolete, List excludeProps
    ) {
      Object o;
      try {
        RDBMSSecurityStoreMBeanImpl copy = (RDBMSSecurityStoreMBeanImpl)initialCopy;
        super.finishCopy(copy, includeObsolete, excludeProps);
        if ((excludeProps == null || !excludeProps.contains("CompatibilityObjectName")) && bean.isCompatibilityObjectNameSet()) {
        }
        if ((excludeProps == null || !excludeProps.contains("ConnectionProperties")) && bean.isConnectionPropertiesSet()) {
          copy.setConnectionProperties((String)bean.getConnectionProperties());
        }
        if ((excludeProps == null || !excludeProps.contains("ConnectionURL")) && bean.isConnectionURLSet()) {
          copy.setConnectionURL((String)bean.getConnectionURL());
        }
        if ((excludeProps == null || !excludeProps.contains("DriverName")) && bean.isDriverNameSet()) {
          copy.setDriverName((String)bean.getDriverName());
        }
        if ((excludeProps == null || !excludeProps.contains("JMSExceptionReconnectAttempts")) && bean.isJMSExceptionReconnectAttemptsSet()) {
          copy.setJMSExceptionReconnectAttempts((int)bean.getJMSExceptionReconnectAttempts());
        }
        if ((excludeProps == null || !excludeProps.contains("JMSTopic")) && bean.isJMSTopicSet()) {
          copy.setJMSTopic((String)bean.getJMSTopic());
        }
        if ((excludeProps == null || !excludeProps.contains("JMSTopicConnectionFactory")) && bean.isJMSTopicConnectionFactorySet()) {
          copy.setJMSTopicConnectionFactory((String)bean.getJMSTopicConnectionFactory());
        }
        if ((excludeProps == null || !excludeProps.contains("JNDIPasswordEncrypted")) && bean.isJNDIPasswordEncryptedSet()) {
          o = bean.getJNDIPasswordEncrypted();
          copy.setJNDIPasswordEncrypted((o == null) ? null : (byte[])((byte[])o).clone());
        }
        if ((excludeProps == null || !excludeProps.contains("JNDIUsername")) && bean.isJNDIUsernameSet()) {
          copy.setJNDIUsername((String)bean.getJNDIUsername());
        }
        if ((excludeProps == null || !excludeProps.contains("Name")) && bean.isNameSet()) {
          copy.setName((String)bean.getName());
        }
        if ((excludeProps == null || !excludeProps.contains("NotificationProperties")) && bean.isNotificationPropertiesSet()) {
          copy.setNotificationProperties((String)bean.getNotificationProperties());
        }
        if ((excludeProps == null || !excludeProps.contains("PasswordEncrypted")) && bean.isPasswordEncryptedSet()) {
          o = bean.getPasswordEncrypted();
          copy.setPasswordEncrypted((o == null) ? null : (byte[])((byte[])o).clone());
        }
        if ((excludeProps == null || !excludeProps.contains("Username")) && bean.isUsernameSet()) {
          copy.setUsername((String)bean.getUsername());
        }
        return copy;
      // FIXME ehalpern - hack to handle cases where setters throw
      // javax.management.InvalidAttributeValueException.
      } catch (RuntimeException e) {
        throw e;
      } catch (Exception e) {
        throw (Error)new AssertionError("Impossible Exception").initCause(e);
      }
    }

    protected void inferSubTree(Class clazz, Object annotation) {
    	super.inferSubTree(clazz, annotation);
    	Object currentAnnotation = null;
                                           		inferSubTree(bean.getRealm(), clazz, annotation);
          }
  }


  // FIXME ec@weblogic.com 01-Feb-05 -- no longer used. Remove when ADB method is removed
  public weblogic.descriptor.internal.Munger.SchemaHelper _getSchemaHelper() {
    return null;
  }

  // FIXME ec@weblogic.com 01-Feb-05 -- remove
  public String _getElementName(int propIndex) {
    return _getSchemaHelper2().getElementName(propIndex);
  }

  protected String getSchemaLocation() {
    return "http://xmlns.oracle.com/weblogic/1.0/security.xsd";
  }

  protected String getTargetNamespace() {
    return "http://xmlns.oracle.com/weblogic/security";
  }

  private static SchemaHelper2 _schemaHelper;
  public weblogic.descriptor.internal.SchemaHelper _getSchemaHelper2() {
    if (_schemaHelper == null)
	_schemaHelper = new SchemaHelper2();
    return _schemaHelper;
  }

   // new schema helper
  /**
   * @xsdgen:complexType.exclude
   */
  public static class SchemaHelper2
   extends weblogic.descriptor.internal.AbstractSchemaHelper2
   implements weblogic.descriptor.internal.SchemaHelper
  {
    public int getPropertyIndex(String s) {
      switch(s.length()) {
      case 25:
        if (false) return -1;
        else if (s.equals("compatibility-object-name"))
          return 17;
        break;
      case 21:
        if (false) return -1;
        else if (s.equals("connection-properties"))
          return 10;
        break;
      case 14:
        if (false) return -1;
        else if (s.equals("connection-url"))
          return 8;
        break;
      case 11:
        if (false) return -1;
        else if (s.equals("driver-name"))
          return 9;
        break;
      case 32:
        if (false) return -1;
        else if (s.equals("jms-exception-reconnect-attempts"))
          return 13;
        break;
      case 9:
        if (false) return -1;
        else if (s.equals("jms-topic"))
          return 11;
        break;
      case 28:
        if (false) return -1;
        else if (s.equals("jms-topic-connection-factory"))
          return 12;
        break;
      case 13:
        if (false) return -1;
        else if (s.equals("jndi-password"))
          return 6;
        else if (s.equals("jndi-username"))
          return 5;
        break;
      case 23:
        if (false) return -1;
        else if (s.equals("jndi-password-encrypted"))
          return 7;
        else if (s.equals("notification-properties"))
          return 14;
        break;
      case 4:
        if (false) return -1;
        else if (s.equals("name"))
          return 16;
        break;
      case 8:
        if (false) return -1;
        else if (s.equals("password"))
          return 3;
        else if (s.equals("username"))
          return 2;
        break;
      case 18:
        if (false) return -1;
        else if (s.equals("password-encrypted"))
          return 4;
        break;
      case 5:
        if (false) return -1;
        else if (s.equals("realm"))
          return 15;
        break;
      default:
        break;
      }
      return super.getPropertyIndex(s);
    }

    public weblogic.descriptor.internal.SchemaHelper getSchemaHelper(int propIndex) {
      switch(propIndex) {
      default:
        return super.getSchemaHelper(propIndex);
      }
    }



    public String getElementName(int propIndex) {
      switch (propIndex) {
        case 17: return "compatibility-object-name";
        case 10: return "connection-properties";
        case 8: return "connection-url";
        case 9: return "driver-name";
        case 13: return "jms-exception-reconnect-attempts";
        case 11: return "jms-topic";
        case 12: return "jms-topic-connection-factory";
        case 6: return "jndi-password";
        case 7: return "jndi-password-encrypted";
        case 5: return "jndi-username";
        case 16: return "name";
        case 14: return "notification-properties";
        case 3: return "password";
        case 4: return "password-encrypted";
        case 15: return "realm";
        case 2: return "username";
        default: return super.getElementName(propIndex);
      }
    }


    public boolean isArray(int propIndex) {
      switch(propIndex) {
      default:
        return super.isArray(propIndex);
      }
    }




    public boolean isBean(int propIndex) {
      switch(propIndex) {
      default:
        return super.isBean(propIndex);
      }
    }










  }




  public String wls_getInterfaceClassName() {
    return "weblogic.management.security.RDBMSSecurityStoreMBean"; 
  }

}
